/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.service.impl.notification;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.gameplay.Notification;
import com.almasb.fxgl.gameplay.NotificationEvent;
import com.almasb.fxgl.service.NotificationService;
import com.almasb.fxgl.time.Timer;
import com.almasb.fxgl.ui.Position;
import com.google.inject.Inject;
import java.util.ArrayDeque;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.controlsfx.control.NotificationPane;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\b\u0003\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004H\u0016J\b\u0010\u0012\u001a\u00020\u000bH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u000eH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/almasb/fxgl/service/impl/notification/SlidingNotificationService;", "Lcom/almasb/fxgl/service/NotificationService;", "()V", "backgroundColor", "Ljavafx/scene/paint/Color;", "kotlin.jvm.PlatformType", "counter", "", "notificationImpl", "Lorg/controlsfx/control/NotificationPane;", "position", "Lcom/almasb/fxgl/ui/Position;", "queue", "Ljava/util/ArrayDeque;", "", "showing", "", "getBackgroundColor", "getPosition", "popNotification", "", "pushNotification", "text", "setBackgroundColor", "setPosition", "showNotification", "fxgl"})
public final class SlidingNotificationService
implements NotificationService {
    private final ArrayDeque<String> queue = new ArrayDeque();
    private Position position = Position.TOP;
    private Color backgroundColor = Color.BLACK;
    private boolean showing;
    private final NotificationPane notificationImpl = new NotificationPane();
    private int counter;

    @Override
    @NotNull
    public Position getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(@NotNull Position position2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)position2), (String)"position");
        this.position = position2;
        if (Intrinsics.areEqual((Object)((Object)position2), (Object)((Object)Position.BOTTOM))) {
            this.notificationImpl.setShowFromTop(false);
            this.notificationImpl.setTranslateY((double)FXGL.Companion.getSettings().getHeight() - 50.0);
        } else {
            this.notificationImpl.setShowFromTop(true);
            this.notificationImpl.setTranslateY(0.0);
        }
    }

    @Override
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public void setBackgroundColor(@NotNull Color backgroundColor) {
        Intrinsics.checkParameterIsNotNull((Object)backgroundColor, (String)"backgroundColor");
        this.backgroundColor = backgroundColor;
    }

    private final void popNotification() {
        boolean removed = FXGL.Companion.getApp().getGameScene().removeUINode((Node)this.notificationImpl);
        if (!removed) {
            return;
        }
        if (!this.queue.isEmpty()) {
            String string = this.queue.poll();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"queue.poll()");
            this.showNotification(string);
        } else {
            this.showing = false;
        }
    }

    @Override
    public void pushNotification(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        if (this.showing) {
            this.queue.add(text);
        } else {
            this.showNotification(text);
        }
    }

    private final void showNotification(String text) {
        int n = this.counter;
        this.counter = n + 1;
        this.showing = true;
        FXGL.Companion.getApp().getGameScene().addUINode((Node)this.notificationImpl);
        Timer timer2 = FXGL.Companion.getMasterTimer();
        Function0 function0 = (Function0)new Function0<Unit>(this, text){
            final /* synthetic */ SlidingNotificationService this$0;
            final /* synthetic */ String $text;

            public final void invoke() {
                SlidingNotificationService.access$getNotificationImpl$p(this.this$0).show(this.$text);
            }
            {
                this.this$0 = slidingNotificationService;
                this.$text = string;
                super(0);
            }
        };
        Duration duration = Duration.seconds((double)0.03);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.seconds(0.03)");
        timer2.runOnceAfter((Function0<Unit>)function0, duration);
        FXGL.Companion.getEventBus().fireEvent(new NotificationEvent(new Notification(text)));
        int id = this.counter;
        Timer timer3 = FXGL.Companion.getMasterTimer();
        Function0 function02 = (Function0)new Function0<Unit>(this, id){
            final /* synthetic */ SlidingNotificationService this$0;
            final /* synthetic */ int $id;

            public final void invoke() {
                if (this.$id == SlidingNotificationService.access$getCounter$p(this.this$0)) {
                    SlidingNotificationService.access$getNotificationImpl$p(this.this$0).hide();
                }
            }
            {
                this.this$0 = slidingNotificationService;
                this.$id = n;
                super(0);
            }
        };
        Duration duration2 = Duration.seconds((double)3.0);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.seconds(3.0)");
        timer3.runOnceAfter((Function0<Unit>)function02, duration2);
    }

    @Inject
    private SlidingNotificationService() {
        Pane pane = new Pane();
        pane.setPrefSize((double)FXGL.Companion.getSettings().getWidth(), 50.0);
        this.notificationImpl.getStyleClass().add((Object)"dark");
        this.notificationImpl.setContent((Node)pane);
        this.notificationImpl.setOnHidden((EventHandler)new EventHandler<Event>(){

            public final void handle(Event it) {
                this.popNotification();
            }
        });
    }

    @NotNull
    public static final /* synthetic */ NotificationPane access$getNotificationImpl$p(SlidingNotificationService $this) {
        return $this.notificationImpl;
    }

    public static final /* synthetic */ int access$getCounter$p(SlidingNotificationService $this) {
        return $this.counter;
    }

    public static final /* synthetic */ void access$setCounter$p(SlidingNotificationService $this, int n) {
        $this.counter = n;
    }
}

