/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.AppState;
import com.almasb.fxgl.app.DialogSubState;
import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.app.GameApplication;
import com.almasb.fxgl.app.GameMenuState;
import com.almasb.fxgl.app.IntroState;
import com.almasb.fxgl.app.LoadingState;
import com.almasb.fxgl.app.MainMenuState;
import com.almasb.fxgl.app.PlayState;
import com.almasb.fxgl.app.StartupState;
import com.almasb.fxgl.app.State;
import com.almasb.fxgl.app.SubState;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.saving.DataFile;
import com.almasb.fxgl.scene.SceneFactory;
import java.util.ArrayDeque;
import java.util.Deque;

public final class AppStateMachine {
    private static final Logger log = Logger.get(AppStateMachine.class);
    private final AppState loading;
    private final AppState play;
    private final AppState intro;
    private final AppState mainMenu;
    private final AppState gameMenu;
    private AppState appState;
    private Deque<SubState> subStates = new ArrayDeque<SubState>();
    private GameApplication app;

    AppStateMachine(GameApplication app) {
        this.app = app;
        log.debug("Initializing application states");
        SceneFactory sceneFactory = FXGL.getSettings().getSceneFactory();
        this.appState = new StartupState(app);
        this.loading = new LoadingState(app, sceneFactory);
        this.play = new PlayState(sceneFactory);
        DialogSubState.INSTANCE.getView();
        this.intro = app.getSettings().isIntroEnabled() ? new IntroState(app, sceneFactory) : null;
        this.mainMenu = app.getSettings().isMenuEnabled() ? new MainMenuState(sceneFactory) : null;
        this.gameMenu = app.getSettings().isMenuEnabled() ? new GameMenuState(sceneFactory) : null;
    }

    void setState(AppState newState) {
        if (!this.subStates.isEmpty()) {
            log.warning("Cannot change states with active substates");
            return;
        }
        AppState prevState = this.appState;
        prevState.exit();
        log.debug(prevState + " -> " + newState);
        this.appState = newState;
        this.app.setScene(this.appState.getScene());
        this.appState.enter(prevState);
    }

    void onUpdate(double tpf) {
        this.getCurrentState().update(tpf);
    }

    public void pushState(SubState newState) {
        log.debug("Push state: " + newState);
        State prevState = this.getCurrentState();
        prevState.getInput().clearAll();
        log.debug(prevState + " -> " + newState);
        this.subStates.push(newState);
        this.app.getScene().getRoot().getChildren().add((Object)newState.getView());
        newState.enter(prevState);
    }

    public void popState() {
        if (this.subStates.isEmpty()) {
            log.warning("Cannot pop state: Substates are empty!");
            return;
        }
        SubState prevState = this.subStates.pop();
        log.debug("Pop state: " + prevState);
        prevState.exit();
        log.debug(this.getCurrentState() + " <- " + prevState);
        this.app.getScene().getRoot().getChildren().remove((Object)prevState.getView());
    }

    public State getCurrentState() {
        return this.subStates.isEmpty() ? this.appState : (State)this.subStates.peek();
    }

    public State getIntroState() {
        if (this.intro == null) {
            throw new IllegalStateException("Intro is not enabled");
        }
        return this.intro;
    }

    public State getLoadingState() {
        return this.loading;
    }

    public State getMainMenuState() {
        if (this.mainMenu == null) {
            throw new IllegalStateException("Menu is not enabled");
        }
        return this.mainMenu;
    }

    public State getGameMenuState() {
        if (this.gameMenu == null) {
            throw new IllegalStateException("Menu is not enabled");
        }
        return this.gameMenu;
    }

    public State getPlayState() {
        return this.play;
    }

    public State getDialogState() {
        return DialogSubState.INSTANCE;
    }

    void startIntro() {
        this.setState(this.intro);
    }

    void startLoad(DataFile dataFile) {
        ((LoadingState)this.loading).setDataFile(dataFile);
        this.setState(this.loading);
    }

    void startGameMenu() {
        this.setState(this.gameMenu);
    }

    void startMainMenu() {
        this.setState(this.mainMenu);
    }

    void startPlay() {
        this.setState(this.play);
    }

    public boolean isInPlay() {
        return this.getCurrentState() == this.getPlayState();
    }

    public boolean isInGameMenu() {
        return this.getCurrentState() == this.getGameMenuState();
    }

    public boolean canShowCloseDialog() {
        return this.getCurrentState() != DialogSubState.INSTANCE && this.getCurrentState() != this.getLoadingState() && (!FXGL.getApp().getSettings().isIntroEnabled() || this.getCurrentState() != this.getIntroState());
    }
}

