/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.ApplicationMode;
import com.almasb.fxgl.app.GameApplication;
import com.almasb.fxgl.settings.ReadOnlyGameSettings;
import com.google.inject.AbstractModule;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;

public class ApplicationModule
extends AbstractModule {
    private GameApplication app;
    private ReadOnlyGameSettings settings;

    ApplicationModule(GameApplication app) {
        this.app = app;
        this.settings = app.getSettings();
    }

    public GameApplication getApp() {
        return this.app;
    }

    protected final void configure() {
        this.bindApp();
        this.bindServices();
    }

    private void bindApp() {
        this.bind(GameApplication.class).toInstance((Object)this.app);
        this.bind(ReadOnlyGameSettings.class).toInstance((Object)this.settings);
        this.bind(ApplicationMode.class).toInstance((Object)this.settings.getApplicationMode());
        this.bind(Integer.class).annotatedWith((Annotation)Names.named((String)"appWidth")).toInstance((Object)this.app.getWidth());
        this.bind(Integer.class).annotatedWith((Annotation)Names.named((String)"appHeight")).toInstance((Object)this.app.getHeight());
    }

    protected void bindServices() {
    }
}

