/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.ApplicationModule;
import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.app.GameApplication;
import com.almasb.fxgl.asset.AssetLoader;
import com.almasb.fxgl.audio.AudioPlayer;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.event.EventBus;
import com.almasb.fxgl.gameplay.Gameplay;
import com.almasb.fxgl.input.Input;
import com.almasb.fxgl.io.FS;
import com.almasb.fxgl.io.serialization.Bundle;
import com.almasb.fxgl.service.ExceptionHandler;
import com.almasb.fxgl.service.NotificationService;
import com.almasb.fxgl.service.UIFactory;
import com.almasb.fxgl.service.impl.display.FXGLDisplay;
import com.almasb.fxgl.service.impl.executor.FXGLExecutor;
import com.almasb.fxgl.service.impl.net.FXGLNet;
import com.almasb.fxgl.settings.ReadOnlyGameSettings;
import com.almasb.fxgl.time.LocalTimer;
import com.almasb.fxgl.time.OfflineTimer;
import com.almasb.fxgl.time.Timer;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00032\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0005"}, d2={"Lcom/almasb/fxgl/app/FXGL;", "", "()V", "Companion", "Properties", "fxgl"})
public final class FXGL {
    private static GameApplication internalApp;
    private static Bundle internalBundle;
    private static final Logger log;
    private static final Properties internalProperties;
    private static boolean configured;
    private static boolean firstRun;
    private static Injector injector;
    private static final Lazy _assetLoader$delegate;
    private static final Lazy _eventBus$delegate;
    private static final Lazy _audioPlayer$delegate;
    private static final Lazy _display$delegate;
    private static final Lazy _executor$delegate;
    private static final Lazy _net$delegate;
    private static final Lazy _gameplay$delegate;
    private static final Lazy _input$delegate;
    private static final Lazy _masterTimer$delegate;
    public static final Companion Companion;

    private FXGL() {
    }

    static {
        Companion = new Companion(null);
        log = Logger.Companion.get("FXGL");
        internalProperties = new Properties();
        _assetLoader$delegate = LazyKt.lazy((Function0)Companion._assetLoader.2.INSTANCE);
        _eventBus$delegate = LazyKt.lazy((Function0)Companion._eventBus.2.INSTANCE);
        _audioPlayer$delegate = LazyKt.lazy((Function0)Companion._audioPlayer.2.INSTANCE);
        _display$delegate = LazyKt.lazy((Function0)Companion._display.2.INSTANCE);
        _executor$delegate = LazyKt.lazy((Function0)Companion._executor.2.INSTANCE);
        _net$delegate = LazyKt.lazy((Function0)Companion._net.2.INSTANCE);
        _gameplay$delegate = LazyKt.lazy((Function0)Companion._gameplay.2.INSTANCE);
        _input$delegate = LazyKt.lazy((Function0)Companion._input.2.INSTANCE);
        _masterTimer$delegate = LazyKt.lazy((Function0)Companion._masterTimer.2.INSTANCE);
    }

    @NotNull
    public static final /* synthetic */ GameApplication access$getInternalApp$cp() {
        GameApplication gameApplication = internalApp;
        if (gameApplication == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"internalApp");
        }
        return gameApplication;
    }

    @NotNull
    public static final /* synthetic */ Bundle access$getInternalBundle$cp() {
        Bundle bundle = internalBundle;
        if (bundle == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"internalBundle");
        }
        return bundle;
    }

    @NotNull
    public static final /* synthetic */ Injector access$getInjector$cp() {
        Injector injector = FXGL.injector;
        if (injector == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"injector");
        }
        return injector;
    }

    @JvmStatic
    public static final ReadOnlyGameSettings getSettings() {
        return Companion.getSettings();
    }

    @JvmStatic
    @NotNull
    public static final GameApplication getApp() {
        return Companion.getApp();
    }

    @JvmStatic
    public static final int getAppWidth() {
        return Companion.getAppWidth();
    }

    @JvmStatic
    public static final int getAppHeight() {
        return Companion.getAppHeight();
    }

    @JvmStatic
    @NotNull
    public static final <T extends GameApplication> T getAppCast() {
        return Companion.getAppCast();
    }

    @JvmStatic
    @NotNull
    public static final Bundle getSystemBundle() {
        return Companion.getSystemBundle();
    }

    @JvmStatic
    public static final void configure(@NotNull ApplicationModule appModule, Module ... modules) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)appModule), (String)"appModule");
        Intrinsics.checkParameterIsNotNull((Object)modules, (String)"modules");
        Companion.configure(appModule, modules);
    }

    @JvmStatic
    public static final boolean isFirstRun() {
        return Companion.isFirstRun();
    }

    @JvmStatic
    protected static final void destroy() {
        Companion.destroy();
    }

    @JvmStatic
    public static final <T> T getInstance(@NotNull Class<T> type) {
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        return Companion.getInstance(type);
    }

    @JvmStatic
    public static final AssetLoader getAssetLoader() {
        return Companion.getAssetLoader();
    }

    @JvmStatic
    @NotNull
    public static final EventBus getEventBus() {
        return Companion.getEventBus();
    }

    @JvmStatic
    public static final AudioPlayer getAudioPlayer() {
        return Companion.getAudioPlayer();
    }

    @JvmStatic
    @NotNull
    public static final FXGLDisplay getDisplay() {
        return Companion.getDisplay();
    }

    @JvmStatic
    public static final NotificationService getNotificationService() {
        return Companion.getNotificationService();
    }

    @JvmStatic
    @NotNull
    public static final FXGLExecutor getExecutor() {
        return Companion.getExecutor();
    }

    @JvmStatic
    @NotNull
    public static final FXGLNet getNet() {
        return Companion.getNet();
    }

    @JvmStatic
    public static final ExceptionHandler getExceptionHandler() {
        return Companion.getExceptionHandler();
    }

    @JvmStatic
    public static final UIFactory getUIFactory() {
        return Companion.getUIFactory();
    }

    @JvmStatic
    public static final Gameplay getGameplay() {
        return Companion.getGameplay();
    }

    @JvmStatic
    public static final Input getInput() {
        return Companion.getInput();
    }

    @JvmStatic
    @NotNull
    public static final LocalTimer newLocalTimer() {
        return Companion.newLocalTimer();
    }

    @JvmStatic
    @NotNull
    public static final LocalTimer newOfflineTimer(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return Companion.newOfflineTimer(name);
    }

    @JvmStatic
    public static final Timer getMasterTimer() {
        return Companion.getMasterTimer();
    }

    @JvmStatic
    public static final int getInt(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return Companion.getInt(key);
    }

    @JvmStatic
    public static final double getDouble(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return Companion.getDouble(key);
    }

    @JvmStatic
    public static final boolean getBoolean(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return Companion.getBoolean(key);
    }

    @JvmStatic
    @NotNull
    public static final String getString(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return Companion.getString(key);
    }

    @JvmStatic
    public static final void setProperty(@NotNull String key, @NotNull Object value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Companion.setProperty(key, value);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0013\u001a\u00020\u0014R-\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR-\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR-\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR-\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0011`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/almasb/fxgl/app/FXGL$Properties;", "", "()V", "booleanMap", "Ljava/util/HashMap;", "Lcom/google/inject/name/Named;", "", "Lkotlin/collections/HashMap;", "getBooleanMap", "()Ljava/util/HashMap;", "doubleMap", "", "getDoubleMap", "intMap", "", "getIntMap", "stringMap", "", "getStringMap", "clear", "", "fxgl"})
    private static final class Properties {
        @NotNull
        private final HashMap<Named, Integer> intMap;
        @NotNull
        private final HashMap<Named, Double> doubleMap;
        @NotNull
        private final HashMap<Named, Boolean> booleanMap;
        @NotNull
        private final HashMap<Named, String> stringMap;

        @NotNull
        public final HashMap<Named, Integer> getIntMap() {
            return this.intMap;
        }

        @NotNull
        public final HashMap<Named, Double> getDoubleMap() {
            return this.doubleMap;
        }

        @NotNull
        public final HashMap<Named, Boolean> getBooleanMap() {
            return this.booleanMap;
        }

        @NotNull
        public final HashMap<Named, String> getStringMap() {
            return this.stringMap;
        }

        public final void clear() {
            this.intMap.clear();
            this.doubleMap.clear();
            this.booleanMap.clear();
            this.stringMap.clear();
        }

        public Properties() {
            Properties properties = this;
            HashMap hashMap = new HashMap();
            properties.intMap = hashMap;
            properties = this;
            hashMap = new HashMap();
            properties.doubleMap = hashMap;
            properties = this;
            hashMap = new HashMap();
            properties.booleanMap = hashMap;
            properties = this;
            hashMap = new HashMap();
            properties.stringMap = hashMap;
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u00e6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010U\u001a\u00020VH\u0002J)\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020Z2\u0012\u0010[\u001a\n\u0012\u0006\b\u0001\u0012\u00020V0\\\"\u00020VH\u0007\u00a2\u0006\u0002\u0010]J\b\u0010^\u001a\u00020XH\u0002J\b\u0010_\u001a\u00020XH\u0005J\b\u0010`\u001a\u00020BH\u0007J\u0017\u0010a\u001a\u0002Hb\"\b\b\u0000\u0010b*\u00020BH\u0007\u00a2\u0006\u0002\u0010DJ\b\u0010c\u001a\u00020dH\u0007J\b\u0010e\u001a\u00020dH\u0007J\u0010\u0010f\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004H\u0007J\u0010\u0010g\u001a\n \u0005*\u0004\u0018\u00010\u000b0\u000bH\u0007J\u0010\u0010h\u001a\u0002032\u0006\u0010i\u001a\u00020jH\u0007J\b\u0010k\u001a\u00020\u0010H\u0007J\u0010\u0010l\u001a\u00020m2\u0006\u0010i\u001a\u00020jH\u0007J\b\u0010n\u001a\u00020\u0015H\u0007J\u0010\u0010o\u001a\n \u0005*\u0004\u0018\u00010p0pH\u0007J\b\u0010q\u001a\u00020\u001aH\u0007J\u0010\u0010r\u001a\n \u0005*\u0004\u0018\u00010\u001f0\u001fH\u0007J\u0010\u0010s\u001a\n \u0005*\u0004\u0018\u00010$0$H\u0007J)\u0010t\u001a\n \u0005*\u0004\u0018\u0001HbHb\"\u0004\b\u0000\u0010b2\f\u0010u\u001a\b\u0012\u0004\u0012\u0002Hb0vH\u0007\u00a2\u0006\u0002\u0010wJ\u0010\u0010x\u001a\u00020d2\u0006\u0010i\u001a\u00020jH\u0007J\u0010\u0010y\u001a\n \u0005*\u0004\u0018\u00010)0)H\u0007J\b\u0010z\u001a\u00020.H\u0007J\u0010\u0010{\u001a\n \u0005*\u0004\u0018\u00010|0|H\u0007J\u0010\u0010}\u001a\u00020j2\u0006\u0010i\u001a\u00020jH\u0002J\u0010\u0010~\u001a\n \u0005*\u0004\u0018\u00010\u007f0\u007fH\u0007J\u0011\u0010\u0080\u0001\u001a\u00020j2\u0006\u0010i\u001a\u00020jH\u0007J\t\u0010\u0081\u0001\u001a\u00020HH\u0007J\u0013\u0010\u0082\u0001\u001a\f \u0005*\u0005\u0018\u00010\u0083\u00010\u0083\u0001H\u0007J\t\u0010\u0084\u0001\u001a\u000203H\u0007J\t\u0010\u0085\u0001\u001a\u00020XH\u0002J\t\u0010\u0086\u0001\u001a\u00020XH\u0002J\n\u0010\u0087\u0001\u001a\u00030\u0088\u0001H\u0007J\u0013\u0010\u0089\u0001\u001a\u00030\u0088\u00012\u0007\u0010\u008a\u0001\u001a\u00020jH\u0007J\t\u0010\u008b\u0001\u001a\u00020XH\u0002J\u001a\u0010\u008c\u0001\u001a\u00020X2\u0006\u0010i\u001a\u00020j2\u0007\u0010\u008d\u0001\u001a\u00020\u0001H\u0007R#\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R#\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u000b0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\t\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\t\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\t\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\t\u001a\u0004\b\u001b\u0010\u001cR#\u0010\u001e\u001a\n \u0005*\u0004\u0018\u00010\u001f0\u001f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\t\u001a\u0004\b \u0010!R#\u0010#\u001a\n \u0005*\u0004\u0018\u00010$0$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\t\u001a\u0004\b%\u0010&R#\u0010(\u001a\n \u0005*\u0004\u0018\u00010)0)8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010\t\u001a\u0004\b*\u0010+R\u001b\u0010-\u001a\u00020.8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u0010\t\u001a\u0004\b/\u00100R\u001a\u00102\u001a\u000203X\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u001a\u00108\u001a\u000203X\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u00105\"\u0004\b:\u00107R\u001a\u0010;\u001a\u00020<X\u0082.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u001a\u0010A\u001a\u00020BX\u0082.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010D\"\u0004\bE\u0010FR\u001a\u0010G\u001a\u00020HX\u0082.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010J\"\u0004\bK\u0010LR\u0014\u0010M\u001a\u00020NX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010PR\u0014\u0010Q\u001a\u00020RX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bS\u0010T\u00a8\u0006\u008e\u0001"}, d2={"Lcom/almasb/fxgl/app/FXGL$Companion;", "", "()V", "_assetLoader", "Lcom/almasb/fxgl/asset/AssetLoader;", "kotlin.jvm.PlatformType", "get_assetLoader", "()Lcom/almasb/fxgl/asset/AssetLoader;", "_assetLoader$delegate", "Lkotlin/Lazy;", "_audioPlayer", "Lcom/almasb/fxgl/audio/AudioPlayer;", "get_audioPlayer", "()Lcom/almasb/fxgl/audio/AudioPlayer;", "_audioPlayer$delegate", "_display", "Lcom/almasb/fxgl/service/impl/display/FXGLDisplay;", "get_display", "()Lcom/almasb/fxgl/service/impl/display/FXGLDisplay;", "_display$delegate", "_eventBus", "Lcom/almasb/fxgl/event/EventBus;", "get_eventBus", "()Lcom/almasb/fxgl/event/EventBus;", "_eventBus$delegate", "_executor", "Lcom/almasb/fxgl/service/impl/executor/FXGLExecutor;", "get_executor", "()Lcom/almasb/fxgl/service/impl/executor/FXGLExecutor;", "_executor$delegate", "_gameplay", "Lcom/almasb/fxgl/gameplay/Gameplay;", "get_gameplay", "()Lcom/almasb/fxgl/gameplay/Gameplay;", "_gameplay$delegate", "_input", "Lcom/almasb/fxgl/input/Input;", "get_input", "()Lcom/almasb/fxgl/input/Input;", "_input$delegate", "_masterTimer", "Lcom/almasb/fxgl/time/Timer;", "get_masterTimer", "()Lcom/almasb/fxgl/time/Timer;", "_masterTimer$delegate", "_net", "Lcom/almasb/fxgl/service/impl/net/FXGLNet;", "get_net", "()Lcom/almasb/fxgl/service/impl/net/FXGLNet;", "_net$delegate", "configured", "", "getConfigured", "()Z", "setConfigured", "(Z)V", "firstRun", "getFirstRun", "setFirstRun", "injector", "Lcom/google/inject/Injector;", "getInjector", "()Lcom/google/inject/Injector;", "setInjector", "(Lcom/google/inject/Injector;)V", "internalApp", "Lcom/almasb/fxgl/app/GameApplication;", "getInternalApp", "()Lcom/almasb/fxgl/app/GameApplication;", "setInternalApp", "(Lcom/almasb/fxgl/app/GameApplication;)V", "internalBundle", "Lcom/almasb/fxgl/io/serialization/Bundle;", "getInternalBundle", "()Lcom/almasb/fxgl/io/serialization/Bundle;", "setInternalBundle", "(Lcom/almasb/fxgl/io/serialization/Bundle;)V", "internalProperties", "Lcom/almasb/fxgl/app/FXGL$Properties;", "getInternalProperties", "()Lcom/almasb/fxgl/app/FXGL$Properties;", "log", "Lcom/almasb/fxgl/core/logging/Logger;", "getLog", "()Lcom/almasb/fxgl/core/logging/Logger;", "buildPropertiesModule", "Lcom/google/inject/Module;", "configure", "", "appModule", "Lcom/almasb/fxgl/app/ApplicationModule;", "modules", "", "(Lcom/almasb/fxgl/app/ApplicationModule;[Lcom/google/inject/Module;)V", "createRequiredDirs", "destroy", "getApp", "getAppCast", "T", "getAppHeight", "", "getAppWidth", "getAssetLoader", "getAudioPlayer", "getBoolean", "key", "", "getDisplay", "getDouble", "", "getEventBus", "getExceptionHandler", "Lcom/almasb/fxgl/service/ExceptionHandler;", "getExecutor", "getGameplay", "getInput", "getInstance", "type", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "getInt", "getMasterTimer", "getNet", "getNotificationService", "Lcom/almasb/fxgl/service/NotificationService;", "getProperty", "getSettings", "Lcom/almasb/fxgl/settings/ReadOnlyGameSettings;", "getString", "getSystemBundle", "getUIFactory", "Lcom/almasb/fxgl/service/UIFactory;", "isFirstRun", "loadDefaultSystemData", "loadSystemData", "newLocalTimer", "Lcom/almasb/fxgl/time/LocalTimer;", "newOfflineTimer", "name", "saveSystemData", "setProperty", "value", "fxgl"})
    public static final class Companion {
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        private final GameApplication getInternalApp() {
            return FXGL.access$getInternalApp$cp();
        }

        private final void setInternalApp(GameApplication gameApplication) {
            internalApp = gameApplication;
        }

        private final Bundle getInternalBundle() {
            return FXGL.access$getInternalBundle$cp();
        }

        private final void setInternalBundle(Bundle bundle) {
            internalBundle = bundle;
        }

        private final Logger getLog() {
            return log;
        }

        private final Properties getInternalProperties() {
            return internalProperties;
        }

        private final boolean getConfigured() {
            return configured;
        }

        private final void setConfigured(boolean bl) {
            configured = bl;
        }

        @JvmStatic
        public final ReadOnlyGameSettings getSettings() {
            return this.getInternalApp().getSettings();
        }

        @JvmStatic
        @NotNull
        public final GameApplication getApp() {
            return this.getInternalApp();
        }

        @JvmStatic
        public final int getAppWidth() {
            return this.getInternalApp().getWidth();
        }

        @JvmStatic
        public final int getAppHeight() {
            return this.getInternalApp().getHeight();
        }

        @JvmStatic
        @NotNull
        public final <T extends GameApplication> T getAppCast() {
            GameApplication gameApplication = this.getInternalApp();
            if (gameApplication == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            return (T)((Object)gameApplication);
        }

        @JvmStatic
        @NotNull
        public final Bundle getSystemBundle() {
            return this.getInternalBundle();
        }

        @JvmStatic
        public final void configure(@NotNull ApplicationModule appModule, Module ... modules) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)appModule), (String)"appModule");
            Intrinsics.checkParameterIsNotNull((Object)modules, (String)"modules");
            if (this.getConfigured()) {
                return;
            }
            this.setConfigured(true);
            GameApplication gameApplication = appModule.getApp();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)gameApplication), (String)"appModule.app");
            this.setInternalApp(gameApplication);
            this.createRequiredDirs();
            ArrayList allModules = CollectionsKt.arrayListOf((Object[])Arrays.copyOf(modules, modules.length));
            allModules.add(this.buildPropertiesModule());
            allModules.add(appModule);
            Injector injector = Guice.createInjector((Iterable)allModules);
            Intrinsics.checkExpressionValueIsNotNull((Object)injector, (String)"Guice.createInjector(allModules)");
            this.setInjector(injector);
            if (this.getFirstRun()) {
                this.loadDefaultSystemData();
            } else {
                this.loadSystemData();
            }
        }

        private final boolean getFirstRun() {
            return firstRun;
        }

        private final void setFirstRun(boolean bl) {
            firstRun = bl;
        }

        @JvmStatic
        public final boolean isFirstRun() {
            return this.getFirstRun();
        }

        private final void createRequiredDirs() {
            Path systemDir = Paths.get("system/", new String[0]);
            if (!Files.exists(systemDir, new LinkOption[0])) {
                this.setFirstRun(true);
                Files.createDirectories(systemDir, new FileAttribute[0]);
                Path readmeFile = Paths.get("system/Readme.txt", new String[0]);
                Files.write(readmeFile, (Iterable<? extends CharSequence>)StringsKt.lines((CharSequence)"This directory contains FXGL system data files."), new OpenOption[0]);
            }
        }

        private final void saveSystemData() {
            this.getLog().debug("Saving FXGL system data");
            FS.Companion.writeDataTask(this.getInternalBundle(), "system/fxgl.bundle").onFailure(saveSystemData.1.INSTANCE).execute();
        }

        private final void loadSystemData() {
            this.getLog().debug("Loading FXGL system data");
            FS.Companion.readDataTask("system/fxgl.bundle").onSuccess(loadSystemData.1.INSTANCE).onFailure(loadSystemData.2.INSTANCE).execute();
        }

        private final void loadDefaultSystemData() {
            this.getLog().debug("Loading default FXGL system data");
            this.setInternalBundle(new Bundle("FXGL"));
        }

        @JvmStatic
        protected final void destroy() {
            if (!this.getConfigured()) {
                throw (Throwable)new IllegalStateException("FXGL has not been configured");
            }
            this.saveSystemData();
        }

        private final Injector getInjector() {
            return FXGL.access$getInjector$cp();
        }

        private final void setInjector(Injector injector) {
            FXGL.injector = injector;
        }

        @JvmStatic
        public final <T> T getInstance(@NotNull Class<T> type) {
            Intrinsics.checkParameterIsNotNull(type, (String)"type");
            return (T)this.getInjector().getInstance(type);
        }

        private final Module buildPropertiesModule() {
            return (Module)new AbstractModule(){

                protected void configure() {
                    Map k;
                    Map.Entry<K, V> entry;
                    Map.Entry<K, V> entry2;
                    Map map2 = com.almasb.fxgl.app.FXGL$Companion.access$getInternalProperties$p(FXGL.Companion).getIntMap();
                    Iterator<Map.Entry<K, V>> iterator = map2.entrySet().iterator();
                    while (iterator.hasNext()) {
                        entry = entry2 = iterator.next();
                        k = (Named)entry.getKey();
                        entry = entry2;
                        int v = ((Number)entry.getValue()).intValue();
                        this.bind(Integer.TYPE).annotatedWith((Annotation)((Object)k)).toInstance((Object)v);
                    }
                    k = com.almasb.fxgl.app.FXGL$Companion.access$getInternalProperties$p(FXGL.Companion).getDoubleMap();
                    iterator = k.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<K, V> entry3 = entry2 = iterator.next();
                        k = (Named)entry3.getKey();
                        entry3 = entry2;
                        double v = ((Number)entry3.getValue()).doubleValue();
                        this.bind(Double.TYPE).annotatedWith((Annotation)((Object)k)).toInstance((Object)v);
                    }
                    k = com.almasb.fxgl.app.FXGL$Companion.access$getInternalProperties$p(FXGL.Companion).getBooleanMap();
                    iterator = k.entrySet().iterator();
                    while (iterator.hasNext()) {
                        entry = entry2 = iterator.next();
                        k = (Named)entry.getKey();
                        entry = entry2;
                        boolean v = (Boolean)entry.getValue();
                        this.bind(Boolean.TYPE).annotatedWith((Annotation)((Object)k)).toInstance((Object)v);
                    }
                    k = com.almasb.fxgl.app.FXGL$Companion.access$getInternalProperties$p(FXGL.Companion).getStringMap();
                    iterator = k.entrySet().iterator();
                    while (iterator.hasNext()) {
                        entry = entry2 = iterator.next();
                        k = (Named)entry.getKey();
                        entry = entry2;
                        String v = (String)entry.getValue();
                        this.bind(String.class).annotatedWith((Annotation)((Object)k)).toInstance((Object)v);
                    }
                    com.almasb.fxgl.app.FXGL$Companion.access$getInternalProperties$p(FXGL.Companion).clear();
                }
            };
        }

        private final AssetLoader get_assetLoader() {
            Lazy lazy = _assetLoader$delegate;
            Companion companion = this;
            KProperty kProperty = $$delegatedProperties[0];
            return (AssetLoader)lazy.getValue();
        }

        @JvmStatic
        public final AssetLoader getAssetLoader() {
            return this.get_assetLoader();
        }

        private final EventBus get_eventBus() {
            Lazy lazy = _eventBus$delegate;
            Companion companion = this;
            KProperty kProperty = $$delegatedProperties[1];
            return (EventBus)lazy.getValue();
        }

        @JvmStatic
        @NotNull
        public final EventBus getEventBus() {
            return this.get_eventBus();
        }

        private final AudioPlayer get_audioPlayer() {
            Lazy lazy = _audioPlayer$delegate;
            Companion companion = this;
            KProperty kProperty = $$delegatedProperties[2];
            return (AudioPlayer)lazy.getValue();
        }

        @JvmStatic
        public final AudioPlayer getAudioPlayer() {
            return this.get_audioPlayer();
        }

        private final FXGLDisplay get_display() {
            Lazy lazy = _display$delegate;
            Companion companion = this;
            KProperty kProperty = $$delegatedProperties[3];
            return (FXGLDisplay)lazy.getValue();
        }

        @JvmStatic
        @NotNull
        public final FXGLDisplay getDisplay() {
            return this.get_display();
        }

        @JvmStatic
        public final NotificationService getNotificationService() {
            return this.getSettings().getNotificationService();
        }

        private final FXGLExecutor get_executor() {
            Lazy lazy = _executor$delegate;
            Companion companion = this;
            KProperty kProperty = $$delegatedProperties[4];
            return (FXGLExecutor)lazy.getValue();
        }

        @JvmStatic
        @NotNull
        public final FXGLExecutor getExecutor() {
            return this.get_executor();
        }

        private final FXGLNet get_net() {
            Lazy lazy = _net$delegate;
            Companion companion = this;
            KProperty kProperty = $$delegatedProperties[5];
            return (FXGLNet)lazy.getValue();
        }

        @JvmStatic
        @NotNull
        public final FXGLNet getNet() {
            return this.get_net();
        }

        @JvmStatic
        public final ExceptionHandler getExceptionHandler() {
            return this.getSettings().getExceptionHandler();
        }

        @JvmStatic
        public final UIFactory getUIFactory() {
            return this.getSettings().getUIFactory();
        }

        private final Gameplay get_gameplay() {
            Lazy lazy = _gameplay$delegate;
            Companion companion = this;
            KProperty kProperty = $$delegatedProperties[6];
            return (Gameplay)lazy.getValue();
        }

        @JvmStatic
        public final Gameplay getGameplay() {
            return this.get_gameplay();
        }

        private final Input get_input() {
            Lazy lazy = _input$delegate;
            Companion companion = this;
            KProperty kProperty = $$delegatedProperties[7];
            return (Input)lazy.getValue();
        }

        @JvmStatic
        public final Input getInput() {
            return this.get_input();
        }

        @JvmStatic
        @NotNull
        public final LocalTimer newLocalTimer() {
            return this.getInternalApp().getStateMachine().getPlayState().getTimer().newLocalTimer();
        }

        @JvmStatic
        @NotNull
        public final LocalTimer newOfflineTimer(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            return new OfflineTimer(name);
        }

        private final Timer get_masterTimer() {
            Lazy lazy = _masterTimer$delegate;
            Companion companion = this;
            KProperty kProperty = $$delegatedProperties[8];
            return (Timer)lazy.getValue();
        }

        @JvmStatic
        public final Timer getMasterTimer() {
            return this.get_masterTimer();
        }

        @JvmStatic
        public final int getInt(@NotNull String key) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            return Integer.parseInt(this.getProperty(key));
        }

        @JvmStatic
        public final double getDouble(@NotNull String key) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            return Double.parseDouble(this.getProperty(key));
        }

        @JvmStatic
        public final boolean getBoolean(@NotNull String key) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            return Boolean.parseBoolean(this.getProperty(key));
        }

        @JvmStatic
        @NotNull
        public final String getString(@NotNull String key) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            return this.getProperty(key);
        }

        private final String getProperty(String key) {
            String string = System.getProperty("FXGL." + key);
            if (string == null) {
                throw (Throwable)new IllegalArgumentException("Key \"" + key + "\" not found!");
            }
            return string;
        }

        @JvmStatic
        public final void setProperty(@NotNull String key, @NotNull Object value) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            System.setProperty("FXGL." + key, value.toString());
            if (!this.getConfigured()) {
                if (Intrinsics.areEqual((Object)value, (Object)"true") || Intrinsics.areEqual((Object)value, (Object)"false")) {
                    Map map2 = this.getInternalProperties().getBooleanMap();
                    Named named = Names.named((String)key);
                    Intrinsics.checkExpressionValueIsNotNull((Object)named, (String)"Names.named(key)");
                    Named named2 = named;
                    Boolean bl = Boolean.parseBoolean((String)value);
                    map2.put(named2, bl);
                } else {
                    try {
                        Map map3 = this.getInternalProperties().getIntMap();
                        Named named = Names.named((String)key);
                        Intrinsics.checkExpressionValueIsNotNull((Object)named, (String)"Names.named(key)");
                        Named named3 = named;
                        Integer n = Integer.parseInt(value.toString());
                        map3.put(named3, n);
                    }
                    catch (Exception e) {
                        try {
                            Map map4 = this.getInternalProperties().getDoubleMap();
                            Named named = Names.named((String)key);
                            Intrinsics.checkExpressionValueIsNotNull((Object)named, (String)"Names.named(key)");
                            Named named4 = named;
                            Double d = Double.parseDouble(value.toString());
                            map4.put(named4, d);
                        }
                        catch (Exception e2) {
                            Map map5 = this.getInternalProperties().getStringMap();
                            Named named = Names.named((String)key);
                            Intrinsics.checkExpressionValueIsNotNull((Object)named, (String)"Names.named(key)");
                            Named named5 = named;
                            String string = value.toString();
                            map5.put(named5, string);
                        }
                    }
                }
            }
        }

        private Companion() {
        }

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "_assetLoader", "get_assetLoader()Lcom/almasb/fxgl/asset/AssetLoader;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "_eventBus", "get_eventBus()Lcom/almasb/fxgl/event/EventBus;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "_audioPlayer", "get_audioPlayer()Lcom/almasb/fxgl/audio/AudioPlayer;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "_display", "get_display()Lcom/almasb/fxgl/service/impl/display/FXGLDisplay;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "_executor", "get_executor()Lcom/almasb/fxgl/service/impl/executor/FXGLExecutor;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "_net", "get_net()Lcom/almasb/fxgl/service/impl/net/FXGLNet;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "_gameplay", "get_gameplay()Lcom/almasb/fxgl/gameplay/Gameplay;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "_input", "get_input()Lcom/almasb/fxgl/input/Input;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "_masterTimer", "get_masterTimer()Lcom/almasb/fxgl/time/Timer;"))};
        }

        @NotNull
        public static final /* synthetic */ Logger access$getLog$p(Companion $this) {
            return $this.getLog();
        }

        @NotNull
        public static final /* synthetic */ Bundle access$getInternalBundle$p(Companion $this) {
            return $this.getInternalBundle();
        }

        public static final /* synthetic */ void access$setInternalBundle$p(Companion $this, @NotNull Bundle bundle) {
            $this.setInternalBundle(bundle);
        }

        public static final /* synthetic */ void access$loadDefaultSystemData(Companion $this) {
            $this.loadDefaultSystemData();
        }

        @NotNull
        public static final /* synthetic */ Properties access$getInternalProperties$p(Companion $this) {
            return $this.getInternalProperties();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @NotNull
        public static final /* synthetic */ GameApplication access$getInternalApp$p(Companion $this) {
            return $this.getInternalApp();
        }

        public static final /* synthetic */ void access$setInternalApp$p(Companion $this, @NotNull GameApplication gameApplication) {
            $this.setInternalApp(gameApplication);
        }
    }
}

