/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.AppStateMachine;
import com.almasb.fxgl.app.ApplicationModule;
import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.app.MainWindow;
import com.almasb.fxgl.app.MenuEventHandler;
import com.almasb.fxgl.app.PlayState;
import com.almasb.fxgl.app.SystemActions;
import com.almasb.fxgl.app.UpdaterTask;
import com.almasb.fxgl.app.listener.ExitListener;
import com.almasb.fxgl.app.listener.StateListener;
import com.almasb.fxgl.asset.AssetLoader;
import com.almasb.fxgl.audio.AudioPlayer;
import com.almasb.fxgl.core.concurrent.Async;
import com.almasb.fxgl.core.logging.ConsoleOutput;
import com.almasb.fxgl.core.logging.FileOutput;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.core.logging.LoggerConfig;
import com.almasb.fxgl.core.logging.LoggerLevel;
import com.almasb.fxgl.devtools.profiling.Profiler;
import com.almasb.fxgl.ecs.GameWorld;
import com.almasb.fxgl.event.EventBus;
import com.almasb.fxgl.gameplay.AchievementEvent;
import com.almasb.fxgl.gameplay.GameState;
import com.almasb.fxgl.gameplay.Gameplay;
import com.almasb.fxgl.gameplay.NotificationEvent;
import com.almasb.fxgl.input.Input;
import com.almasb.fxgl.physics.PhysicsWorld;
import com.almasb.fxgl.saving.DataFile;
import com.almasb.fxgl.saving.LoadEvent;
import com.almasb.fxgl.saving.SaveEvent;
import com.almasb.fxgl.scene.FXGLScene;
import com.almasb.fxgl.scene.GameScene;
import com.almasb.fxgl.scene.PreloadingScene;
import com.almasb.fxgl.scene.menu.MenuEventListener;
import com.almasb.fxgl.service.Display;
import com.almasb.fxgl.service.ExceptionHandler;
import com.almasb.fxgl.service.Executor;
import com.almasb.fxgl.service.Net;
import com.almasb.fxgl.service.NotificationService;
import com.almasb.fxgl.service.UIFactory;
import com.almasb.fxgl.settings.GameSettings;
import com.almasb.fxgl.settings.ReadOnlyGameSettings;
import com.almasb.fxgl.time.FPSCounter;
import com.almasb.fxgl.time.Timer;
import com.almasb.fxgl.ui.ErrorDialog;
import com.almasb.fxgl.util.Version;
import com.google.inject.Module;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyLongWrapper;
import javafx.geometry.Rectangle2D;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public abstract class GameApplication
extends Application {
    private static final Logger log = Logger.get(GameApplication.class);
    private MainWindow mainWindow;
    private ReadOnlyGameSettings settings;
    private AppStateMachine stateMachine;
    private boolean handledOnce = false;
    private AnimationTimer mainLoop;
    private ReadOnlyLongWrapper tick = new ReadOnlyLongWrapper();
    private ReadOnlyIntegerWrapper fps = new ReadOnlyIntegerWrapper();
    private double tpf;
    private FPSCounter fpsCounter = new FPSCounter();
    private Profiler profiler;
    private MenuEventHandler menuHandler;
    private List<ExitListener> exitListeners = new ArrayList<ExitListener>();
    private PlayState playState;

    public final void start(Stage stage) {
        try {
            this.initAppSettings();
            this.initLogger();
            this.initMainWindow(stage);
            this.showPreloadingStage();
            this.startFXGL();
        }
        catch (Exception e) {
            this.handleFatalErrorBeforeLaunch(e);
        }
    }

    private void initAppSettings() {
        GameSettings localSettings = new GameSettings();
        this.initSettings(localSettings);
        this.settings = localSettings.toReadOnly();
    }

    private void initLogger() {
        Logger.configure(new LoggerConfig());
        Logger.addOutput(new FileOutput("FXGL"), LoggerLevel.DEBUG);
        Logger.addOutput(new ConsoleOutput(), this.settings.getApplicationMode().getLoggerLevel());
        log.debug("Logger initialized");
    }

    private void initMainWindow(Stage stage) {
        this.mainWindow = new MainWindow(stage, this.settings);
    }

    private void showPreloadingStage() {
        Stage preloadingStage = new Stage(StageStyle.UNDECORATED);
        preloadingStage.initOwner((Window)this.mainWindow.getStage());
        preloadingStage.setScene((Scene)new PreloadingScene());
        preloadingStage.show();
        this.mainWindow.setOnShown(() -> {
            preloadingStage.close();
            this.mainWindow.setOnShown(null);
        });
    }

    private void startFXGL() {
        log.debug("Starting FXGL");
        Version.print();
        new Thread(() -> {
            try {
                this.configureFXGL();
                this.initFatalExceptionHandler();
                this.runUpdaterAndWait();
                this.configureApp();
                this.launchGame();
            }
            catch (Exception e) {
                this.handleFatalErrorBeforeLaunch(e);
            }
        }, "FXGL Launcher Thread").start();
    }

    private void configureFXGL() {
        long start2 = System.nanoTime();
        this.initSystemProperties();
        this.initUserProperties();
        FXGL.configure(new ApplicationModule(this), new Module[0]);
        log.debug("FXGL configuration complete");
        log.infof("FXGL configuration took:  %.3f sec", (double)(System.nanoTime() - start2) / 1.0E9);
        log.debug("Logging game settings\n" + this.settings.toString());
    }

    private void initSystemProperties() {
        ResourceBundle props = ResourceBundle.getBundle("com.almasb.fxgl.app.system");
        props.keySet().forEach(key -> {
            Object value = props.getObject((String)key);
            FXGL.setProperty(key, value);
        });
    }

    private void initUserProperties() {
        try (InputStream is2 = ((Object)((Object)this)).getClass().getResource("/assets/properties/system.properties").openStream();){
            PropertyResourceBundle props = new PropertyResourceBundle(is2);
            props.keySet().forEach(key -> {
                Object value = props.getObject((String)key);
                FXGL.setProperty(key, value);
            });
        }
        catch (NullPointerException is2) {
        }
        catch (IOException e) {
            log.warning("Loading user properties failed: " + e);
        }
    }

    private void initFatalExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler((t, error) -> this.handleFatalErrorAfterLaunch(error));
    }

    private void handleFatalErrorBeforeLaunch(Throwable error) {
        if (Logger.isConfigured()) {
            log.fatal("Exception during FXGL configuration:");
            log.fatal(Logger.errorTraceAsString(error));
            log.fatal("FXGL will now exit");
            Logger.close();
        } else {
            System.out.println("Exception during FXGL configuration:");
            error.printStackTrace();
            System.out.println("FXGL will now exit");
        }
        Async.startFX(() -> new ErrorDialog(error).showAndWait()).await();
        System.exit(-1);
    }

    private void handleFatalErrorAfterLaunch(Throwable error) {
        if (this.handledOnce) {
            return;
        }
        this.handledOnce = true;
        log.fatal("Uncaught Exception:");
        log.fatal(Logger.errorTraceAsString(error));
        log.fatal("Application will now exit");
        this.stopMainLoop();
        new ErrorDialog(error).showAndWait();
        this.exit();
    }

    private void runUpdaterAndWait() {
        Async.startFX(() -> new UpdaterTask().run()).await();
    }

    private void configureApp() {
        log.debug("Configuring GameApplication");
        long start2 = System.nanoTime();
        this.initStateMachine();
        this.attachEventHandlers();
        log.infof("Game configuration took:  %.3f sec", (double)(System.nanoTime() - start2) / 1.0E9);
    }

    private void initStateMachine() {
        this.stateMachine = new AppStateMachine(this);
        this.playState = (PlayState)this.stateMachine.getPlayState();
    }

    private void attachEventHandlers() {
        this.getEventBus().addEventHandler(NotificationEvent.ANY, e -> this.getAudioPlayer().onNotificationEvent((NotificationEvent)e));
        this.getEventBus().addEventHandler(AchievementEvent.ANY, e -> this.getNotificationService().onAchievementEvent((AchievementEvent)e));
        this.getEventBus().addEventHandler(SaveEvent.ANY, e -> {
            this.getAudioPlayer().save(e.getProfile());
            this.getInput().save(e.getProfile());
            this.getGameplay().save(e.getProfile());
        });
        this.getEventBus().addEventHandler(LoadEvent.ANY, e -> {
            this.getAudioPlayer().load(e.getProfile());
            this.getInput().load(e.getProfile());
            this.getGameplay().load(e.getProfile());
        });
        this.getEventBus().scanForHandlers((Object)this);
    }

    private void launchGame() {
        Async.startFX(() -> {
            this.mainWindow.initAndShow();
            this.runPreInit();
            System.gc();
            this.startMainLoop();
        });
    }

    private void runPreInit() {
        log.debug("Running preInit()");
        if (this.getSettings().isProfilingEnabled()) {
            this.profiler = new Profiler();
        }
        this.initAchievements();
        SystemActions.INSTANCE.bind(this.getInput());
        this.initInput();
        this.getInput().scanForUserActions((Object)this);
        this.generateDefaultProfile();
        this.preInit();
    }

    private void generateDefaultProfile() {
        if (this.getSettings().isMenuEnabled()) {
            this.menuHandler.generateDefaultProfile();
        }
    }

    private void startMainLoop() {
        log.debug("Starting main loop");
        this.mainLoop = new AnimationTimer(){

            public void handle(long now) {
                long frameStart = System.nanoTime();
                GameApplication.this.tpf = GameApplication.this.tickStart(now);
                GameApplication.this.tick(GameApplication.this.tpf);
                GameApplication.this.tickEnd(System.nanoTime() - frameStart);
            }
        };
        this.mainLoop.start();
    }

    private void stopMainLoop() {
        if (this.mainLoop != null) {
            log.debug("Stopping main loop");
            this.mainLoop.stop();
        }
    }

    private double tickStart(long now) {
        this.tick.set(this.tick.get() + 1L);
        this.fps.set(this.fpsCounter.update(now));
        if (this.fps.get() < 5 || this.fps.get() > 55) {
            this.fps.set(60);
        }
        return 1.0 / (double)this.fps.get();
    }

    private void tick(double tpf) {
        this.stateMachine.onUpdate(tpf);
    }

    private void tickEnd(long frameTook) {
        if (this.getSettings().isProfilingEnabled()) {
            this.profiler.update(this.fps.get(), frameTook);
            this.profiler.render(this.getGameScene().getGraphicsContext());
        }
    }

    protected void startNewGame() {
        log.debug("Starting new game");
        this.stateMachine.startLoad(DataFile.getEMPTY());
    }

    void startLoadedGame(DataFile dataFile) {
        log.debug("Starting loaded game");
        this.stateMachine.startLoad(dataFile);
    }

    protected final void exit() {
        log.debug("Exiting game application");
        this.exitListeners.forEach(ExitListener::onExit);
        if (this.getSettings().isProfilingEnabled()) {
            this.profiler.print();
        }
        log.debug("Exiting FXGL");
        FXGL.destroy();
        log.debug("Closing logger and exiting JavaFX");
        Logger.close();
        Platform.exit();
    }

    public final MenuEventListener getMenuListener() {
        if (!this.getSettings().isMenuEnabled()) {
            throw new IllegalStateException("Menus are not enabled");
        }
        if (this.menuHandler == null) {
            this.menuHandler = new MenuEventHandler(this);
        }
        return this.menuHandler;
    }

    FXGLScene getScene() {
        return this.mainWindow.getCurrentScene();
    }

    void setScene(FXGLScene scene) {
        this.mainWindow.setScene(scene);
    }

    boolean saveScreenshot() {
        return this.mainWindow.saveScreenshot();
    }

    public final void addExitListener(ExitListener listener2) {
        this.exitListeners.add(listener2);
    }

    public final void removeExitListener(ExitListener listener2) {
        this.exitListeners.remove(listener2);
    }

    public final void addPlayStateListener(StateListener listener2) {
        this.playState.addStateListener(listener2);
    }

    public final void removePlayStateListener(StateListener listener2) {
        this.playState.removeStateListener(listener2);
    }

    public final void init() {
    }

    public final void stop() {
    }

    protected abstract void initSettings(GameSettings var1);

    protected void initAchievements() {
    }

    protected void initInput() {
    }

    protected void preInit() {
    }

    protected void initAssets() {
    }

    protected void initGameVars(Map<String, Object> vars) {
    }

    protected void initGame() {
    }

    protected void initPhysics() {
    }

    protected void initUI() {
    }

    protected void onUpdate(double tpf) {
    }

    protected void onPostUpdate(double tpf) {
    }

    protected DataFile saveState() {
        log.warning("Called saveState(), but it wasn't overridden!");
        throw new UnsupportedOperationException("Default implementation is not available");
    }

    protected void loadState(DataFile dataFile) {
        log.warning("Called loadState(), but it wasn't overridden!");
        throw new UnsupportedOperationException("Default implementation is not available");
    }

    void injectSettings(ReadOnlyGameSettings settings) {
        this.settings = settings;
    }

    public final double tpf() {
        return this.tpf;
    }

    public final AppStateMachine getStateMachine() {
        return this.stateMachine;
    }

    public final GameState getGameState() {
        return this.playState.getGameState();
    }

    public final GameWorld getGameWorld() {
        return this.playState.getGameWorld();
    }

    public final PhysicsWorld getPhysicsWorld() {
        return this.playState.getPhysicsWorld();
    }

    public final GameScene getGameScene() {
        return this.playState.getGameScene();
    }

    public final Gameplay getGameplay() {
        return FXGL.getGameplay();
    }

    public final Input getInput() {
        return this.playState.getInput();
    }

    public final Timer getMasterTimer() {
        return this.playState.getTimer();
    }

    public final ReadOnlyGameSettings getSettings() {
        return this.settings;
    }

    public final int getWidth() {
        return this.getSettings().getWidth();
    }

    public final int getHeight() {
        return this.getSettings().getHeight();
    }

    public final Rectangle2D getAppBounds() {
        return new Rectangle2D(0.0, 0.0, (double)this.getWidth(), (double)this.getHeight());
    }

    public final long getTick() {
        return this.tick.get();
    }

    public final EventBus getEventBus() {
        return FXGL.getEventBus();
    }

    public final Display getDisplay() {
        return FXGL.getDisplay();
    }

    public final AudioPlayer getAudioPlayer() {
        return FXGL.getAudioPlayer();
    }

    public final AssetLoader getAssetLoader() {
        return FXGL.getAssetLoader();
    }

    public final Executor getExecutor() {
        return FXGL.getExecutor();
    }

    public final NotificationService getNotificationService() {
        return FXGL.getNotificationService();
    }

    public final Net getNet() {
        return FXGL.getNet();
    }

    public final ExceptionHandler getExceptionHandler() {
        return FXGL.getExceptionHandler();
    }

    public final UIFactory getUIFactory() {
        return FXGL.getUIFactory();
    }
}

