/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.AppState;
import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.app.MenuEventHandler;
import com.almasb.fxgl.app.PauseMenuSubState;
import com.almasb.fxgl.ecs.GameWorld;
import com.almasb.fxgl.gameplay.GameState;
import com.almasb.fxgl.input.Input;
import com.almasb.fxgl.input.UserAction;
import com.almasb.fxgl.physics.PhysicsWorld;
import com.almasb.fxgl.scene.FXGLScene;
import com.almasb.fxgl.scene.GameScene;
import com.almasb.fxgl.scene.SceneFactory;
import com.almasb.fxgl.scene.menu.MenuEventListener;
import javafx.event.EventType;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0019"}, d2={"Lcom/almasb/fxgl/app/PlayState;", "Lcom/almasb/fxgl/app/AppState;", "sceneFactory", "Lcom/almasb/fxgl/scene/SceneFactory;", "(Lcom/almasb/fxgl/scene/SceneFactory;)V", "gameScene", "Lcom/almasb/fxgl/scene/GameScene;", "getGameScene", "()Lcom/almasb/fxgl/scene/GameScene;", "gameState", "Lcom/almasb/fxgl/gameplay/GameState;", "getGameState", "()Lcom/almasb/fxgl/gameplay/GameState;", "gameWorld", "Lcom/almasb/fxgl/ecs/GameWorld;", "getGameWorld", "()Lcom/almasb/fxgl/ecs/GameWorld;", "physicsWorld", "Lcom/almasb/fxgl/physics/PhysicsWorld;", "getPhysicsWorld", "()Lcom/almasb/fxgl/physics/PhysicsWorld;", "onUpdate", "", "tpf", "", "fxgl"})
public final class PlayState
extends AppState {
    @NotNull
    private final GameState gameState;
    @NotNull
    private final GameWorld gameWorld;
    @NotNull
    private final PhysicsWorld physicsWorld;

    @NotNull
    public final GameState getGameState() {
        return this.gameState;
    }

    @NotNull
    public final GameWorld getGameWorld() {
        return this.gameWorld;
    }

    @NotNull
    public final PhysicsWorld getPhysicsWorld() {
        return this.physicsWorld;
    }

    @NotNull
    public final GameScene getGameScene() {
        FXGLScene fXGLScene = this.getScene();
        if (fXGLScene == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.almasb.fxgl.scene.GameScene");
        }
        return (GameScene)fXGLScene;
    }

    @Override
    protected void onUpdate(double tpf) {
        this.gameWorld.onUpdate(tpf);
        this.physicsWorld.onUpdate(tpf);
        this.getGameScene().onUpdate(tpf);
        FXGL.Companion.getEventBus().onUpdate(tpf);
        FXGL.Companion.getAudioPlayer().onUpdate(tpf);
        FXGL.Companion.getApp().onUpdate(tpf);
        FXGL.Companion.getApp().onPostUpdate(tpf);
        FXGL.Companion.getGameplay().getStats().onUpdate(tpf);
    }

    public PlayState(@NotNull SceneFactory sceneFactory) {
        Intrinsics.checkParameterIsNotNull((Object)sceneFactory, (String)"sceneFactory");
        super(sceneFactory.newGameScene());
        this.gameState = new GameState();
        this.gameWorld = new GameWorld();
        PhysicsWorld physicsWorld = FXGL.Companion.getInstance(PhysicsWorld.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)physicsWorld, (String)"FXGL.getInstance(PhysicsWorld::class.java)");
        this.physicsWorld = physicsWorld;
        this.gameWorld.addWorldListener(this.physicsWorld);
        this.gameWorld.addWorldListener(this.getGameScene());
        if (FXGL.Companion.getSettings().isMenuEnabled()) {
            Input input = this.getInput();
            EventType eventType = KeyEvent.ANY;
            Intrinsics.checkExpressionValueIsNotNull((Object)eventType, (String)"KeyEvent.ANY");
            MenuEventListener menuEventListener = FXGL.Companion.getApp().getMenuListener();
            if (menuEventListener == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.almasb.fxgl.app.MenuEventHandler");
            }
            input.addEventHandler(eventType, (MenuEventHandler)menuEventListener);
        } else {
            Input input = this.getInput();
            UserAction userAction = new UserAction("Pause"){

                @Override
                protected void onActionBegin() {
                    PauseMenuSubState.INSTANCE.requestShow$fxgl();
                }

                @Override
                protected void onActionEnd() {
                    PauseMenuSubState.INSTANCE.unlockSwitch$fxgl();
                }
            };
            KeyCode keyCode = FXGL.Companion.getSettings().getMenuKey();
            Intrinsics.checkExpressionValueIsNotNull((Object)keyCode, (String)"FXGL.getSettings().menuKey");
            Input.addAction$default(input, userAction, keyCode, null, 4, null);
        }
    }
}

