/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.ApplicationMode;
import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.app.UpdaterTask$checkForUpdates$;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.io.IOTask;
import com.almasb.fxgl.time.LocalTimer;
import com.almasb.fxgl.util.Version;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/almasb/fxgl/app/UpdaterTask;", "Ljava/lang/Runnable;", "()V", "log", "Lcom/almasb/fxgl/core/logging/Logger;", "updateCheckTimer", "Lcom/almasb/fxgl/time/LocalTimer;", "checkForUpdates", "", "run", "shouldCheckForUpdate", "", "fxgl"})
public final class UpdaterTask
implements Runnable {
    private final Logger log = Logger.Companion.get(this.getClass());
    private LocalTimer updateCheckTimer;

    @Override
    public void run() {
        if (this.shouldCheckForUpdate()) {
            this.checkForUpdates();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldCheckForUpdate() {
        if (FXGL.Companion.getSettings().getApplicationMode() == ApplicationMode.RELEASE) {
            return false;
        }
        this.updateCheckTimer = FXGL.Companion.newOfflineTimer("version.check");
        Duration days = Duration.hours((double)(24.0 * (double)FXGL.Companion.getInt("version.check.days")));
        if (FXGL.Companion.isFirstRun()) return true;
        LocalTimer localTimer = this.updateCheckTimer;
        if (localTimer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"updateCheckTimer");
        }
        Duration duration = days;
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"days");
        if (!localTimer.elapsed(duration)) return false;
        return true;
    }

    private final void checkForUpdates() {
        Button button;
        Dialog dialog2;
        this.log.debug("Checking for updates");
        Dialog $receiver = dialog2 = new Dialog();
        $receiver.setTitle("FXGL Update");
        $receiver.getDialogPane().setContentText("Checking for updates...\n \n ");
        $receiver.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        Node node = dialog2.getDialogPane().lookupButton(ButtonType.OK);
        if (node == null) {
            throw new TypeCastException("null cannot be cast to non-null type javafx.scene.control.Button");
        }
        Button $receiver2 = button = (Button)node;
        $receiver2.setDisable(true);
        $receiver2.setText("Open GitHub");
        $receiver2.setOnAction((EventHandler)new EventHandler<ActionEvent>(this){
            final /* synthetic */ UpdaterTask this$0;
            {
                this.this$0 = updaterTask;
            }

            public final void handle(ActionEvent it) {
                FXGL.Companion.getNet().openBrowserTask(FXGL.Companion.getString("url.github")).onFailureKt((Function1<Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(this){
                    final /* synthetic */ checkForUpdates$$inlined$with$lambda$1 this$0;
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }

                    public final void invoke(Throwable it) {
                        UpdaterTask.access$getLog$p(this.this$0.this$0).warning("Error opening browser: " + it);
                    }
                })).execute();
            }
        });
        IOTask.executeAsyncWithDialogFX$default(FXGL.Companion.getNet().getLatestVersionTask().onSuccessKt((Function1<String, Unit>)((Function1)new Function1<String, Unit>(this, dialog2, button){
            final /* synthetic */ UpdaterTask this$0;
            final /* synthetic */ Dialog $dialog;
            final /* synthetic */ Button $button;

            public final void invoke(@NotNull String latestVersion) {
                Intrinsics.checkParameterIsNotNull((Object)latestVersion, (String)"latestVersion");
                String currentVersion = Version.getAsString();
                UpdaterTask.access$getUpdateCheckTimer$p(this.this$0).capture();
                if (Intrinsics.areEqual((Object)currentVersion, (Object)latestVersion)) {
                    this.$dialog.close();
                } else {
                    this.$dialog.getDialogPane().setContentText("Just so you know\n" + "Your version:   " + currentVersion + '\n' + "Latest version: " + latestVersion);
                    this.$button.setDisable(false);
                }
            }
            {
                this.this$0 = updaterTask;
                this.$dialog = dialog2;
                this.$button = button;
                super(1);
            }
        })).onFailureKt((Function1<Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(this, dialog2, button){
            final /* synthetic */ UpdaterTask this$0;
            final /* synthetic */ Dialog $dialog;
            final /* synthetic */ Button $button;

            public final void invoke(@NotNull Throwable error) {
                Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                UpdaterTask.access$getLog$p(this.this$0).warning("Failed to find updates: " + error);
                this.$dialog.getDialogPane().setContentText("Failed to find updates: " + error);
                this.$button.setDisable(false);
            }
            {
                this.this$0 = updaterTask;
                this.$dialog = dialog2;
                this.$button = button;
                super(1);
            }
        })), null, null, 3, null);
        dialog2.showAndWait();
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLog$p(UpdaterTask $this) {
        return $this.log;
    }

    @NotNull
    public static final /* synthetic */ LocalTimer access$getUpdateCheckTimer$p(UpdaterTask $this) {
        LocalTimer localTimer = $this.updateCheckTimer;
        if (localTimer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"updateCheckTimer");
        }
        return localTimer;
    }

    public static final /* synthetic */ void access$setUpdateCheckTimer$p(UpdaterTask $this, @NotNull LocalTimer localTimer) {
        $this.updateCheckTimer = localTimer;
    }
}

