/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.component;

import com.almasb.fxgl.devtools.DeveloperEditable;
import com.almasb.fxgl.ecs.Component;
import com.almasb.fxgl.ecs.CopyableComponent;
import com.almasb.fxgl.ecs.serialization.SerializableComponent;
import com.almasb.fxgl.entity.component.BoundingBoxComponent;
import com.almasb.fxgl.io.serialization.Bundle;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.geometry.Point2D;
import org.jetbrains.annotations.NotNull;

public class PositionComponent
extends Component
implements SerializableComponent,
CopyableComponent<PositionComponent> {
    private final DoubleProperty x;
    private final DoubleProperty y;

    public PositionComponent(double x, double y) {
        this.x = new SimpleDoubleProperty(x);
        this.y = new SimpleDoubleProperty(y);
    }

    public PositionComponent(Point2D position2) {
        this(position2.getX(), position2.getY());
    }

    public PositionComponent() {
        this(0.0, 0.0);
    }

    public double getX() {
        return this.x.get();
    }

    @DeveloperEditable(value="X")
    public DoubleProperty xProperty() {
        return this.x;
    }

    public void setX(double x) {
        this.x.set(x);
    }

    public double getY() {
        return this.y.get();
    }

    @DeveloperEditable(value="Y")
    public DoubleProperty yProperty() {
        return this.y;
    }

    public void setY(double y) {
        this.y.set(y);
    }

    public Point2D getValue() {
        return new Point2D(this.getX(), this.getY());
    }

    public void setValue(double x, double y) {
        this.setX(x);
        this.setY(y);
    }

    public void setValue(Point2D position2) {
        this.setValue(position2.getX(), position2.getY());
    }

    public void translateX(double x) {
        this.setX(this.getX() + x);
    }

    public void translateY(double y) {
        this.setY(this.getY() + y);
    }

    public void translate(double x, double y) {
        this.translateX(x);
        this.translateY(y);
    }

    public void translate(Point2D vector) {
        this.translate(vector.getX(), vector.getY());
    }

    public void translateTowards(Point2D position2, double speed) {
        this.translate(position2.subtract(this.getX(), this.getY()).normalize().multiply(speed));
    }

    public double distance(PositionComponent other) {
        return this.getValue().distance(other.getValue());
    }

    public int getGridX(int cellSize) {
        double centerX = this.getEntity().getComponentOptional(BoundingBoxComponent.class).map(bbox -> bbox.getMinXWorld() + bbox.getWidth() / 2.0).orElseGet(this::getX);
        return (int)(centerX / (double)cellSize);
    }

    public int getGridY(int cellSize) {
        double centerY = this.getEntity().getComponentOptional(BoundingBoxComponent.class).map(bbox -> bbox.getMinYWorld() + bbox.getHeight() / 2.0).orElseGet(this::getY);
        return (int)(centerY / (double)cellSize);
    }

    public String toString() {
        return "Position(" + this.getX() + "," + this.getY() + ")";
    }

    @Override
    public void write(@NotNull Bundle bundle) {
        bundle.put("x", Double.valueOf(this.getX()));
        bundle.put("y", Double.valueOf(this.getY()));
    }

    @Override
    public void read(@NotNull Bundle bundle) {
        this.setValue((Double)bundle.get("x"), (Double)bundle.get("y"));
    }

    @Override
    public PositionComponent copy() {
        return new PositionComponent(this.getX(), this.getY());
    }
}

