/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.scene;

import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.ecs.Entity;
import com.almasb.fxgl.entity.component.BoundingBoxComponent;
import com.almasb.fxgl.entity.component.PositionComponent;
import com.almasb.fxgl.scene.Viewport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.NumberBinding;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u0003J/\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u00032\u0012\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020%0,\"\u00020%\u00a2\u0006\u0002\u0010-J\u0006\u0010.\u001a\u00020\u0003J\u0006\u0010/\u001a\u00020\u0003J\u0006\u00100\u001a\u00020\u0003J\u000e\u00101\u001a\u00020#2\u0006\u00102\u001a\u00020\u0003J&\u00103\u001a\u00020#2\u0006\u0010\u000b\u001a\u0002042\u0006\u0010\f\u001a\u0002042\u0006\u0010\b\u001a\u0002042\u0006\u0010\n\u001a\u000204J\u000e\u00105\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u0003J\u000e\u00106\u001a\u00020#2\u0006\u0010 \u001a\u00020\u0003J\u000e\u00107\u001a\u00020#2\u0006\u00108\u001a\u00020\u0003J\u000e\u0010\u0014\u001a\u00020#2\u0006\u00109\u001a\u00020\u0003J\u0006\u0010:\u001a\u00020#J\u0006\u0010;\u001a\u00020\u001fJ\u0006\u0010<\u001a\u00020\u001fJ\u0006\u0010=\u001a\u00020\u001fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0007R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/almasb/fxgl/scene/Viewport;", "", "width", "", "height", "(DD)V", "getHeight", "()D", "maxX", "Ljavafx/beans/property/SimpleIntegerProperty;", "maxY", "minX", "minY", "offset", "Lcom/almasb/fxgl/core/math/Vec2;", "origin", "Ljavafx/geometry/Point2D;", "getOrigin", "()Ljavafx/geometry/Point2D;", "originBeforeShake", "shake", "", "shakeAngle", "", "shakePower", "visibleArea", "Ljavafx/geometry/Rectangle2D;", "getVisibleArea", "()Ljavafx/geometry/Rectangle2D;", "getWidth", "x", "Ljavafx/beans/property/SimpleDoubleProperty;", "y", "zoom", "bindToEntity", "", "entity", "Lcom/almasb/fxgl/ecs/Entity;", "distX", "distY", "bindToFit", "xMargin", "yMargin", "entities", "", "(DD[Lcom/almasb/fxgl/ecs/Entity;)V", "getX", "getY", "getZoom", "onUpdate", "tpf", "setBounds", "", "setX", "setY", "setZoom", "value", "power", "unbind", "xProperty", "yProperty", "zoomProperty", "fxgl"})
public final class Viewport {
    private final SimpleDoubleProperty x;
    private final SimpleDoubleProperty y;
    private final SimpleDoubleProperty zoom;
    private final SimpleIntegerProperty minX;
    private final SimpleIntegerProperty minY;
    private final SimpleIntegerProperty maxX;
    private final SimpleIntegerProperty maxY;
    private float shakePower;
    private float shakeAngle;
    private final Vec2 originBeforeShake;
    private final Vec2 offset;
    private boolean shake;
    private final double width;
    private final double height;

    @NotNull
    public final Rectangle2D getVisibleArea() {
        return new Rectangle2D(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height);
    }

    public final double getX() {
        return this.x.get();
    }

    @NotNull
    public final SimpleDoubleProperty xProperty() {
        return this.x;
    }

    public final void setX(double x) {
        this.xProperty().set(x);
    }

    public final double getY() {
        return this.y.get();
    }

    @NotNull
    public final SimpleDoubleProperty yProperty() {
        return this.y;
    }

    public final void setY(double y) {
        this.yProperty().set(y);
    }

    public final double getZoom() {
        return this.zoom.get();
    }

    @NotNull
    public final SimpleDoubleProperty zoomProperty() {
        return this.zoom;
    }

    public final void setZoom(double value) {
        this.zoomProperty().set(value);
    }

    @NotNull
    public final Point2D getOrigin() {
        return new Point2D(this.getX(), this.getY());
    }

    public final void bindToEntity(@NotNull Entity entity, double distX, double distY) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        PositionComponent position2 = entity.getComponentOptional(PositionComponent.class).orElseThrow(bindToEntity.position.1.INSTANCE);
        DoubleBinding bx = position2.xProperty().add(-distX);
        DoubleBinding by = position2.yProperty().add(-distY);
        NumberBinding boundX = Bindings.when((ObservableBooleanValue)((ObservableBooleanValue)bx.lessThan((ObservableNumberValue)this.minX))).then((ObservableNumberValue)this.minX).otherwise((ObservableNumberValue)position2.xProperty().add(-distX));
        NumberBinding boundY = Bindings.when((ObservableBooleanValue)((ObservableBooleanValue)by.lessThan((ObservableNumberValue)this.minY))).then((ObservableNumberValue)this.minY).otherwise((ObservableNumberValue)position2.yProperty().add(-distY));
        boundX = Bindings.when((ObservableBooleanValue)((ObservableBooleanValue)bx.greaterThan((ObservableNumberValue)this.maxX.subtract(this.width)))).then((ObservableNumberValue)this.maxX.subtract(this.width)).otherwise((ObservableNumberValue)boundX);
        boundY = Bindings.when((ObservableBooleanValue)((ObservableBooleanValue)by.greaterThan((ObservableNumberValue)this.maxY.subtract(this.height)))).then((ObservableNumberValue)this.maxY.subtract(this.height)).otherwise((ObservableNumberValue)boundY);
        this.x.bind((ObservableValue)boundX);
        this.y.bind((ObservableValue)boundY);
    }

    /*
     * WARNING - void declaration
     */
    public final void bindToFit(double xMargin, double yMargin, Entity ... entities) {
        NumberBinding initial$iv;
        Object item$iv$iv;
        Object it;
        Object $receiver$iv$iv;
        NumberBinding initial$iv2;
        Object item$iv$iv2;
        Object it2;
        Object $receiver$iv$iv2;
        NumberBinding initial$iv3;
        Object item$iv$iv3;
        Object it3;
        Object $receiver$iv$iv3;
        NumberBinding initial$iv4;
        BoundingBoxComponent boundingBoxComponent;
        Collection collection;
        Object item$iv$iv4;
        Object it4;
        Object $receiver$iv$iv4;
        Intrinsics.checkParameterIsNotNull((Object)entities, (String)"entities");
        Object $receiver$iv = entities;
        Object[] objectArray = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (int i = 0; i < ((void)$receiver$iv$iv4).length; ++i) {
            void element$iv$iv = $receiver$iv$iv4[i];
            it4 = (Entity)element$iv$iv;
            if (!((Entity)it4).hasComponent(BoundingBoxComponent.class)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv4 = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv4.iterator();
        while (iterator.hasNext()) {
            item$iv$iv4 = iterator.next();
            it4 = (Entity)item$iv$iv4;
            collection = destination$iv$iv;
            boundingBoxComponent = ((Entity)it4).getComponent(BoundingBoxComponent.class);
            collection.add(boundingBoxComponent);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv4 = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        iterator = $receiver$iv$iv4.iterator();
        while (iterator.hasNext()) {
            item$iv$iv4 = iterator.next();
            it4 = (BoundingBoxComponent)item$iv$iv4;
            collection = destination$iv$iv;
            boundingBoxComponent = ((BoundingBoxComponent)it4).minXWorldProperty();
            collection.add(boundingBoxComponent);
        }
        $receiver$iv = (List)destination$iv$iv;
        NumberBinding accumulator$iv = initial$iv4 = Bindings.min((ObservableNumberValue)((ObservableNumberValue)new SimpleIntegerProperty(Integer.MAX_VALUE)), (int)Integer.MAX_VALUE);
        iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            void x;
            Object element$iv = iterator.next();
            it4 = (ReadOnlyDoubleProperty)element$iv;
            NumberBinding min = accumulator$iv;
            accumulator$iv = Bindings.min((ObservableNumberValue)((ObservableNumberValue)min), (ObservableNumberValue)((ObservableNumberValue)x));
        }
        NumberBinding minBindingX = accumulator$iv.subtract(xMargin);
        Object $receiver$iv2 = (NumberBinding)entities;
        accumulator$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        for (int element$iv = 0; element$iv < ((void)$receiver$iv$iv3).length; ++element$iv) {
            void element$iv$iv = $receiver$iv$iv3[element$iv];
            it3 = (Entity)element$iv$iv;
            if (!((Entity)it3).hasComponent(BoundingBoxComponent.class)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $receiver$iv2 = (List)destination$iv$iv2;
        $receiver$iv$iv3 = $receiver$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        Iterator element$iv = $receiver$iv$iv3.iterator();
        while (element$iv.hasNext()) {
            item$iv$iv3 = element$iv.next();
            it3 = (Entity)item$iv$iv3;
            collection = destination$iv$iv2;
            boundingBoxComponent = ((Entity)it3).getComponent(BoundingBoxComponent.class);
            collection.add(boundingBoxComponent);
        }
        $receiver$iv2 = (List)destination$iv$iv2;
        $receiver$iv$iv3 = $receiver$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        element$iv = $receiver$iv$iv3.iterator();
        while (element$iv.hasNext()) {
            item$iv$iv3 = element$iv.next();
            it3 = (BoundingBoxComponent)item$iv$iv3;
            collection = destination$iv$iv2;
            boundingBoxComponent = ((BoundingBoxComponent)it3).minYWorldProperty();
            collection.add(boundingBoxComponent);
        }
        $receiver$iv2 = (List)destination$iv$iv2;
        NumberBinding accumulator$iv2 = initial$iv3 = Bindings.min((ObservableNumberValue)((ObservableNumberValue)new SimpleIntegerProperty(Integer.MAX_VALUE)), (int)Integer.MAX_VALUE);
        element$iv = $receiver$iv2.iterator();
        while (element$iv.hasNext()) {
            void y;
            Object element$iv2 = element$iv.next();
            it3 = (ReadOnlyDoubleProperty)element$iv2;
            NumberBinding min = accumulator$iv2;
            accumulator$iv2 = Bindings.min((ObservableNumberValue)((ObservableNumberValue)min), (ObservableNumberValue)((ObservableNumberValue)y));
        }
        NumberBinding minBindingY = accumulator$iv2.subtract(yMargin);
        Object $receiver$iv3 = (NumberBinding)entities;
        accumulator$iv2 = $receiver$iv3;
        Collection destination$iv$iv3 = new ArrayList();
        for (int element$iv2 = 0; element$iv2 < ((void)$receiver$iv$iv2).length; ++element$iv2) {
            void element$iv$iv = $receiver$iv$iv2[element$iv2];
            it2 = (Entity)element$iv$iv;
            if (!((Entity)it2).hasComponent(BoundingBoxComponent.class)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $receiver$iv3 = (List)destination$iv$iv3;
        $receiver$iv$iv2 = $receiver$iv3;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
        Iterator element$iv2 = $receiver$iv$iv2.iterator();
        while (element$iv2.hasNext()) {
            item$iv$iv2 = element$iv2.next();
            it2 = (Entity)item$iv$iv2;
            collection = destination$iv$iv3;
            boundingBoxComponent = ((Entity)it2).getComponent(BoundingBoxComponent.class);
            collection.add(boundingBoxComponent);
        }
        $receiver$iv3 = (List)destination$iv$iv3;
        $receiver$iv$iv2 = $receiver$iv3;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
        element$iv2 = $receiver$iv$iv2.iterator();
        while (element$iv2.hasNext()) {
            item$iv$iv2 = element$iv2.next();
            it2 = (BoundingBoxComponent)item$iv$iv2;
            collection = destination$iv$iv3;
            boundingBoxComponent = ((BoundingBoxComponent)it2).maxXWorldProperty();
            collection.add(boundingBoxComponent);
        }
        $receiver$iv3 = (List)destination$iv$iv3;
        NumberBinding accumulator$iv3 = initial$iv2 = Bindings.max((ObservableNumberValue)((ObservableNumberValue)new SimpleIntegerProperty(Integer.MIN_VALUE)), (int)Integer.MIN_VALUE);
        element$iv2 = $receiver$iv3.iterator();
        while (element$iv2.hasNext()) {
            void x;
            Object element$iv3 = element$iv2.next();
            it2 = (ReadOnlyDoubleProperty)element$iv3;
            NumberBinding max = accumulator$iv3;
            accumulator$iv3 = Bindings.max((ObservableNumberValue)((ObservableNumberValue)max), (ObservableNumberValue)((ObservableNumberValue)x));
        }
        NumberBinding maxBindingX = accumulator$iv3.add(xMargin);
        Object $receiver$iv4 = (NumberBinding)entities;
        accumulator$iv3 = $receiver$iv4;
        Collection destination$iv$iv4 = new ArrayList();
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void element$iv$iv = $receiver$iv$iv[i];
            it = (Entity)element$iv$iv;
            if (!((Entity)it).hasComponent(BoundingBoxComponent.class)) continue;
            destination$iv$iv4.add(element$iv$iv);
        }
        $receiver$iv4 = (List)destination$iv$iv4;
        $receiver$iv$iv = $receiver$iv4;
        destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv4, (int)10));
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            it = (Entity)item$iv$iv;
            collection = destination$iv$iv4;
            boundingBoxComponent = ((Entity)it).getComponent(BoundingBoxComponent.class);
            collection.add(boundingBoxComponent);
        }
        $receiver$iv4 = (List)destination$iv$iv4;
        $receiver$iv$iv = $receiver$iv4;
        destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv4, (int)10));
        iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            it = (BoundingBoxComponent)item$iv$iv;
            collection = destination$iv$iv4;
            boundingBoxComponent = ((BoundingBoxComponent)it).maxYWorldProperty();
            collection.add(boundingBoxComponent);
        }
        $receiver$iv4 = (List)destination$iv$iv4;
        NumberBinding accumulator$iv4 = initial$iv = Bindings.max((ObservableNumberValue)((ObservableNumberValue)new SimpleIntegerProperty(Integer.MIN_VALUE)), (int)Integer.MIN_VALUE);
        iterator2 = $receiver$iv4.iterator();
        while (iterator2.hasNext()) {
            void y;
            Object element$iv4 = iterator2.next();
            it = (ReadOnlyDoubleProperty)element$iv4;
            NumberBinding max = accumulator$iv4;
            accumulator$iv4 = Bindings.max((ObservableNumberValue)((ObservableNumberValue)max), (ObservableNumberValue)((ObservableNumberValue)y));
        }
        NumberBinding maxBindingY = accumulator$iv4.add(yMargin);
        NumberBinding widthBinding = maxBindingX.subtract((ObservableNumberValue)minBindingX);
        NumberBinding heightBinding = maxBindingY.subtract((ObservableNumberValue)minBindingY);
        NumberBinding ratio = Bindings.min((ObservableNumberValue)((ObservableNumberValue)Bindings.divide((double)this.width, (ObservableNumberValue)((ObservableNumberValue)widthBinding))), (ObservableNumberValue)((ObservableNumberValue)Bindings.divide((double)this.height, (ObservableNumberValue)((ObservableNumberValue)heightBinding))));
        this.x.bind((ObservableValue)minBindingX);
        this.y.bind((ObservableValue)minBindingY);
        this.zoom.bind((ObservableValue)ratio);
    }

    public final void unbind() {
        this.xProperty().unbind();
        this.yProperty().unbind();
        this.zoomProperty().unbind();
    }

    public final void setBounds(int minX, int minY, int maxX, int maxY) {
        this.minX.set(minX);
        this.minY.set(minY);
        this.maxX.set(maxX);
        this.maxY.set(maxY);
    }

    public final void shake(double power) {
        this.shakePower = (float)power;
        this.shakeAngle = FXGLMath.random() * ((float)Math.PI * 2);
        if (!this.shake) {
            this.originBeforeShake.set(this.x.floatValue(), this.y.floatValue());
        }
        this.shake = true;
    }

    public final void onUpdate(double tpf) {
        if (!this.shake) {
            return;
        }
        this.shakePower *= 0.9f;
        this.shakeAngle += (float)180 + FXGLMath.random() * ((float)Math.PI * 2) / (float)6;
        this.offset.set(this.shakePower * FXGLMath.cos(this.shakeAngle), this.shakePower * FXGLMath.sin(this.shakeAngle));
        this.setX((double)this.offset.x + (double)this.originBeforeShake.x);
        this.setY((double)this.offset.y + (double)this.originBeforeShake.y);
        if ((double)FXGLMath.abs(this.offset.x) < 0.5 && (double)FXGLMath.abs(this.offset.y) < 0.5) {
            this.setX(this.originBeforeShake.x);
            this.setY(this.originBeforeShake.y);
            this.shake = false;
        }
    }

    public final double getWidth() {
        return this.width;
    }

    public final double getHeight() {
        return this.height;
    }

    public Viewport(double width, double height) {
        this.width = width;
        this.height = height;
        this.x = new SimpleDoubleProperty();
        this.y = new SimpleDoubleProperty();
        this.zoom = new SimpleDoubleProperty(1.0);
        this.minX = new SimpleIntegerProperty(Integer.MIN_VALUE);
        this.minY = new SimpleIntegerProperty(Integer.MIN_VALUE);
        this.maxX = new SimpleIntegerProperty(Integer.MAX_VALUE);
        this.maxY = new SimpleIntegerProperty(Integer.MAX_VALUE);
        this.originBeforeShake = new Vec2();
        this.offset = new Vec2();
    }
}

