/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.service.impl.executor;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.app.listener.ExitListener;
import com.almasb.fxgl.core.concurrent.Async;
import com.almasb.fxgl.service.Executor;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J&\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\r0\t\"\b\b\u0000\u0010\r*\u00020\u000e2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\r0\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fH\u0016J\u001c\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/almasb/fxgl/service/impl/executor/FXGLExecutor;", "Lcom/almasb/fxgl/service/Executor;", "()V", "schedulerService", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "service", "Ljava/util/concurrent/ExecutorService;", "async", "Lcom/almasb/fxgl/core/concurrent/Async;", "Ljava/lang/Void;", "func", "Ljava/lang/Runnable;", "T", "", "Ljava/util/concurrent/Callable;", "execute", "", "task", "schedule", "Ljava/util/concurrent/ScheduledFuture;", "action", "delay", "Ljavafx/util/Duration;", "FXGLThreadFactory", "fxgl"})
public final class FXGLExecutor
implements Executor {
    private final ExecutorService service = Executors.newCachedThreadPool(FXGLThreadFactory.INSTANCE);
    private final ScheduledExecutorService schedulerService = Executors.newScheduledThreadPool(2);

    @Override
    public void execute(@NotNull Runnable task2) {
        Intrinsics.checkParameterIsNotNull((Object)task2, (String)"task");
        this.service.submit(task2);
    }

    @Override
    @NotNull
    public ScheduledFuture<?> schedule(@NotNull Runnable action2, @NotNull Duration delay) {
        Intrinsics.checkParameterIsNotNull((Object)action2, (String)"action");
        Intrinsics.checkParameterIsNotNull((Object)delay, (String)"delay");
        ScheduledFuture<?> scheduledFuture = this.schedulerService.schedule(action2, (long)delay.toMillis(), TimeUnit.MILLISECONDS);
        Intrinsics.checkExpressionValueIsNotNull(scheduledFuture, (String)"schedulerService.schedul\u2026), TimeUnit.MILLISECONDS)");
        return scheduledFuture;
    }

    @Override
    @NotNull
    public <T> Async<T> async(@NotNull Callable<T> func) {
        Intrinsics.checkParameterIsNotNull(func, (String)"func");
        Async<T> async = Async.start(func);
        Intrinsics.checkExpressionValueIsNotNull(async, (String)"Async.start(func)");
        return async;
    }

    @Override
    @NotNull
    public Async<Void> async(@NotNull Runnable func) {
        Intrinsics.checkParameterIsNotNull((Object)func, (String)"func");
        Async<Void> async = Async.start(func);
        Intrinsics.checkExpressionValueIsNotNull(async, (String)"Async.start(func)");
        return async;
    }

    public FXGLExecutor() {
        FXGL.Companion.getApp().addExitListener(new ExitListener(){

            @Override
            public final void onExit() {
                service.shutdownNow();
                schedulerService.shutdownNow();
            }
        });
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/almasb/fxgl/service/impl/executor/FXGLExecutor$FXGLThreadFactory;", "Ljava/util/concurrent/ThreadFactory;", "()V", "group", "Ljava/lang/ThreadGroup;", "threadNumber", "Ljava/util/concurrent/atomic/AtomicInteger;", "newThread", "Ljava/lang/Thread;", "r", "Ljava/lang/Runnable;", "fxgl"})
    private static final class FXGLThreadFactory
    implements ThreadFactory {
        private static final ThreadGroup group;
        private static final AtomicInteger threadNumber;
        public static final FXGLThreadFactory INSTANCE;

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
            Thread t = new Thread(group, r, "FXGL Background Thread " + threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }

        private FXGLThreadFactory() {
            ThreadGroup threadGroup;
            INSTANCE = this;
            threadNumber = new AtomicInteger(1);
            SecurityManager s = System.getSecurityManager();
            if (s != null) {
                ThreadGroup threadGroup2 = s.getThreadGroup();
                threadGroup = threadGroup2;
                Intrinsics.checkExpressionValueIsNotNull((Object)threadGroup2, (String)"s.threadGroup");
            } else {
                ThreadGroup threadGroup3 = Thread.currentThread().getThreadGroup();
                threadGroup = threadGroup3;
                Intrinsics.checkExpressionValueIsNotNull((Object)threadGroup3, (String)"Thread.currentThread().threadGroup");
            }
            group = threadGroup;
        }

        static {
            new FXGLThreadFactory();
        }
    }
}

