/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.core.reflect;

import com.almasb.fxgl.core.collection.Array;
import com.almasb.fxgl.core.reflect.ReflectionException;
import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static Map<Class<?>, List<Class<?>>> findClasses(String packageName, Class<? extends Annotation> ... annotations) {
        HashMap map2 = new HashMap();
        FastClasspathScanner scanner = new FastClasspathScanner(new String[]{packageName});
        for (Class<? extends Annotation> annotationClass : annotations) {
            map2.put(annotationClass, new ArrayList());
            scanner.matchClassesWithAnnotation(annotationClass, ((List)map2.get(annotationClass))::add);
        }
        scanner.scan();
        return map2;
    }

    public static <A extends Annotation> Map<A, Method> findMethods(Object instance, Class<A> annotationClass) {
        HashMap<A, Method> map2 = new HashMap<A, Method>();
        for (Method method : instance.getClass().getDeclaredMethods()) {
            A annotation = method.getDeclaredAnnotation(annotationClass);
            if (annotation == null) continue;
            map2.put(annotation, method);
        }
        return map2;
    }

    public static <T, R, A extends Annotation> Map<A, Function<T, R>> findMethodsMapToFunctions(Object instance, Class<A> annotationClass) {
        HashMap map2 = new HashMap();
        ReflectionUtils.findMethods(instance, annotationClass).forEach((annotation, method) -> map2.put(annotation, ReflectionUtils.mapToFunction(instance, method)));
        return map2;
    }

    public static <T, R, F extends Function<T, R>, A extends Annotation> Map<A, F> findMethodsMapToFunctions(Object instance, Class<A> annotationClass, Class<F> functionClass) {
        HashMap map2 = new HashMap();
        ReflectionUtils.findMethods(instance, annotationClass).forEach((annotation, method) -> {
            Function function = (Function)Proxy.newProxyInstance(functionClass.getClassLoader(), new Class[]{functionClass}, (proxy, proxyMethod, args) -> method.invoke(instance, args));
            map2.put(annotation, function);
        });
        return map2;
    }

    public static <T> T call(Object instance, Method method, Object ... args) {
        try {
            return (T)method.invoke(instance, args);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot call " + method.getName() + " Error: " + e);
        }
    }

    public static <T, R> Function<T, R> mapToFunction(Object instance, Method method) {
        return input -> ReflectionUtils.call(instance, method, input);
    }

    public static <A extends Annotation> Array<Field> findFieldsByAnnotation(Object instance, Class<A> annotationClass) {
        Array<Field> fields = new Array<Field>();
        for (Field field : instance.getClass().getDeclaredFields()) {
            if (field.getDeclaredAnnotation(annotationClass) == null) continue;
            fields.add(field);
        }
        return fields;
    }

    public static Array<Field> findDeclaredFieldsByType(Object instance, Class<?> type) {
        Array<Field> fields = new Array<Field>();
        for (Field field : instance.getClass().getDeclaredFields()) {
            if (!type.isAssignableFrom(field.getType())) continue;
            fields.add(field);
        }
        return fields;
    }

    public static Array<Field> findFieldsByTypeRecursive(Object instance, Class<?> type) {
        Array<Field> fields = new Array<Field>();
        for (Field field : ReflectionUtils.getAllFieldsRecursive(instance)) {
            if (!type.isAssignableFrom(field.getType())) continue;
            fields.add(field);
        }
        return fields;
    }

    private static Array<Field> getAllFieldsRecursive(Object instance) {
        Array<Field> result = new Array<Field>();
        for (Class<?> typeClass = instance.getClass(); typeClass != null && typeClass != Object.class; typeClass = typeClass.getSuperclass()) {
            result.addAll((Field[])typeClass.getDeclaredFields());
        }
        return result;
    }

    public static void inject(Field field, Object instance, Object injectionInstance) {
        try {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(instance, injectionInstance);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot inject " + injectionInstance + " into " + field.getName() + " Error: " + e);
        }
    }

    public static <T> T newInstance(Class<T> type) {
        try {
            return type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ReflectionException(e);
        }
    }
}

