/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.ecs;

import com.almasb.fxgl.core.collection.Array;
import com.almasb.fxgl.core.collection.ObjectMap;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.core.reflect.ReflectionUtils;
import com.almasb.fxgl.ecs.Component;
import com.almasb.fxgl.ecs.Control;
import com.almasb.fxgl.ecs.EntityCopier;
import com.almasb.fxgl.ecs.EntitySerializer;
import com.almasb.fxgl.ecs.GameWorld;
import com.almasb.fxgl.ecs.Module;
import com.almasb.fxgl.ecs.ModuleListener;
import com.almasb.fxgl.ecs.component.Required;
import com.almasb.fxgl.io.serialization.Bundle;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;

public class Entity {
    private static final Logger log = Logger.get(Entity.class);
    private ObjectMap<String, Object> properties = new ObjectMap();
    private ObjectMap<Class<? extends Control>, Control> controls = new ObjectMap();
    private ObjectMap<Class<? extends Component>, Component> components = new ObjectMap();
    private List<ModuleListener> moduleListeners = new ArrayList<ModuleListener>();
    private GameWorld world = null;
    private ReadOnlyBooleanWrapper active = new ReadOnlyBooleanWrapper(false);
    private boolean controlsEnabled = true;
    private Runnable onActive = null;
    private Runnable onNotActive = null;
    private boolean updating = false;
    private static final Object NULL = new Object();

    public GameWorld getWorld() {
        return this.world;
    }

    void init(GameWorld world) {
        this.world = world;
        if (this.onActive != null) {
            this.onActive.run();
        }
        this.active.set(true);
    }

    void clean() {
        this.removeAllControls();
        this.removeAllComponents();
        this.properties.clear();
        this.moduleListeners.clear();
        this.world = null;
        this.onActive = null;
        this.onNotActive = null;
        this.controlsEnabled = true;
        this.updating = false;
        this.active.set(false);
    }

    public final void removeFromWorld() {
        if (this.world != null) {
            this.world.removeEntity(this);
        }
    }

    public final ReadOnlyBooleanProperty activeProperty() {
        return this.active.getReadOnlyProperty();
    }

    public final boolean isActive() {
        return this.active.get();
    }

    public final void setOnActive(Runnable action2) {
        this.onActive = action2;
    }

    public final void setOnNotActive(Runnable action2) {
        this.onNotActive = action2;
    }

    void markForRemoval() {
        if (this.onNotActive != null) {
            this.onNotActive.run();
        }
        this.active.set(false);
    }

    public final void setControlsEnabled(boolean b) {
        this.controlsEnabled = b;
    }

    void update(double tpf) {
        this.updating = true;
        if (this.controlsEnabled) {
            for (Control c : this.controls.values()) {
                if (c.isPaused()) continue;
                c.onUpdate(this, tpf);
            }
        }
        this.updating = false;
    }

    public final void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public final <T> T getProperty(String key) {
        Object value = this.properties.get(key, NULL);
        if (value == NULL) {
            log.warning("Access property with missing key: " + key);
            return null;
        }
        return (T)value;
    }

    public final <T> Optional<T> getPropertyOptional(String key) {
        Object value = this.properties.get(key, null);
        return Optional.ofNullable(value);
    }

    public final boolean hasControl(Class<? extends Control> type) {
        return this.controls.containsKey(type);
    }

    public final <T extends Control> Optional<T> getControlOptional(Class<T> type) {
        return Optional.ofNullable(this.getControl(type));
    }

    public final <T extends Control> T getControl(Class<T> type) {
        return (T)((Control)type.cast(this.controls.get(type)));
    }

    public final Array<Control> getControls() {
        return this.controls.values().toArray();
    }

    public final void addControl(Control control) {
        this.checkNotUpdating("Add control");
        this.addModule(control);
        this.controls.put(control.getClass(), control);
    }

    public final boolean removeControl(Class<? extends Control> type) {
        this.checkNotUpdating("Remove control");
        if (!this.hasControl(type)) {
            return false;
        }
        this.removeModule(this.getControl(type));
        this.controls.remove(type);
        return true;
    }

    private void removeAllControls() {
        for (Control control : this.controls.values()) {
            this.removeModule(control);
        }
        this.controls.clear();
    }

    public final boolean hasComponent(Class<? extends Component> type) {
        return this.components.containsKey(type);
    }

    public final <T extends Component> Optional<T> getComponentOptional(Class<T> type) {
        return Optional.ofNullable(this.getComponent(type));
    }

    public final <T extends Component> T getComponent(Class<T> type) {
        return (T)((Component)type.cast(this.components.get(type)));
    }

    public final Array<Component> getComponents() {
        return this.components.values().toArray();
    }

    public final void addComponent(Component component) {
        this.addModule(component);
        this.components.put(component.getClass(), component);
    }

    public final boolean removeComponent(Class<? extends Component> type) {
        if (!this.hasComponent(type)) {
            return false;
        }
        this.checkNotRequiredByAny(type);
        this.removeModule(this.getComponent(type));
        this.components.remove(type);
        return true;
    }

    private void removeAllComponents() {
        for (Component comp : this.components.values()) {
            this.removeModule(comp);
        }
        this.components.clear();
    }

    public void addModuleListener(ModuleListener listener2) {
        this.moduleListeners.add(listener2);
    }

    public void removeModuleListener(ModuleListener listener2) {
        this.moduleListeners.remove(listener2);
    }

    private void addModule(Module module) {
        this.checkRequirementsMet(module.getClass());
        module.setEntity(this);
        if (module instanceof Control) {
            this.injectFields((Control)module);
        } else if (module instanceof Component) {
            this.injectFields((Component)module);
        }
        module.onAdded(this);
        this.notifyModuleAdded(module);
    }

    private void injectFields(Component component) {
        ReflectionUtils.findFieldsByTypeRecursive(component, Component.class).forEach(field -> {
            Object comp = this.getComponent(field.getType());
            if (comp != null) {
                ReflectionUtils.inject(field, component, comp);
            }
        });
    }

    private void injectFields(Control control) {
        ReflectionUtils.findFieldsByTypeRecursive(control, Component.class).forEach(field -> {
            Object comp = this.getComponent(field.getType());
            if (comp != null) {
                ReflectionUtils.inject(field, control, comp);
            }
        });
        ReflectionUtils.findFieldsByTypeRecursive(control, Control.class).forEach(field -> {
            Object ctrl = this.getControl(field.getType());
            if (ctrl != null) {
                ReflectionUtils.inject(field, control, ctrl);
            }
        });
    }

    private void removeModule(Module module) {
        this.notifyModuleRemoved(module);
        module.onRemoved(this);
        module.setEntity(null);
    }

    private <T extends Module> void notifyModuleAdded(T module) {
        if (module instanceof Component) {
            Component c = (Component)module;
            for (int i = 0; i < this.moduleListeners.size(); ++i) {
                this.moduleListeners.get(i).onAdded(c);
            }
        } else {
            Control c = (Control)module;
            for (int i = 0; i < this.moduleListeners.size(); ++i) {
                this.moduleListeners.get(i).onAdded(c);
            }
        }
    }

    private <T extends Module> void notifyModuleRemoved(T module) {
        if (module instanceof Component) {
            Component c = (Component)module;
            for (int i = 0; i < this.moduleListeners.size(); ++i) {
                this.moduleListeners.get(i).onRemoved(c);
            }
        } else {
            Control c = (Control)module;
            for (int i = 0; i < this.moduleListeners.size(); ++i) {
                this.moduleListeners.get(i).onRemoved(c);
            }
        }
    }

    private void checkNotUpdating(String action2) {
        if (this.updating) {
            throw new IllegalStateException("Cannot " + action2 + " during updating");
        }
    }

    private void checkNotAnonymous(Class<?> type) {
        if (type.isAnonymousClass() || type.getCanonicalName() == null) {
            throw new IllegalArgumentException("Anonymous types are not allowed: " + type.getName());
        }
    }

    private void checkNotDuplicate(Class<?> type) {
        if (Component.class.isAssignableFrom(type) && this.hasComponent(type) || Control.class.isAssignableFrom(type) && this.hasControl(type)) {
            throw new IllegalArgumentException("Entity already has type: " + type.getCanonicalName());
        }
    }

    private void checkRequirementsMet(Class<?> type) {
        Required[] required;
        this.checkNotAnonymous(type);
        this.checkNotDuplicate(type);
        for (Required r : required = (Required[])type.getAnnotationsByType(Required.class)) {
            if (this.hasComponent(r.value())) continue;
            throw new IllegalStateException("Required component: [" + r.value().getSimpleName() + "] for: " + type.getSimpleName() + " is missing");
        }
    }

    private void checkNotRequiredByAny(Class<? extends Component> type) {
        for (Class clazz : this.components.keys()) {
            this.checkNotRequiredBy(clazz, type);
        }
        for (Class clazz : this.controls.keys()) {
            this.checkNotRequiredBy(clazz, type);
        }
    }

    private void checkNotRequiredBy(Class<?> requiringType, Class<? extends Component> type) {
        for (Required required : (Required[])requiringType.getAnnotationsByType(Required.class)) {
            if (!required.value().equals(type)) continue;
            throw new IllegalArgumentException("Required component: [" + required.value().getSimpleName() + "] by: " + requiringType.getSimpleName());
        }
    }

    public Entity copy() {
        return EntityCopier.INSTANCE.copy(this);
    }

    public void save(Bundle bundle) {
        EntitySerializer.INSTANCE.save(this, bundle);
    }

    public void load(Bundle bundle) {
        EntitySerializer.INSTANCE.load(this, bundle);
    }

    public String toString() {
        return "Entity(" + String.join((CharSequence)"\n", "components=" + this.components, "controls=" + this.controls) + ")";
    }
}

