/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.ecs.action;

import com.almasb.fxgl.ecs.Control;
import com.almasb.fxgl.ecs.Entity;
import com.almasb.fxgl.ecs.action.Action;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class ActionControl<T extends Entity>
extends Control {
    private Deque<Action<T>> actions = new ArrayDeque<Action<T>>();
    private ObservableList<Action<T>> actionsObservable = FXCollections.observableArrayList();
    private Action<T> currentAction = null;
    private T thisEntity = null;

    @Override
    public void onAdded(Entity entity) {
        this.thisEntity = entity;
    }

    @Override
    public void onUpdate(Entity entity, double tpf) {
        this.updateActions(tpf);
    }

    @Override
    public void onRemoved(Entity entity) {
        this.clearActions();
        this.thisEntity = null;
    }

    private void updateActions(double tpf) {
        if (this.currentAction != null) {
            if (this.currentAction.isComplete()) {
                this.removeCurrentAction();
            } else {
                this.currentAction.onUpdate(this.thisEntity, tpf);
            }
        } else if (this.hasNextActions()) {
            this.currentAction = this.actions.pollFirst();
            this.currentAction.setEntity(this.thisEntity);
        }
    }

    public ObservableList<Action<T>> actionsProperty() {
        return FXCollections.unmodifiableObservableList(this.actionsObservable);
    }

    public boolean hasNextActions() {
        return !this.actions.isEmpty();
    }

    public void addAction(Action action2) {
        this.actions.add(action2);
        this.actionsObservable.add((Object)action2);
    }

    public void removeCurrentAction() {
        if (this.currentAction != null) {
            this.actionsObservable.remove(this.currentAction);
            this.currentAction.setEntity(null);
            this.currentAction = null;
        }
    }

    public void removeLastAction() {
        Action<T> a = this.actions.pollLast();
        if (a != null) {
            this.actionsObservable.remove(a);
        }
    }

    public void removeAction(Action action2) {
        if (action2 == this.currentAction) {
            this.removeCurrentAction();
        } else {
            this.actions.remove(action2);
            this.actionsObservable.remove((Object)action2);
        }
    }

    public void clearActions() {
        this.removeCurrentAction();
        this.actions.clear();
        this.actionsObservable.clear();
    }

    public Optional<Action<T>> getCurrentAction() {
        return Optional.ofNullable(this.currentAction);
    }

    public Optional<Action<T>> getNextAction() {
        return Optional.ofNullable(this.actions.peekFirst());
    }

    public Optional<Action<T>> getLastAction() {
        return Optional.ofNullable(this.actions.peekLast());
    }
}

