/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.event;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.event.EventCondition;
import com.almasb.fxgl.event.EventProducer;
import com.almasb.fxgl.time.LocalTimer;
import javafx.event.Event;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B1\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0018\u001a\u00020\u0019J\u0015\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\u0006\u0010\u001e\u001a\u00020\u001fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/almasb/fxgl/event/EventTrigger;", "T", "Ljavafx/event/Event;", "", "eventCondition", "Lcom/almasb/fxgl/event/EventCondition;", "eventProducer", "Lcom/almasb/fxgl/event/EventProducer;", "limit", "", "interval", "Ljavafx/util/Duration;", "(Lcom/almasb/fxgl/event/EventCondition;Lcom/almasb/fxgl/event/EventProducer;ILjavafx/util/Duration;)V", "getEventCondition", "()Lcom/almasb/fxgl/event/EventCondition;", "getEventProducer", "()Lcom/almasb/fxgl/event/EventProducer;", "getInterval", "()Ljavafx/util/Duration;", "getLimit", "()I", "timer", "Lcom/almasb/fxgl/time/LocalTimer;", "timesFired", "fire", "", "onUpdate", "tpf", "", "onUpdate$fxgl", "reachedLimit", "", "fxgl"})
public final class EventTrigger<T extends Event> {
    private int timesFired;
    private final LocalTimer timer;
    @NotNull
    private final EventCondition eventCondition;
    @NotNull
    private final EventProducer<T> eventProducer;
    private final int limit;
    @NotNull
    private final Duration interval;

    public final boolean reachedLimit() {
        return this.timesFired == this.limit;
    }

    public final void fire() {
        if (!this.reachedLimit()) {
            FXGL.Companion.getEventBus().fireEvent((Event)this.eventProducer.produce());
            int n = this.timesFired;
            this.timesFired = n + 1;
        }
    }

    public final void onUpdate$fxgl(double tpf) {
        if (this.eventCondition.isTrue() && (this.timer.elapsed(this.interval) || this.timesFired == 0)) {
            this.fire();
            this.timer.capture();
        }
    }

    @NotNull
    public final EventCondition getEventCondition() {
        return this.eventCondition;
    }

    @NotNull
    public final EventProducer<T> getEventProducer() {
        return this.eventProducer;
    }

    public final int getLimit() {
        return this.limit;
    }

    @NotNull
    public final Duration getInterval() {
        return this.interval;
    }

    @JvmOverloads
    public EventTrigger(@NotNull EventCondition eventCondition, @NotNull EventProducer<? extends T> eventProducer, int limit, @NotNull Duration interval) {
        Intrinsics.checkParameterIsNotNull((Object)eventCondition, (String)"eventCondition");
        Intrinsics.checkParameterIsNotNull(eventProducer, (String)"eventProducer");
        Intrinsics.checkParameterIsNotNull((Object)interval, (String)"interval");
        this.eventCondition = eventCondition;
        this.eventProducer = eventProducer;
        this.limit = limit;
        this.interval = interval;
        this.timer = FXGL.Companion.newLocalTimer();
        if (this.limit <= 0) {
            throw (Throwable)new IllegalArgumentException("Trigger limit must be non-negative and non-zero");
        }
    }

    @JvmOverloads
    public /* synthetic */ EventTrigger(EventCondition eventCondition, EventProducer eventProducer, int n, Duration duration, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 1;
        }
        if ((n2 & 8) != 0) {
            Duration duration2 = Duration.ZERO;
            Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.ZERO");
            duration = duration2;
        }
        this(eventCondition, eventProducer, n, duration);
    }

    @JvmOverloads
    public EventTrigger(@NotNull EventCondition eventCondition, @NotNull EventProducer<? extends T> eventProducer, int limit) {
        this(eventCondition, eventProducer, limit, null, 8, null);
    }

    @JvmOverloads
    public EventTrigger(@NotNull EventCondition eventCondition, @NotNull EventProducer<? extends T> eventProducer) {
        this(eventCondition, eventProducer, 0, null, 12, null);
    }
}

