/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics;

import com.almasb.fxgl.core.pool.Poolable;
import com.almasb.fxgl.ecs.Entity;
import com.almasb.fxgl.entity.component.TypeComponent;
import com.almasb.fxgl.physics.CollisionHandler;
import com.almasb.fxgl.physics.Pair;
import java.io.Serializable;

final class CollisionPair
extends Pair<Entity>
implements Poolable {
    private CollisionHandler handler;

    CollisionPair() {
        super(null, null);
    }

    void init(Entity a, Entity b, CollisionHandler handler2) {
        this.handler = handler2;
        if (((Serializable)a.getComponent(TypeComponent.class).getValue()).equals(handler2.getA())) {
            this.setA(a);
            this.setB(b);
        } else {
            this.setA(b);
            this.setB(a);
        }
    }

    CollisionHandler getHandler() {
        return this.handler;
    }

    void collisionBegin() {
        this.handler.onCollisionBegin((Entity)this.getA(), (Entity)this.getB());
    }

    void collision() {
        this.handler.onCollision((Entity)this.getA(), (Entity)this.getB());
    }

    void collisionEnd() {
        this.handler.onCollisionEnd((Entity)this.getA(), (Entity)this.getB());
    }

    @Override
    public void reset() {
        this.handler = null;
        this.setA(null);
        this.setB(null);
    }
}

