/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.service.impl.notification;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.gameplay.Notification;
import com.almasb.fxgl.gameplay.NotificationEvent;
import com.almasb.fxgl.gameplay.NotificationView;
import com.almasb.fxgl.scene.GameScene;
import com.almasb.fxgl.service.NotificationService;
import com.almasb.fxgl.service.impl.notification.FXGLNotificationService$WhenMappings;
import com.almasb.fxgl.ui.Position;
import java.util.ArrayDeque;
import javafx.animation.ScaleTransition;
import javafx.animation.Transition;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004H\u0016J\b\u0010\u0013\u001a\u00020\tH\u0016J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0015J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\fH\u0002J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\fH\u0002J\u0016\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0015R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/almasb/fxgl/service/impl/notification/FXGLNotificationService;", "Lcom/almasb/fxgl/service/NotificationService;", "()V", "backgroundColor", "Ljavafx/scene/paint/Color;", "kotlin.jvm.PlatformType", "gameScene", "Lcom/almasb/fxgl/scene/GameScene;", "position", "Lcom/almasb/fxgl/ui/Position;", "queue", "Ljava/util/ArrayDeque;", "Lcom/almasb/fxgl/gameplay/NotificationView;", "showing", "", "createNotificationView", "text", "", "getBackgroundColor", "getPosition", "heightOf", "", "fontSize", "popNotification", "", "notificationView", "pushNotification", "setBackgroundColor", "setPosition", "showNotification", "widthOf", "fxgl"})
public final class FXGLNotificationService
implements NotificationService {
    private GameScene gameScene;
    private final ArrayDeque<NotificationView> queue = new ArrayDeque();
    private Position position = Position.TOP;
    private Color backgroundColor = Color.BLACK;
    private boolean showing;

    @Override
    @NotNull
    public Position getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(@NotNull Position position2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)position2), (String)"position");
        this.position = position2;
    }

    @Override
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public void setBackgroundColor(@NotNull Color backgroundColor) {
        Intrinsics.checkParameterIsNotNull((Object)backgroundColor, (String)"backgroundColor");
        this.backgroundColor = backgroundColor;
    }

    private final void popNotification(NotificationView notificationView) {
        boolean removed;
        GameScene gameScene = this.gameScene;
        if (gameScene == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gameScene");
        }
        if (!(removed = gameScene.removeUINode((Node)notificationView))) {
            return;
        }
        if (!this.queue.isEmpty()) {
            NotificationView notificationView2 = this.queue.poll();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)notificationView2), (String)"queue.poll()");
            this.showNotification(notificationView2);
        } else {
            this.showing = false;
        }
    }

    @Override
    public void pushNotification(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        GameScene gameScene = FXGL.Companion.getApp().getGameScene();
        Intrinsics.checkExpressionValueIsNotNull((Object)gameScene, (String)"FXGL.getApp().gameScene");
        this.gameScene = gameScene;
        NotificationView notificationView = this.createNotificationView(text);
        if (this.showing) {
            this.queue.add(notificationView);
        } else {
            this.showNotification(notificationView);
        }
    }

    private final void showNotification(NotificationView notificationView) {
        this.showing = true;
        GameScene gameScene = this.gameScene;
        if (gameScene == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gameScene");
        }
        gameScene.addUINode((Node)notificationView);
        notificationView.show();
        FXGL.Companion.getEventBus().fireEvent(new NotificationEvent(notificationView.getNotification()));
    }

    private final NotificationView createNotificationView(String text) {
        ScaleTransition in = new ScaleTransition(Duration.seconds((double)0.3));
        in.setFromX(0.0);
        in.setFromY(0.0);
        in.setToX(1.0);
        in.setToY(1.0);
        ScaleTransition out = new ScaleTransition(Duration.seconds((double)0.3));
        out.setFromX(1.0);
        out.setFromY(1.0);
        out.setToX(0.0);
        out.setToY(0.0);
        Notification notification = new Notification(text);
        Color color = this.backgroundColor;
        Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"backgroundColor");
        NotificationView notificationView = new NotificationView(notification, color, (Transition)in, (Transition)out);
        notificationView.setScaleX(0.0);
        notificationView.setScaleY(0.0);
        double x = 0.0;
        double y = 0.0;
        switch (FXGLNotificationService$WhenMappings.$EnumSwitchMapping$0[this.position.ordinal()]) {
            case 1: {
                x = 50.0;
                GameScene gameScene = this.gameScene;
                if (gameScene == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"gameScene");
                }
                y = gameScene.getHeight() / (double)2 - (this.heightOf(text, 12.0) + (double)10) / (double)2;
                break;
            }
            case 2: {
                GameScene gameScene = this.gameScene;
                if (gameScene == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"gameScene");
                }
                x = gameScene.getWidth() - (this.widthOf(text, 12.0) + (double)20) - 50.0;
                GameScene gameScene2 = this.gameScene;
                if (gameScene2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"gameScene");
                }
                y = gameScene2.getHeight() / (double)2 - (this.heightOf(text, 12.0) + (double)10) / (double)2;
                break;
            }
            case 3: {
                GameScene gameScene = this.gameScene;
                if (gameScene == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"gameScene");
                }
                x = gameScene.getWidth() / (double)2 - (this.widthOf(text, 12.0) + (double)20) / (double)2;
                y = 50.0;
                break;
            }
            case 4: {
                GameScene gameScene = this.gameScene;
                if (gameScene == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"gameScene");
                }
                x = gameScene.getWidth() / (double)2 - (this.widthOf(text, 12.0) + (double)20) / (double)2;
                GameScene gameScene3 = this.gameScene;
                if (gameScene3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"gameScene");
                }
                y = gameScene3.getHeight() - (this.heightOf(text, 12.0) + (double)10) - 50.0;
            }
        }
        notificationView.setTranslateX(x);
        notificationView.setTranslateY(y);
        in.setNode((Node)notificationView);
        out.setNode((Node)notificationView);
        out.setOnFinished((EventHandler)new EventHandler<ActionEvent>(this, notificationView){
            final /* synthetic */ FXGLNotificationService this$0;
            final /* synthetic */ NotificationView $notificationView;

            public final void handle(ActionEvent e) {
                FXGLNotificationService.access$popNotification(this.this$0, this.$notificationView);
            }
            {
                this.this$0 = fXGLNotificationService;
                this.$notificationView = notificationView;
            }
        });
        return notificationView;
    }

    public final double widthOf(@NotNull String text, double fontSize) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return FXGL.Companion.getUIFactory().newText(text, fontSize).getLayoutBounds().getWidth();
    }

    public final double heightOf(@NotNull String text, double fontSize) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return FXGL.Companion.getUIFactory().newText(text, fontSize).getLayoutBounds().getHeight();
    }

    public static final /* synthetic */ void access$popNotification(FXGLNotificationService $this, @NotNull NotificationView notificationView) {
        $this.popNotification(notificationView);
    }
}

