/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.ai.utils.random;

import com.almasb.fxgl.ai.utils.random.FloatDistribution;
import com.almasb.fxgl.core.math.FXGLMath;

public final class GaussianFloatDistribution
extends FloatDistribution {
    public static final GaussianFloatDistribution STANDARD_NORMAL = new GaussianFloatDistribution(0.0f, 1.0f);
    private final float mean;
    private final float standardDeviation;

    public GaussianFloatDistribution(float mean, float standardDeviation) {
        this.mean = mean;
        this.standardDeviation = standardDeviation;
    }

    @Override
    public float nextFloat() {
        return this.mean + (float)FXGLMath.getRandom().nextGaussian() * this.standardDeviation;
    }

    public float getMean() {
        return this.mean;
    }

    public float getStandardDeviation() {
        return this.standardDeviation;
    }
}

