/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.algorithm;

import com.almasb.fxgl.core.collection.Array;
import com.almasb.fxgl.core.math.FXGLMath;
import java.util.ArrayList;
import javafx.geometry.Rectangle2D;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0007J$\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\bH\u0002J$\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\bH\u0002J$\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\bH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/almasb/fxgl/algorithm/AASubdivision;", "", "()V", "divide", "Lcom/almasb/fxgl/core/collection/Array;", "Ljavafx/geometry/Rectangle2D;", "rect", "maxSubspaces", "", "minSize", "isDivisible", "Lkotlin/Pair;", "", "grid", "subdivideHorizontal", "subdivideVertical", "fxgl"})
public final class AASubdivision {
    public static final AASubdivision INSTANCE;

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Array<Rectangle2D> divide(@NotNull Rectangle2D rect, int maxSubspaces, int minSize) {
        Intrinsics.checkParameterIsNotNull((Object)rect, (String)"rect");
        ArrayList grids = CollectionsKt.arrayListOf((Object[])new Rectangle2D[]{rect});
        Array<Rectangle2D> result = new Array<Rectangle2D>(maxSubspaces);
        int n = 1;
        int n2 = maxSubspaces - 1;
        if (n <= n2) {
            while (true) {
                void i;
                if (grids.isEmpty()) {
                    throw (Throwable)new RuntimeException("Cannot subdivide");
                }
                Object e = grids.get(FXGLMath.random(grids.size() - 1));
                Intrinsics.checkExpressionValueIsNotNull(e, (String)"grids[random(grids.size-1)]");
                Rectangle2D grid = (Rectangle2D)e;
                grids.remove(grid);
                Pair<Boolean, Boolean> divisible = INSTANCE.isDivisible(grid, minSize);
                if (!((Boolean)divisible.getFirst()).booleanValue() && !((Boolean)divisible.getSecond()).booleanValue()) continue;
                result.removeValueByIdentity(grid);
                Pair<Rectangle2D, Rectangle2D> pair = (Boolean)divisible.getFirst() != false && (Boolean)divisible.getSecond() != false ? (FXGLMath.randomBoolean() ? INSTANCE.subdivideHorizontal(grid, minSize) : INSTANCE.subdivideVertical(grid, minSize)) : ((Boolean)divisible.getFirst() != false ? INSTANCE.subdivideHorizontal(grid, minSize) : INSTANCE.subdivideVertical(grid, minSize));
                grids.add(pair.getFirst());
                grids.add(pair.getSecond());
                result.addAll((Rectangle2D[])new Rectangle2D[]{(Rectangle2D)pair.getFirst(), (Rectangle2D)pair.getSecond()});
                if (i == n2) break;
                ++i;
            }
        }
        return result;
    }

    private final Pair<Boolean, Boolean> isDivisible(Rectangle2D grid, int minSize) {
        boolean horizontal = grid.getWidth() / (double)2 >= (double)minSize;
        boolean vertical = grid.getHeight() / (double)2 >= (double)minSize;
        return TuplesKt.to((Object)horizontal, (Object)vertical);
    }

    private final Pair<Rectangle2D, Rectangle2D> subdivideVertical(Rectangle2D grid, int minSize) {
        double lineY = FXGLMath.random((int)grid.getMinY() + minSize, (int)grid.getMaxY() - minSize);
        return TuplesKt.to((Object)new Rectangle2D(grid.getMinX(), grid.getMinY(), grid.getWidth(), lineY - grid.getMinY()), (Object)new Rectangle2D(grid.getMinX(), lineY, grid.getWidth(), grid.getMaxY() - lineY));
    }

    private final Pair<Rectangle2D, Rectangle2D> subdivideHorizontal(Rectangle2D grid, int minSize) {
        double lineX = FXGLMath.random((int)grid.getMinX() + minSize, (int)grid.getMaxX() - minSize);
        return TuplesKt.to((Object)new Rectangle2D(grid.getMinX(), grid.getMinY(), lineX - grid.getMinX(), grid.getHeight()), (Object)new Rectangle2D(lineX, grid.getMinY(), grid.getMaxX() - lineX, grid.getHeight()));
    }

    private AASubdivision() {
        INSTANCE = this;
    }

    static {
        new AASubdivision();
    }
}

