/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.animation;

import com.almasb.fxgl.animation.AnimatedValue;
import com.almasb.fxgl.core.math.FXGLMath;
import javafx.animation.Interpolator;
import javafx.scene.paint.Color;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J(\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\r"}, d2={"Lcom/almasb/fxgl/animation/AnimatedColor;", "Lcom/almasb/fxgl/animation/AnimatedValue;", "Ljavafx/scene/paint/Color;", "from", "to", "interpolator", "Ljavafx/animation/Interpolator;", "(Ljavafx/scene/paint/Color;Ljavafx/scene/paint/Color;Ljavafx/animation/Interpolator;)V", "animate", "val1", "val2", "progress", "", "fxgl"})
public final class AnimatedColor
extends AnimatedValue<Color> {
    @Override
    @NotNull
    public Color animate(@NotNull Color val1, @NotNull Color val2, double progress, @NotNull Interpolator interpolator) {
        Intrinsics.checkParameterIsNotNull((Object)val1, (String)"val1");
        Intrinsics.checkParameterIsNotNull((Object)val2, (String)"val2");
        Intrinsics.checkParameterIsNotNull((Object)interpolator, (String)"interpolator");
        Color color = Color.color((double)FXGLMath.interpolate(val1.getRed(), val2.getRed(), progress, interpolator), (double)FXGLMath.interpolate(val1.getGreen(), val2.getGreen(), progress, interpolator), (double)FXGLMath.interpolate(val1.getBlue(), val2.getBlue(), progress, interpolator), (double)FXGLMath.interpolate(val1.getOpacity(), val2.getOpacity(), progress, interpolator));
        Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"Color.color(\n           \u2026, interpolator)\n        )");
        return color;
    }

    @JvmOverloads
    public AnimatedColor(@NotNull Color from, @NotNull Color to, @NotNull Interpolator interpolator) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        Intrinsics.checkParameterIsNotNull((Object)interpolator, (String)"interpolator");
        super(from, to, interpolator);
    }

    @JvmOverloads
    public /* synthetic */ AnimatedColor(Color color, Color color2, Interpolator interpolator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            Interpolator interpolator2 = Interpolator.LINEAR;
            Intrinsics.checkExpressionValueIsNotNull((Object)interpolator2, (String)"Interpolator.LINEAR");
            interpolator = interpolator2;
        }
        this(color, color2, interpolator);
    }

    @JvmOverloads
    public AnimatedColor(@NotNull Color from, @NotNull Color to) {
        this(from, to, (Interpolator)null, 4, (DefaultConstructorMarker)null);
    }
}

