/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.animation;

import com.almasb.fxgl.animation.EasingInterpolator;
import javafx.animation.Interpolator;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lcom/almasb/fxgl/animation/Interpolators;", "", "Lcom/almasb/fxgl/animation/EasingInterpolator;", "(Ljava/lang/String;I)V", "LINEAR", "QUADRATIC", "CUBIC", "QUARTIC", "QUINTIC", "EXPONENTIAL", "SINE", "CIRCULAR", "SMOOTH", "BOUNCE", "ELASTIC", "BACK", "fxgl"})
public abstract class Interpolators
extends Enum<Interpolators>
implements EasingInterpolator {
    public static final /* enum */ Interpolators LINEAR;
    public static final /* enum */ Interpolators QUADRATIC;
    public static final /* enum */ Interpolators CUBIC;
    public static final /* enum */ Interpolators QUARTIC;
    public static final /* enum */ Interpolators QUINTIC;
    public static final /* enum */ Interpolators EXPONENTIAL;
    public static final /* enum */ Interpolators SINE;
    public static final /* enum */ Interpolators CIRCULAR;
    public static final /* enum */ Interpolators SMOOTH;
    public static final /* enum */ Interpolators BOUNCE;
    public static final /* enum */ Interpolators ELASTIC;
    public static final /* enum */ Interpolators BACK;
    private static final /* synthetic */ Interpolators[] $VALUES;

    static {
        Interpolators[] interpolatorsArray = new Interpolators[12];
        Interpolators[] interpolatorsArray2 = interpolatorsArray;
        interpolatorsArray[0] = LINEAR = new LINEAR("LINEAR", 0);
        interpolatorsArray[1] = QUADRATIC = new QUADRATIC("QUADRATIC", 1);
        interpolatorsArray[2] = CUBIC = new CUBIC("CUBIC", 2);
        interpolatorsArray[3] = QUARTIC = new QUARTIC("QUARTIC", 3);
        interpolatorsArray[4] = QUINTIC = new QUINTIC("QUINTIC", 4);
        interpolatorsArray[5] = EXPONENTIAL = new EXPONENTIAL("EXPONENTIAL", 5);
        interpolatorsArray[6] = SINE = new SINE("SINE", 6);
        interpolatorsArray[7] = CIRCULAR = new CIRCULAR("CIRCULAR", 7);
        interpolatorsArray[8] = SMOOTH = new SMOOTH("SMOOTH", 8);
        interpolatorsArray[9] = BOUNCE = new BOUNCE("BOUNCE", 9);
        interpolatorsArray[10] = ELASTIC = new ELASTIC("ELASTIC", 10);
        interpolatorsArray[11] = BACK = new BACK("BACK", 11);
        $VALUES = interpolatorsArray;
    }

    @Override
    @NotNull
    public Interpolator EASE_IN() {
        return EasingInterpolator.DefaultImpls.EASE_IN(this);
    }

    @Override
    @NotNull
    public Interpolator EASE_OUT() {
        return EasingInterpolator.DefaultImpls.EASE_OUT(this);
    }

    @Override
    @NotNull
    public Interpolator EASE_IN_OUT() {
        return EasingInterpolator.DefaultImpls.EASE_IN_OUT(this);
    }

    public static Interpolators[] values() {
        return (Interpolators[])$VALUES.clone();
    }

    public static Interpolators valueOf(String string) {
        return Enum.valueOf(Interpolators.class, string);
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u00c6\u0001\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\b"}, d2={"Lcom/almasb/fxgl/animation/Interpolators$LINEAR;", "Lcom/almasb/fxgl/animation/Interpolators;", "(Ljava/lang/String;I)V", "easeIn", "", "ratio", "easeInOut", "easeOut", "fxgl"})
    public static final class LINEAR
    extends Interpolators {
        @Override
        public double easeIn(double ratio) {
            return ratio;
        }

        @Override
        public double easeOut(double ratio) {
            return ratio;
        }

        @Override
        public double easeInOut(double ratio) {
            return ratio;
        }

        LINEAR() {
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u00c6\u0001\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\b"}, d2={"Lcom/almasb/fxgl/animation/Interpolators$QUADRATIC;", "Lcom/almasb/fxgl/animation/Interpolators;", "(Ljava/lang/String;I)V", "easeIn", "", "ratio", "easeInOut", "easeOut", "fxgl"})
    public static final class QUADRATIC
    extends Interpolators {
        @Override
        public double easeIn(double ratio) {
            return ratio * ratio;
        }

        @Override
        public double easeOut(double ratio) {
            return -ratio * (ratio - (double)2);
        }

        @Override
        public double easeInOut(double ratio) {
            return ratio < 0.5 ? (double)2 * ratio * ratio : (double)-2 * ratio * (ratio - (double)2) - 1.0;
        }

        QUADRATIC() {
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u00c6\u0001\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\b"}, d2={"Lcom/almasb/fxgl/animation/Interpolators$CUBIC;", "Lcom/almasb/fxgl/animation/Interpolators;", "(Ljava/lang/String;I)V", "easeIn", "", "ratio", "easeInOut", "easeOut", "fxgl"})
    public static final class CUBIC
    extends Interpolators {
        @Override
        public double easeIn(double ratio) {
            return ratio * ratio * ratio;
        }

        @Override
        public double easeOut(double ratio) {
            double r = ratio - 1.0;
            return r * r * r + 1.0;
        }

        @Override
        public double easeInOut(double ratio) {
            double r = ratio - 1.0;
            return ratio < 0.5 ? (double)4 * ratio * ratio * ratio : (double)4 * r * r * r + 1.0;
        }

        CUBIC() {
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u00c6\u0001\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\b"}, d2={"Lcom/almasb/fxgl/animation/Interpolators$QUARTIC;", "Lcom/almasb/fxgl/animation/Interpolators;", "(Ljava/lang/String;I)V", "easeIn", "", "ratio", "easeInOut", "easeOut", "fxgl"})
    public static final class QUARTIC
    extends Interpolators {
        @Override
        public double easeIn(double ratio) {
            return ratio * ratio * ratio * ratio;
        }

        @Override
        public double easeOut(double ratio) {
            double r = ratio - 1.0;
            return 1.0 - r * r * r * r;
        }

        @Override
        public double easeInOut(double ratio) {
            double r = ratio - 1.0;
            return ratio < 0.5 ? (double)8 * ratio * ratio * ratio * ratio : (double)-8 * r * r * r * r + 1.0;
        }

        QUARTIC() {
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u00c6\u0001\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\b"}, d2={"Lcom/almasb/fxgl/animation/Interpolators$QUINTIC;", "Lcom/almasb/fxgl/animation/Interpolators;", "(Ljava/lang/String;I)V", "easeIn", "", "ratio", "easeInOut", "easeOut", "fxgl"})
    public static final class QUINTIC
    extends Interpolators {
        @Override
        public double easeIn(double ratio) {
            return ratio * ratio * ratio * ratio * ratio;
        }

        @Override
        public double easeOut(double ratio) {
            double r = ratio - 1.0;
            return 1.0 + r * r * r * r * r;
        }

        @Override
        public double easeInOut(double ratio) {
            double r = ratio - 1.0;
            return ratio < 0.5 ? (double)16 * ratio * ratio * ratio * ratio * ratio : (double)16 * r * r * r * r * r + 1.0;
        }

        QUINTIC() {
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u00c6\u0001\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\b"}, d2={"Lcom/almasb/fxgl/animation/Interpolators$EXPONENTIAL;", "Lcom/almasb/fxgl/animation/Interpolators;", "(Ljava/lang/String;I)V", "easeIn", "", "ratio", "easeInOut", "easeOut", "fxgl"})
    public static final class EXPONENTIAL
    extends Interpolators {
        @Override
        public double easeIn(double ratio) {
            return ratio == 0.0 ? 0.0 : Math.pow(2.0, (double)10 * (ratio - 1.0));
        }

        @Override
        public double easeOut(double ratio) {
            return ratio == 1.0 ? 1.0 : 1.0 - Math.pow(2.0, (double)-10 * ratio);
        }

        @Override
        public double easeInOut(double ratio) {
            if (ratio == 0.0 || ratio == 1.0) {
                return ratio;
            }
            double r = ratio * (double)2 - 1.0;
            if (r < 0.0) {
                return 0.5 * Math.pow(2.0, (double)10 * r);
            }
            return 1.0 - 0.5 * Math.pow(2.0, (double)-10 * r);
        }

        EXPONENTIAL() {
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u00c6\u0001\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\b"}, d2={"Lcom/almasb/fxgl/animation/Interpolators$SINE;", "Lcom/almasb/fxgl/animation/Interpolators;", "(Ljava/lang/String;I)V", "easeIn", "", "ratio", "easeInOut", "easeOut", "fxgl"})
    public static final class SINE
    extends Interpolators {
        @Override
        public double easeIn(double ratio) {
            return 1.0 - Math.cos(ratio * 1.5707963267948966);
        }

        @Override
        public double easeOut(double ratio) {
            return Math.sin(ratio * 1.5707963267948966);
        }

        @Override
        public double easeInOut(double ratio) {
            return -0.5 * (Math.cos(ratio * Math.PI) - 1.0);
        }

        SINE() {
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u00c6\u0001\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\b"}, d2={"Lcom/almasb/fxgl/animation/Interpolators$CIRCULAR;", "Lcom/almasb/fxgl/animation/Interpolators;", "(Ljava/lang/String;I)V", "easeIn", "", "ratio", "easeInOut", "easeOut", "fxgl"})
    public static final class CIRCULAR
    extends Interpolators {
        @Override
        public double easeIn(double ratio) {
            return -(Math.sqrt(1.0 - ratio * ratio) - 1.0);
        }

        @Override
        public double easeOut(double ratio) {
            return Math.sqrt(1.0 - (ratio - 1.0) * (ratio - 1.0));
        }

        @Override
        public double easeInOut(double ratio) {
            double r = ratio * (double)2;
            double r2 = r - (double)2;
            return r < 1.0 ? -0.5 * (Math.sqrt(1.0 - r * r) - 1.0) : 0.5 * (Math.sqrt(1.0 - r2 * r2) + 1.0);
        }

        CIRCULAR() {
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u00c6\u0001\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\b"}, d2={"Lcom/almasb/fxgl/animation/Interpolators$SMOOTH;", "Lcom/almasb/fxgl/animation/Interpolators;", "(Ljava/lang/String;I)V", "easeIn", "", "ratio", "easeInOut", "easeOut", "fxgl"})
    public static final class SMOOTH
    extends Interpolators {
        @Override
        public double easeIn(double ratio) {
            return Interpolator.EASE_IN.interpolate(0.0, 1.0, ratio);
        }

        @Override
        public double easeOut(double ratio) {
            return Interpolator.EASE_OUT.interpolate(0.0, 1.0, ratio);
        }

        @Override
        public double easeInOut(double ratio) {
            return Interpolator.EASE_BOTH.interpolate(0.0, 1.0, ratio);
        }

        SMOOTH() {
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u00c6\u0001\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\b"}, d2={"Lcom/almasb/fxgl/animation/Interpolators$BOUNCE;", "Lcom/almasb/fxgl/animation/Interpolators;", "(Ljava/lang/String;I)V", "easeIn", "", "ratio", "easeInOut", "easeOut", "fxgl"})
    public static final class BOUNCE
    extends Interpolators {
        @Override
        public double easeIn(double ratio) {
            return 1.0 - this.easeOut(1.0 - ratio);
        }

        @Override
        public double easeOut(double ratio) {
            if (ratio < 0.36363636363636365) {
                return 7.5625 * ratio * ratio;
            }
            if (ratio < 0.7272727272727273) {
                double r = ratio - 0.5454545454545454;
                return 7.5625 * r * r + 0.75;
            }
            if (ratio < 0.9090909090909091) {
                double r = ratio - 0.8181818181818182;
                return 7.5625 * r * r + 0.9375;
            }
            double r = ratio - 0.9545454545454546;
            return 7.5625 * r * r + 0.984375;
        }

        @Override
        public double easeInOut(double ratio) {
            double r = ratio * (double)2;
            return r < 1.0 ? 0.5 * this.easeIn(r) : 0.5 * this.easeOut(r - 1.0) + 0.5;
        }

        BOUNCE() {
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\b\u00c6\u0001\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/almasb/fxgl/animation/Interpolators$ELASTIC;", "Lcom/almasb/fxgl/animation/Interpolators;", "(Ljava/lang/String;I)V", "a", "", "p", "", "s", "easeIn", "ratio", "easeInOut", "easeOut", "fxgl"})
    public static final class ELASTIC
    extends Interpolators {
        private final int a = 1;
        private final double p = 0.3;
        private final double s = this.p / (double)4;

        @Override
        public double easeIn(double ratio) {
            if (ratio == 0.0 || ratio == 1.0) {
                return ratio;
            }
            double r = ratio - 1.0;
            return -((double)this.a * Math.pow(2.0, (double)10 * r) * Math.sin((r - this.s) * (Math.PI * 2) / this.p));
        }

        @Override
        public double easeOut(double ratio) {
            if (ratio == 0.0 || ratio == 1.0) {
                return ratio;
            }
            return (double)this.a * Math.pow(2.0, (double)-10 * ratio) * Math.sin((ratio - this.s) * (Math.PI * 2) / this.p) + 1.0;
        }

        @Override
        public double easeInOut(double ratio) {
            if (ratio == 0.0 || ratio == 1.0) {
                return ratio;
            }
            double r = ratio * (double)2 - 1.0;
            if (r < 0.0) {
                return -0.5 * ((double)this.a * Math.pow(2.0, (double)10 * r) * Math.sin((r - this.s * 1.5) * (Math.PI * 2) / (this.p * 1.5)));
            }
            return 0.5 * (double)this.a * Math.pow(2.0, (double)-10 * r) * Math.sin((r - this.s * 1.5) * (Math.PI * 2) / (this.p * 1.5)) + 1.0;
        }

        ELASTIC() {
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/almasb/fxgl/animation/Interpolators$BACK;", "Lcom/almasb/fxgl/animation/Interpolators;", "(Ljava/lang/String;I)V", "s", "", "easeIn", "ratio", "easeInOut", "easeOut", "fxgl"})
    public static final class BACK
    extends Interpolators {
        private final double s = 1.70158;

        @Override
        public double easeIn(double ratio) {
            return ratio * ratio * ((this.s + 1.0) * ratio - this.s);
        }

        @Override
        public double easeOut(double ratio) {
            double r = ratio - 1.0;
            return r * r * ((this.s + 1.0) * r + this.s) + 1.0;
        }

        @Override
        public double easeInOut(double ratio) {
            double r = ratio * (double)2;
            double r2 = r - (double)2;
            return r < 1.0 ? 0.5 * (r * r * ((this.s * 1.525 + 1.0) * r - this.s * 1.525)) : 0.5 * (r2 * r2 * ((this.s * 1.525 + 1.0) * r2 + this.s * 1.525) + (double)2);
        }

        BACK() {
        }
    }
}

