/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.core.logging;

import com.almasb.fxgl.core.logging.DefaultMessageFormatter;
import com.almasb.fxgl.core.logging.Logger$Companion$WhenMappings;
import com.almasb.fxgl.core.logging.LoggerConfig;
import com.almasb.fxgl.core.logging.LoggerLevel;
import com.almasb.fxgl.core.logging.LoggerOutput;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\t\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003J'\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00032\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000b\"\u00020\u0001\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003J'\u0010\u000e\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00032\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000b\"\u00020\u0001\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003J'\u0010\u0010\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00032\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000b\"\u00020\u0001\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003J'\u0010\u0012\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00032\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000b\"\u00020\u0001\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/almasb/fxgl/core/logging/Logger;", "", "name", "", "(Ljava/lang/String;)V", "debug", "", "message", "debugf", "format", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "fatal", "fatalf", "info", "infof", "warning", "warningf", "Companion", "fxgl"})
public final class Logger {
    private final String name;
    private static final ArrayList<LoggerOutput> outputs;
    private static final ArrayList<LoggerOutput> debug;
    private static final ArrayList<LoggerOutput> info;
    private static final ArrayList<LoggerOutput> warning;
    private static final ArrayList<LoggerOutput> fatal;
    private static LoggerConfig config;
    private static boolean configured;
    private static boolean closed;
    public static final Companion Companion;

    public final void info(@NotNull String message2) {
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        Logger.Companion.doLog(this.name, message2, LoggerLevel.INFO);
    }

    public final void infof(@NotNull String format, Object ... args) {
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        Object[] objectArray = Arrays.copyOf(args, args.length);
        Logger logger = this;
        String string = String.format(format, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
        String string2 = string;
        logger.info(string2);
    }

    public final void debug(@NotNull String message2) {
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        Logger.Companion.doLog(this.name, message2, LoggerLevel.DEBUG);
    }

    public final void debugf(@NotNull String format, Object ... args) {
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        Object[] objectArray = Arrays.copyOf(args, args.length);
        Logger logger = this;
        String string = String.format(format, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
        String string2 = string;
        logger.debug(string2);
    }

    public final void warning(@NotNull String message2) {
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        Logger.Companion.doLog(this.name, message2, LoggerLevel.WARNING);
    }

    public final void warningf(@NotNull String format, Object ... args) {
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        Object[] objectArray = Arrays.copyOf(args, args.length);
        Logger logger = this;
        String string = String.format(format, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
        String string2 = string;
        logger.warning(string2);
    }

    public final void fatal(@NotNull String message2) {
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        Logger.Companion.doLog(this.name, message2, LoggerLevel.FATAL);
    }

    public final void fatalf(@NotNull String format, Object ... args) {
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        Object[] objectArray = Arrays.copyOf(args, args.length);
        Logger logger = this;
        String string = String.format(format, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
        String string2 = string;
        logger.fatal(string2);
    }

    private Logger(String name) {
        this.name = name;
    }

    static {
        Companion = new Companion(null);
        outputs = new ArrayList();
        debug = new ArrayList();
        info = new ArrayList();
        warning = new ArrayList();
        fatal = new ArrayList();
        config = new LoggerConfig();
    }

    public /* synthetic */ Logger(@NotNull String name, DefaultConstructorMarker $constructor_marker) {
        this(name);
    }

    @JvmStatic
    public static final boolean isConfigured() {
        return Companion.isConfigured();
    }

    @JvmStatic
    public static final void configure(@NotNull LoggerConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Companion.configure(config);
    }

    @JvmStatic
    public static final void addOutput(@NotNull LoggerOutput loggerOutput, @NotNull LoggerLevel level) {
        Intrinsics.checkParameterIsNotNull((Object)loggerOutput, (String)"loggerOutput");
        Intrinsics.checkParameterIsNotNull((Object)((Object)level), (String)"level");
        Companion.addOutput(loggerOutput, level);
    }

    @JvmStatic
    @NotNull
    public static final Logger get(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return Companion.get(name);
    }

    @JvmStatic
    @NotNull
    public static final Logger get(@NotNull Class<?> caller) {
        Intrinsics.checkParameterIsNotNull(caller, (String)"caller");
        return Companion.get(caller);
    }

    @JvmStatic
    public static final void close() {
        Companion.close();
    }

    @JvmStatic
    @NotNull
    public static final String errorTraceAsString(@NotNull Throwable e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        return Companion.errorTraceAsString(e);
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$H\u0007J\b\u0010%\u001a\u00020!H\u0007J\u0010\u0010&\u001a\u00020!2\u0006\u0010\t\u001a\u00020\nH\u0007J \u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020-H\u0007J\u0014\u0010.\u001a\u00020/2\n\u00100\u001a\u0006\u0012\u0002\b\u000301H\u0007J\u0010\u0010.\u001a\u00020/2\u0006\u00102\u001a\u00020)H\u0007J\b\u00103\u001a\u00020\u0004H\u0007J \u00104\u001a\u00020)2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010#\u001a\u00020$H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR$\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u0015X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R$\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u0015X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R$\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u0015X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017R$\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u0015X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0017R$\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u0015X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0017\u00a8\u00065"}, d2={"Lcom/almasb/fxgl/core/logging/Logger$Companion;", "", "()V", "closed", "", "getClosed", "()Z", "setClosed", "(Z)V", "config", "Lcom/almasb/fxgl/core/logging/LoggerConfig;", "getConfig", "()Lcom/almasb/fxgl/core/logging/LoggerConfig;", "setConfig", "(Lcom/almasb/fxgl/core/logging/LoggerConfig;)V", "configured", "getConfigured", "setConfigured", "debug", "Ljava/util/ArrayList;", "Lcom/almasb/fxgl/core/logging/LoggerOutput;", "Lkotlin/collections/ArrayList;", "getDebug", "()Ljava/util/ArrayList;", "fatal", "getFatal", "info", "getInfo", "outputs", "getOutputs", "warning", "getWarning", "addOutput", "", "loggerOutput", "level", "Lcom/almasb/fxgl/core/logging/LoggerLevel;", "close", "configure", "doLog", "loggerName", "", "loggerMessage", "errorTraceAsString", "e", "", "get", "Lcom/almasb/fxgl/core/logging/Logger;", "caller", "Ljava/lang/Class;", "name", "isConfigured", "makeMessage", "fxgl"})
    public static final class Companion {
        private final ArrayList<LoggerOutput> getOutputs() {
            return outputs;
        }

        private final ArrayList<LoggerOutput> getDebug() {
            return debug;
        }

        private final ArrayList<LoggerOutput> getInfo() {
            return info;
        }

        private final ArrayList<LoggerOutput> getWarning() {
            return warning;
        }

        private final ArrayList<LoggerOutput> getFatal() {
            return fatal;
        }

        private final LoggerConfig getConfig() {
            return config;
        }

        private final void setConfig(LoggerConfig loggerConfig) {
            config = loggerConfig;
        }

        private final boolean getConfigured() {
            return configured;
        }

        private final void setConfigured(boolean bl) {
            configured = bl;
        }

        private final boolean getClosed() {
            return closed;
        }

        private final void setClosed(boolean bl) {
            closed = bl;
        }

        @JvmStatic
        public final boolean isConfigured() {
            return this.getConfigured();
        }

        @JvmStatic
        public final void configure(@NotNull LoggerConfig config) {
            Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
            if (this.getConfigured()) {
                throw (Throwable)new IllegalStateException("Logger already configured");
            }
            this.setConfig(config.copy());
            this.setConfigured(true);
        }

        @JvmStatic
        public final void addOutput(@NotNull LoggerOutput loggerOutput, @NotNull LoggerLevel level) {
            Intrinsics.checkParameterIsNotNull((Object)loggerOutput, (String)"loggerOutput");
            Intrinsics.checkParameterIsNotNull((Object)((Object)level), (String)"level");
            this.getOutputs().add(loggerOutput);
            switch (Logger$Companion$WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
                case 1: {
                    this.getDebug().add(loggerOutput);
                    this.getInfo().add(loggerOutput);
                    this.getWarning().add(loggerOutput);
                    this.getFatal().add(loggerOutput);
                    break;
                }
                case 2: {
                    this.getInfo().add(loggerOutput);
                    this.getWarning().add(loggerOutput);
                    this.getFatal().add(loggerOutput);
                    break;
                }
                case 3: {
                    this.getWarning().add(loggerOutput);
                    this.getFatal().add(loggerOutput);
                    break;
                }
                case 4: {
                    this.getFatal().add(loggerOutput);
                }
            }
        }

        private final void doLog(String loggerName, String loggerMessage, LoggerLevel level) {
            Lazy message2 = LazyKt.lazy((Function0)((Function0)new Function0<String>(loggerName, loggerMessage, level){
                final /* synthetic */ String $loggerName;
                final /* synthetic */ String $loggerMessage;
                final /* synthetic */ LoggerLevel $level;

                @NotNull
                public final String invoke() {
                    return com.almasb.fxgl.core.logging.Logger$Companion.access$makeMessage(Logger.Companion, this.$loggerName, this.$loggerMessage, this.$level);
                }
                {
                    this.$loggerName = string;
                    this.$loggerMessage = string2;
                    this.$level = loggerLevel;
                    super(0);
                }
            }));
            switch (Logger$Companion$WhenMappings.$EnumSwitchMapping$1[level.ordinal()]) {
                case 1: {
                    Iterable $receiver$iv = this.getDebug();
                    for (Object element$iv : $receiver$iv) {
                        LoggerOutput it = (LoggerOutput)element$iv;
                        it.append((String)message2.getValue());
                    }
                    break;
                }
                case 2: {
                    Iterable $receiver$iv = this.getInfo();
                    for (Object element$iv : $receiver$iv) {
                        LoggerOutput it = (LoggerOutput)element$iv;
                        it.append((String)message2.getValue());
                    }
                    break;
                }
                case 3: {
                    Iterable $receiver$iv = this.getWarning();
                    for (Object element$iv : $receiver$iv) {
                        LoggerOutput it = (LoggerOutput)element$iv;
                        it.append((String)message2.getValue());
                    }
                    break;
                }
                case 4: {
                    Iterable $receiver$iv = this.getFatal();
                    for (Object element$iv : $receiver$iv) {
                        LoggerOutput it = (LoggerOutput)element$iv;
                        it.append((String)message2.getValue());
                    }
                    break;
                }
            }
        }

        private final String makeMessage(String loggerName, String loggerMessage, LoggerLevel level) {
            String time = LocalTime.now().format(this.getConfig().getDateTimeFormatter());
            String threadName = Thread.currentThread().getName();
            DefaultMessageFormatter defaultMessageFormatter = this.getConfig().getMessageFormatter();
            String string = time;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"time");
            String string2 = threadName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"threadName");
            return defaultMessageFormatter.makeMessage(string, string2, "" + (Object)((Object)level), loggerName, loggerMessage);
        }

        @JvmStatic
        @NotNull
        public final Logger get(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            return new Logger(name, null);
        }

        @JvmStatic
        @NotNull
        public final Logger get(@NotNull Class<?> caller) {
            Intrinsics.checkParameterIsNotNull(caller, (String)"caller");
            String string = caller.getSimpleName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"caller.simpleName");
            return this.get(string);
        }

        @JvmStatic
        public final void close() {
            if (this.getClosed()) {
                throw (Throwable)new IllegalStateException("Logger already closed");
            }
            Iterable $receiver$iv = this.getOutputs();
            for (Object element$iv : $receiver$iv) {
                LoggerOutput p1 = (LoggerOutput)element$iv;
                p1.close();
            }
            this.setClosed(true);
        }

        @JvmStatic
        @NotNull
        public final String errorTraceAsString(@NotNull Throwable e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            StringBuilder sb = new StringBuilder();
            sb.append("\n\nException occurred: ").append(e.getClass().getCanonicalName()).append(" : ").append("" + e.getMessage() + '\n');
            StackTraceElement[] elements = e.getStackTrace();
            for (int i = 0; i < elements.length; ++i) {
                StackTraceElement el = elements[i];
                sb.append("E: ").append(el.toString()).append('\n');
            }
            String string = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
            return string;
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ String access$makeMessage(Companion $this, @NotNull String loggerName, @NotNull String loggerMessage, @NotNull LoggerLevel level) {
            return $this.makeMessage(loggerName, loggerMessage, level);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

