/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.core.math;

import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.math.Vec2;
import kotlin.Metadata;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\b\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/almasb/fxgl/core/math/PerlinNoiseGenerator;", "", "()V", "NOISE_MASK", "", "NOISE_TABLE_SIZE", "gx", "", "gy", "noise1D", "", "t", "setSeedAndReinitialize", "", "fxgl"})
public final class PerlinNoiseGenerator {
    private static final int NOISE_TABLE_SIZE = 256;
    private static final int NOISE_MASK = 255;
    private static final float[] gx;
    private static final float[] gy;
    public static final PerlinNoiseGenerator INSTANCE;

    /*
     * WARNING - void declaration
     */
    private final void setSeedAndReinitialize() {
        int n = 0;
        int n2 = NOISE_TABLE_SIZE - 1;
        if (n <= n2) {
            while (true) {
                void i;
                Vec2 v = new Vec2();
                v.x = FXGLMath.random() - 0.5f;
                v.y = FXGLMath.random() - 0.5f;
                v.normalizeLocal();
                PerlinNoiseGenerator.gx[i] = v.x;
                PerlinNoiseGenerator.gy[i] = v.y;
                if (i == n2) break;
                ++i;
            }
        }
    }

    public final float noise1D(float t) {
        int qx0 = (int)Math.floor(t);
        int qx1 = qx0 + 1;
        float tx0 = t - (float)qx0;
        float tx1 = tx0 - 1.0f;
        float v0 = gx[qx0 &= NOISE_MASK] * tx0;
        float v1 = gx[qx1 &= NOISE_MASK] * tx1;
        float wx = ((float)3 - (float)2 * tx0) * tx0 * tx0;
        return v0 - wx * (v0 - v1);
    }

    private PerlinNoiseGenerator() {
        INSTANCE = this;
        NOISE_TABLE_SIZE = 256;
        NOISE_MASK = 255;
        gx = new float[NOISE_TABLE_SIZE];
        gy = new float[NOISE_TABLE_SIZE];
        this.setSeedAndReinitialize();
    }

    static {
        new PerlinNoiseGenerator();
    }
}

