/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.devtools.profiling;

import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.core.math.FXGLMath;
import java.util.Arrays;
import javafx.scene.text.Text;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 +2\u00020\u0001:\u0001+B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0017\u001a\u00020\u0004J\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0004J\u0006\u0010\u001b\u001a\u00020\u0006J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u0019J\u0006\u0010\u001f\u001a\u00020\u0004J\u0006\u0010 \u001a\u00020\u001dJ\u0006\u0010!\u001a\u00020\u0019J\u0006\u0010\"\u001a\u00020\u0004J\u0006\u0010#\u001a\u00020\u0019J\u0006\u0010$\u001a\u00020\u0004J\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020)J\u0016\u0010*\u001a\u00020&2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/almasb/fxgl/devtools/profiling/Profiler;", "", "()V", "currentFPS", "", "currentTimeTook", "", "fps", "<set-?>", "frames", "getFrames", "()I", "setFrames", "(I)V", "gcRuns", "memoryUsage", "memoryUsageCurrent", "memoryUsageMax", "memoryUsageMin", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "timeTook", "getAvgFPS", "getAvgMemoryUsage", "", "getAvgMemoryUsageRounded", "getAvgTimeTook", "getAvgTimeTookRounded", "", "getCurrentMemoryUsage", "getCurrentMemoryUsageRounded", "getInfo", "getMaxMemoryUsage", "getMaxMemoryUsageRounded", "getMinMemoryUsage", "getMinMemoryUsageRounded", "print", "", "render", "text", "Ljavafx/scene/text/Text;", "update", "Companion", "fxgl"})
public final class Profiler {
    private int frames = 1;
    private int fps;
    private int currentFPS;
    private long currentTimeTook;
    private long timeTook;
    private long memoryUsage;
    private long memoryUsageMin = Long.MAX_VALUE;
    private long memoryUsageMax;
    private long memoryUsageCurrent;
    private int gcRuns;
    private final StringBuilder sb = new StringBuilder(128);
    private static final Runtime runtime;
    private static final float MB = 1048576.0f;
    public static final Companion Companion;

    public final int getFrames() {
        return this.frames;
    }

    private final void setFrames(int n) {
        this.frames = n;
    }

    public final int getAvgFPS() {
        return this.fps / this.frames;
    }

    public final long getAvgTimeTook() {
        return this.timeTook / (long)this.frames;
    }

    @NotNull
    public final String getAvgTimeTookRounded() {
        String string = "%.2f";
        Object[] objectArray = new Object[]{(double)this.getAvgTimeTook() / 1000000.0};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
        return string2;
    }

    public final float getAvgMemoryUsage() {
        return (float)(this.memoryUsage / (long)this.frames) / Profiler.Companion.getMB();
    }

    public final int getAvgMemoryUsageRounded() {
        return FXGLMath.roundPositive(this.getAvgMemoryUsage());
    }

    public final float getMaxMemoryUsage() {
        return (float)this.memoryUsageMax / Profiler.Companion.getMB();
    }

    public final int getMaxMemoryUsageRounded() {
        return FXGLMath.roundPositive(this.getMaxMemoryUsage());
    }

    public final float getMinMemoryUsage() {
        return (float)this.memoryUsageMin / Profiler.Companion.getMB();
    }

    public final int getMinMemoryUsageRounded() {
        return FXGLMath.roundPositive(this.getMinMemoryUsage());
    }

    public final float getCurrentMemoryUsage() {
        return (float)this.memoryUsageCurrent / Profiler.Companion.getMB();
    }

    public final int getCurrentMemoryUsageRounded() {
        return FXGLMath.roundPositive(this.getCurrentMemoryUsage());
    }

    public final void update(int fps, long timeTook) {
        int n = this.frames;
        this.frames = n + 1;
        this.currentFPS = fps;
        this.currentTimeTook = timeTook;
        this.fps += fps;
        this.timeTook += timeTook;
        long used = Profiler.Companion.getRuntime().totalMemory() - Profiler.Companion.getRuntime().freeMemory();
        if (used < 0L) {
            return;
        }
        if (used < this.memoryUsageCurrent) {
            int n2 = this.gcRuns;
            this.gcRuns = n2 + 1;
        }
        this.memoryUsageCurrent = used;
        this.memoryUsage += this.memoryUsageCurrent;
        if (this.memoryUsageCurrent > this.memoryUsageMax) {
            this.memoryUsageMax = this.memoryUsageCurrent;
        }
        if (this.memoryUsageCurrent < this.memoryUsageMin) {
            this.memoryUsageMin = this.memoryUsageCurrent;
        }
    }

    public final void render(@NotNull Text text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        text.setText(this.getInfo());
    }

    public final void print() {
        Logger log2 = Logger.Companion.get(this.getClass());
        log2.info("Processed Frames: " + this.frames);
        log2.info("Average FPS: " + this.getAvgFPS());
        log2.info("Avg Frame Took: " + this.getAvgTimeTookRounded() + " ms");
        log2.info("Avg Memory Usage: " + this.getAvgMemoryUsageRounded() + " MB");
        log2.info("Min Memory Usage: " + this.getMinMemoryUsageRounded() + " MB");
        log2.info("Max Memory Usage: " + this.getMaxMemoryUsageRounded() + " MB");
        log2.info("Estimated GC runs: " + this.gcRuns);
    }

    @NotNull
    public final String getInfo() {
        this.sb.setLength(0);
        String string = "%.0f";
        Object[] objectArray = new Object[]{(double)this.currentTimeTook / 1000000.0};
        StringBuilder stringBuilder = this.sb.append("FPS: ").append(this.currentFPS).append("\nLast Frame (ms): ");
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
        String string3 = string2;
        stringBuilder.append(string3).append("\nNow Mem (MB): ").append(this.getCurrentMemoryUsageRounded()).append("\nAvg Mem (MB): ").append(this.getAvgMemoryUsageRounded()).append("\nMin Mem (MB): ").append(this.getMinMemoryUsageRounded()).append("\nMax Mem (MB): ").append(this.getMaxMemoryUsageRounded());
        String string4 = this.sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"sb.toString()");
        return string4;
    }

    static {
        Companion = new Companion(null);
        runtime = Runtime.getRuntime();
        MB = 1048576.0f;
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/almasb/fxgl/devtools/profiling/Profiler$Companion;", "", "()V", "MB", "", "getMB", "()F", "runtime", "Ljava/lang/Runtime;", "kotlin.jvm.PlatformType", "getRuntime", "()Ljava/lang/Runtime;", "fxgl"})
    public static final class Companion {
        private final Runtime getRuntime() {
            return runtime;
        }

        private final float getMB() {
            return MB;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

