/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.action;

import com.almasb.fxgl.entity.Entity;

public abstract class Action<T extends Entity> {
    private T entity;

    public final T getEntity() {
        return this.entity;
    }

    void setEntity(T entity) {
        if (entity == null && this.entity == null) {
            throw new IllegalStateException("Attempt to clear entity but action is not attached to an entity");
        }
        if (entity != null && this.entity != null) {
            throw new IllegalStateException("Attempt to set entity but action is already attached to an entity");
        }
        if (entity != null) {
            this.onAdded(entity);
        } else {
            this.onRemoved(this.entity);
        }
        this.entity = entity;
    }

    protected void onAdded(T entity) {
    }

    protected void onRemoved(T entity) {
    }

    public abstract boolean isComplete();

    protected abstract void onUpdate(T var1, double var2);
}

