/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.component;

import com.almasb.fxgl.devtools.DeveloperEditable;
import com.almasb.fxgl.entity.CopyableComponent;
import com.almasb.fxgl.entity.component.CoreComponent;
import com.almasb.fxgl.entity.component.DoubleComponent;
import javafx.beans.property.DoubleProperty;
import javafx.geometry.Point2D;

@CoreComponent
public class RotationComponent
extends DoubleComponent
implements CopyableComponent<RotationComponent> {
    public RotationComponent() {
        this(0.0);
    }

    public RotationComponent(double angle) {
        super(angle);
    }

    public final void rotateBy(double byAngle) {
        this.setValue(this.getValue() + byAngle);
    }

    public final void rotateToVector(Point2D vector) {
        double angle = Math.toDegrees(Math.atan2(vector.getY(), vector.getX()));
        this.setValue(angle);
    }

    @DeveloperEditable(value="Angle")
    public final DoubleProperty angleProperty() {
        return this.valueProperty();
    }

    @Override
    public String toString() {
        return "Rotation(" + this.getValue() + "deg)";
    }

    @Override
    public RotationComponent copy() {
        return new RotationComponent(this.getValue());
    }
}

