/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.control;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.entity.Control;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.time.TimerAction;
import javafx.util.Duration;

public class ExpireCleanControl
extends Control {
    private Duration expire;
    private boolean animate = false;
    private TimerAction timerAction;
    private double time = 0.0;

    public ExpireCleanControl(Duration expire) {
        this.expire = expire;
    }

    @Override
    public void onAdded(Entity entity) {
        entity.activeProperty().addListener((observable, oldValue, isActive) -> {
            if (isActive.booleanValue()) {
                this.timerAction = FXGL.getMasterTimer().runOnceAfter(entity::removeFromWorld, this.expire);
            } else {
                this.timerAction.expire();
            }
        });
    }

    @Override
    public void onUpdate(Entity entity, double tpf) {
        if (this.timerAction == null) {
            this.timerAction = FXGL.getMasterTimer().runOnceAfter(entity::removeFromWorld, this.expire);
        } else if (this.animate) {
            this.updateOpacity(tpf);
        }
    }

    private void updateOpacity(double tpf) {
        this.time += tpf;
        this.getEntity().getView().setOpacity(this.time >= this.expire.toSeconds() ? 0.0 : 1.0 - this.time / this.expire.toSeconds());
    }

    public ExpireCleanControl animateOpacity() {
        this.animate = true;
        return this;
    }
}

