/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.control;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.entity.Control;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.scene.Viewport;

public class KeepOnScreenControl
extends Control {
    private Viewport viewport;
    private boolean horizontally;
    private boolean vertically;

    public KeepOnScreenControl(boolean horizontally, boolean vertically) {
        this.horizontally = horizontally;
        this.vertically = vertically;
    }

    @Override
    public void onAdded(Entity entity) {
        this.viewport = FXGL.getApp().getGameScene().getViewport();
    }

    @Override
    public void onUpdate(Entity entity, double tpf) {
        this.blockWithBBox();
    }

    private void blockWithBBox() {
        if (this.horizontally) {
            if (this.getEntity().getX() < this.viewport.getX()) {
                this.getEntity().setX(this.viewport.getX());
            } else if (this.getEntity().getRightX() > this.viewport.getX() + this.viewport.getWidth()) {
                this.getEntity().setX(this.viewport.getX() + this.viewport.getWidth() - this.getEntity().getWidth());
            }
        }
        if (this.vertically) {
            if (this.getEntity().getY() < this.viewport.getY()) {
                this.getEntity().setY(this.viewport.getY());
            } else if (this.getEntity().getBottomY() > this.viewport.getY() + this.viewport.getHeight()) {
                this.getEntity().setY(this.viewport.getY() + this.viewport.getHeight() - this.getEntity().getHeight());
            }
        }
    }
}

