/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.view;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.entity.RenderLayer;
import com.almasb.fxgl.entity.view.EntityView;
import com.almasb.fxgl.scene.Viewport;
import com.almasb.fxgl.texture.Texture;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B-\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u0019H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/almasb/fxgl/entity/view/ScrollingBackgroundView;", "Lcom/almasb/fxgl/entity/view/EntityView;", "texture", "Lcom/almasb/fxgl/texture/Texture;", "orientation", "Ljavafx/geometry/Orientation;", "speed", "", "renderLayer", "Lcom/almasb/fxgl/entity/RenderLayer;", "(Lcom/almasb/fxgl/texture/Texture;Ljavafx/geometry/Orientation;DLcom/almasb/fxgl/entity/RenderLayer;)V", "canvas", "Ljavafx/scene/canvas/Canvas;", "g", "Ljavafx/scene/canvas/GraphicsContext;", "image", "Ljavafx/scene/image/Image;", "kotlin.jvm.PlatformType", "getOrientation", "()Ljavafx/geometry/Orientation;", "getSpeed", "()D", "sx", "sy", "redraw", "", "redrawX", "redrawY", "fxgl"})
public final class ScrollingBackgroundView
extends EntityView {
    private final Canvas canvas;
    private final GraphicsContext g;
    private final Image image;
    private double sx;
    private double sy;
    @NotNull
    private final Orientation orientation;
    private final double speed;

    private final void redraw() {
        this.g.clearRect(0.0, 0.0, this.canvas.getWidth(), this.canvas.getHeight());
        if (Intrinsics.areEqual((Object)this.orientation, (Object)Orientation.HORIZONTAL)) {
            this.redrawX();
        } else {
            this.redrawY();
        }
    }

    private final void redrawX() {
        boolean overflowX;
        double w = this.canvas.getWidth();
        double h = this.canvas.getHeight();
        boolean bl = overflowX = this.sx + w > this.image.getWidth();
        if (overflowX) {
            w = this.image.getWidth() - this.sx;
        }
        this.g.drawImage(this.image, this.sx, this.sy, w, h, 0.0, 0.0, w, h);
        if (overflowX) {
            this.g.drawImage(this.image, 0.0, 0.0, this.canvas.getWidth() - w, h, w, 0.0, this.canvas.getWidth() - w, h);
        }
    }

    private final void redrawY() {
        boolean overflowY;
        double w = this.canvas.getWidth();
        double h = this.canvas.getHeight();
        boolean bl = overflowY = this.sy + h > this.image.getHeight();
        if (overflowY) {
            h = this.image.getHeight() - this.sy;
        }
        this.g.drawImage(this.image, this.sx, this.sy, w, h, 0.0, 0.0, w, h);
        if (overflowY) {
            this.g.drawImage(this.image, 0.0, 0.0, w, this.canvas.getHeight() - h, 0.0, h, w, this.canvas.getHeight() - h);
        }
    }

    @NotNull
    public final Orientation getOrientation() {
        return this.orientation;
    }

    public final double getSpeed() {
        return this.speed;
    }

    @JvmOverloads
    public ScrollingBackgroundView(@NotNull Texture texture, @NotNull Orientation orientation, double speed, @NotNull RenderLayer renderLayer) {
        Intrinsics.checkParameterIsNotNull((Object)texture, (String)"texture");
        Intrinsics.checkParameterIsNotNull((Object)orientation, (String)"orientation");
        Intrinsics.checkParameterIsNotNull((Object)renderLayer, (String)"renderLayer");
        super(renderLayer);
        this.orientation = orientation;
        this.speed = speed;
        this.image = texture.getImage();
        Viewport viewport = FXGL.Companion.getApp().getGameScene().getViewport();
        this.canvas = new Canvas(viewport.getWidth(), viewport.getHeight());
        GraphicsContext graphicsContext = this.canvas.getGraphicsContext2D();
        Intrinsics.checkExpressionValueIsNotNull((Object)graphicsContext, (String)"canvas.graphicsContext2D");
        this.g = graphicsContext;
        if (Intrinsics.areEqual((Object)this.orientation, (Object)Orientation.HORIZONTAL)) {
            this.translateXProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public final void changed(ObservableValue<? extends Number> $noName_0, Number $noName_1, Number x) {
                    if (x.intValue() < 0) {
                        throw (Throwable)new IllegalStateException("Background x cannot be < 0");
                    }
                    sx = x.doubleValue() * this.getSpeed() % image.getWidth();
                    this.redraw();
                }
            });
            this.translateXProperty().bind((ObservableValue)viewport.xProperty());
        } else {
            this.translateYProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public final void changed(ObservableValue<? extends Number> $noName_0, Number $noName_1, Number y) {
                    if (y.intValue() < 0) {
                        throw (Throwable)new IllegalStateException("Background y cannot be < 0");
                    }
                    sy = y.doubleValue() * this.getSpeed() % image.getHeight();
                    this.redraw();
                }
            });
            this.translateYProperty().bind((ObservableValue)viewport.yProperty());
        }
        this.addNode((Node)this.canvas);
        this.redraw();
    }

    @JvmOverloads
    public /* synthetic */ ScrollingBackgroundView(Texture texture, Orientation orientation, double d, RenderLayer renderLayer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            orientation = Orientation.HORIZONTAL;
        }
        if ((n & 4) != 0) {
            d = 1.0;
        }
        if ((n & 8) != 0) {
            RenderLayer renderLayer2 = RenderLayer.BACKGROUND;
            Intrinsics.checkExpressionValueIsNotNull((Object)renderLayer2, (String)"RenderLayer.BACKGROUND");
            renderLayer = renderLayer2;
        }
        this(texture, orientation, d, renderLayer);
    }

    @JvmOverloads
    public ScrollingBackgroundView(@NotNull Texture texture, @NotNull Orientation orientation, double speed) {
        this(texture, orientation, speed, null, 8, null);
    }

    @JvmOverloads
    public ScrollingBackgroundView(@NotNull Texture texture, @NotNull Orientation orientation) {
        this(texture, orientation, 0.0, null, 12, null);
    }

    @JvmOverloads
    public ScrollingBackgroundView(@NotNull Texture texture) {
        this(texture, null, 0.0, null, 14, null);
    }

    public static final /* synthetic */ double access$getSx$p(ScrollingBackgroundView $this) {
        return $this.sx;
    }

    public static final /* synthetic */ double access$getSy$p(ScrollingBackgroundView $this) {
        return $this.sy;
    }
}

