/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.gameplay;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.gameplay.Achievement;
import com.almasb.fxgl.gameplay.AchievementEvent;
import com.almasb.fxgl.gameplay.AchievementProgressEvent;
import com.almasb.fxgl.gameplay.GameState;
import com.almasb.fxgl.gameplay.PropertyChangeListener;
import com.almasb.fxgl.io.serialization.Bundle;
import com.almasb.fxgl.saving.UserProfile;
import com.almasb.fxgl.saving.UserProfileSavable;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\r\u0010\u0016\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0017J\u000e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0005J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R?\u0010\u0007\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/almasb/fxgl/gameplay/AchievementManager;", "Lcom/almasb/fxgl/saving/UserProfileSavable;", "()V", "achievements", "Ljavafx/collections/ObservableList;", "Lcom/almasb/fxgl/gameplay/Achievement;", "kotlin.jvm.PlatformType", "achievementsReadOnly", "getAchievementsReadOnly", "()Ljavafx/collections/ObservableList;", "achievementsReadOnly$delegate", "Lkotlin/Lazy;", "log", "Lcom/almasb/fxgl/core/logging/Logger;", "getAchievementByName", "name", "", "getAchievements", "load", "", "profile", "Lcom/almasb/fxgl/saving/UserProfile;", "rebindAchievements", "rebindAchievements$fxgl", "registerAchievement", "a", "save", "fxgl"})
public final class AchievementManager
implements UserProfileSavable {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Logger log = Logger.Companion.get(this.getClass());
    private final ObservableList<Achievement> achievements = FXCollections.observableArrayList();
    private final Lazy achievementsReadOnly$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ObservableList<Achievement>>(this){
        final /* synthetic */ AchievementManager this$0;

        public final ObservableList<Achievement> invoke() {
            return FXCollections.unmodifiableObservableList((ObservableList)AchievementManager.access$getAchievements$p(this.this$0));
        }
        {
            this.this$0 = achievementManager2;
            super(0);
        }
    }));

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(AchievementManager.class), "achievementsReadOnly", "getAchievementsReadOnly()Ljavafx/collections/ObservableList;"))};
    }

    private final ObservableList<Achievement> getAchievementsReadOnly() {
        Lazy lazy = this.achievementsReadOnly$delegate;
        AchievementManager achievementManager2 = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (ObservableList)lazy.getValue();
    }

    public final void registerAchievement(@NotNull Achievement a) {
        Object v0;
        block2: {
            Iterable iterable;
            Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
            Iterable iterable2 = iterable = (Iterable)this.achievements;
            for (Object t : iterable2) {
                Achievement it = (Achievement)t;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)a.getName())) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if (v0 != null) {
            throw (Throwable)new IllegalArgumentException("Achievement with name \"" + a.getName() + "\" exists");
        }
        this.achievements.add((Object)a);
        this.log.debug("Registered new achievement \"" + a.getName() + '\"');
    }

    @NotNull
    public final Achievement getAchievementByName(@NotNull String name) {
        Object v0;
        block2: {
            Iterable iterable;
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Iterable iterable2 = iterable = (Iterable)this.achievements;
            for (Object t : iterable2) {
                Achievement it = (Achievement)t;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        Achievement achievement = v0;
        if (achievement == null) {
            throw (Throwable)new IllegalArgumentException("Achievement with name \"" + name + "\" is not registered!");
        }
        return achievement;
    }

    @NotNull
    public final ObservableList<Achievement> getAchievements() {
        ObservableList<Achievement> observableList = this.getAchievementsReadOnly();
        Intrinsics.checkExpressionValueIsNotNull(observableList, (String)"achievementsReadOnly");
        return observableList;
    }

    public final void rebindAchievements$fxgl() {
        Iterable $receiver$iv = (Iterable)this.achievements;
        for (Object element$iv : $receiver$iv) {
            Ref.ObjectRef listener2;
            Achievement it = (Achievement)element$iv;
            Object object = it.getVarValue();
            if (object instanceof Integer) {
                Ref.ObjectRef objectRef = new Ref.ObjectRef();
                objectRef.element = null;
                listener2.element = new PropertyChangeListener<Integer>(it, listener2){
                    private boolean halfReached;
                    final /* synthetic */ Achievement $it;
                    final /* synthetic */ Ref.ObjectRef $listener;

                    public final boolean getHalfReached() {
                        return this.halfReached;
                    }

                    public final void setHalfReached(boolean bl) {
                        this.halfReached = bl;
                    }

                    public void onChange(int prev, int now) {
                        if (!this.halfReached && now >= ((Number)this.$it.getVarValue()).intValue() / 2) {
                            this.halfReached = true;
                            FXGL.Companion.getEventBus().fireEvent(new AchievementProgressEvent(this.$it, now, ((Number)this.$it.getVarValue()).intValue()));
                        }
                        if (Intrinsics.compare((int)now, (int)((Number)this.$it.getVarValue()).intValue()) >= 0) {
                            this.$it.setAchieved$fxgl();
                            FXGL.Companion.getEventBus().fireEvent(new AchievementEvent(AchievementEvent.ACHIEVED, this.$it));
                            GameState gameState = FXGL.Companion.getApp().getGameState();
                            String string = this.$it.getVarName();
                            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this.$listener.element;
                            if (propertyChangeListener == null) {
                                Intrinsics.throwNpe();
                            }
                            gameState.removeListener(string, propertyChangeListener);
                        }
                    }
                    {
                        this.$it = $captured_local_variable$0;
                        this.$listener = $captured_local_variable$1;
                    }
                };
                FXGL.Companion.getApp().getGameState().addListener(it.getVarName(), (PropertyChangeListener)listener2.element);
                continue;
            }
            if (object instanceof Double) {
                listener2 = new Ref.ObjectRef();
                listener2.element = null;
                listener2.element = new PropertyChangeListener<Double>(it, listener2){
                    private boolean halfReached;
                    final /* synthetic */ Achievement $it;
                    final /* synthetic */ Ref.ObjectRef $listener;

                    public final boolean getHalfReached() {
                        return this.halfReached;
                    }

                    public final void setHalfReached(boolean bl) {
                        this.halfReached = bl;
                    }

                    public void onChange(double prev, double now) {
                        if (!this.halfReached && now >= ((Number)this.$it.getVarValue()).doubleValue() / (double)2) {
                            this.halfReached = true;
                            FXGL.Companion.getEventBus().fireEvent(new AchievementProgressEvent(this.$it, now, ((Number)this.$it.getVarValue()).doubleValue()));
                        }
                        if (Double.compare(now, ((Number)this.$it.getVarValue()).doubleValue()) >= 0) {
                            this.$it.setAchieved$fxgl();
                            FXGL.Companion.getEventBus().fireEvent(new AchievementEvent(AchievementEvent.ACHIEVED, this.$it));
                            GameState gameState = FXGL.Companion.getApp().getGameState();
                            String string = this.$it.getVarName();
                            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this.$listener.element;
                            if (propertyChangeListener == null) {
                                Intrinsics.throwNpe();
                            }
                            gameState.removeListener(string, propertyChangeListener);
                        }
                    }
                    {
                        this.$it = $captured_local_variable$0;
                        this.$listener = $captured_local_variable$1;
                    }
                };
                FXGL.Companion.getApp().getGameState().addListener(it.getVarName(), (PropertyChangeListener)listener2.element);
                continue;
            }
            if (object instanceof Boolean) {
                listener2 = new Ref.ObjectRef();
                listener2.element = null;
                listener2.element = new PropertyChangeListener<Boolean>(it, listener2){
                    final /* synthetic */ Achievement $it;
                    final /* synthetic */ Ref.ObjectRef $listener;

                    public void onChange(boolean prev, boolean now) {
                        if (now) {
                            this.$it.setAchieved$fxgl();
                            FXGL.Companion.getEventBus().fireEvent(new AchievementEvent(AchievementEvent.ACHIEVED, this.$it));
                            GameState gameState = FXGL.Companion.getApp().getGameState();
                            String string = this.$it.getVarName();
                            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this.$listener.element;
                            if (propertyChangeListener == null) {
                                Intrinsics.throwNpe();
                            }
                            gameState.removeListener(string, propertyChangeListener);
                        }
                    }
                    {
                        this.$it = $captured_local_variable$0;
                        this.$listener = $captured_local_variable$1;
                    }
                };
                FXGL.Companion.getApp().getGameState().addListener(it.getVarName(), (PropertyChangeListener)listener2.element);
                continue;
            }
            throw (Throwable)new IllegalArgumentException("Unknown value type for achievement: " + it.getVarValue());
        }
    }

    @Override
    public void save(@NotNull UserProfile profile) {
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        this.log.debug("Saving data to profile");
        Bundle bundle = new Bundle("achievement");
        Iterable $receiver$iv = (Iterable)this.achievements;
        for (Object element$iv : $receiver$iv) {
            Achievement a = (Achievement)element$iv;
            bundle.put(a.getName(), Boolean.valueOf(a.isAchieved()));
        }
        bundle.log();
        profile.putBundle(bundle);
    }

    @Override
    public void load(@NotNull UserProfile profile) {
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        this.log.debug("Loading data from profile");
        Bundle bundle = profile.getBundle("achievement");
        bundle.log();
        Iterable $receiver$iv = (Iterable)this.achievements;
        for (Object element$iv : $receiver$iv) {
            Achievement a = (Achievement)element$iv;
            boolean achieved = (Boolean)bundle.get(a.getName());
            if (!achieved) continue;
            a.setAchieved$fxgl();
        }
    }

    public static final /* synthetic */ ObservableList access$getAchievements$p(AchievementManager $this) {
        return $this.achievements;
    }
}

