/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.gameplay;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.gameplay.ScoreData;
import com.almasb.fxgl.io.IOTask;
import com.almasb.fxgl.io.IOTaskKt;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0002J\u001a\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u00102\u0006\u0010\u0013\u001a\u00020\u0004J\u0016\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00102\u0006\u0010\u0016\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/almasb/fxgl/gameplay/Leaderboard;", "", "()V", "SUCCESS_CODE", "", "httpClient", "Lorg/apache/http/impl/client/CloseableHttpClient;", "kotlin.jvm.PlatformType", "listScoreClass", "Lcom/fasterxml/jackson/databind/JavaType;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "baseUrl", "", "gameName", "loadTopTask", "Lcom/almasb/fxgl/io/IOTask;", "", "Lcom/almasb/fxgl/gameplay/ScoreData;", "numItems", "postNewScoreTask", "Ljava/lang/Void;", "data", "fxgl"})
public final class Leaderboard {
    private final int SUCCESS_CODE = 200;
    private final CloseableHttpClient httpClient = HttpClientBuilder.create().build();
    private final ObjectMapper objectMapper = ExtensionsKt.registerKotlinModule((ObjectMapper)new ObjectMapper());
    private final JavaType listScoreClass;

    @NotNull
    public final IOTask<List<ScoreData>> loadTopTask(int numItems) {
        return IOTaskKt.taskOf("Load Top", (Function0)new Function0<List<? extends ScoreData>>(this, numItems){
            final /* synthetic */ Leaderboard this$0;
            final /* synthetic */ int $numItems;

            @NotNull
            public final List<ScoreData> invoke() {
                HttpGet getRequest = new HttpGet("" + Leaderboard.access$baseUrl(this.this$0) + "top?gameName=" + Leaderboard.access$gameName(this.this$0));
                getRequest.addHeader("accept", "application/json");
                CloseableHttpResponse response = Leaderboard.access$getHttpClient$p(this.this$0).execute((HttpUriRequest)getRequest);
                if (response.getStatusLine().getStatusCode() != Leaderboard.access$getSUCCESS_CODE$p(this.this$0)) {
                    throw (Throwable)new RuntimeException("HTTP error code: " + response.getStatusLine().getStatusCode());
                }
                Iterable $receiver$iv = (Iterable)Leaderboard.access$getObjectMapper$p(this.this$0).readValue(response.getEntity().getContent(), Leaderboard.access$getListScoreClass$p(this.this$0));
                Iterable iterable = $receiver$iv;
                Comparator comparator = new Comparator<T>(){

                    public final int compare(T a, T b) {
                        ScoreData it = (ScoreData)b;
                        Comparable comparable = Integer.valueOf(it.getScore());
                        it = (ScoreData)a;
                        Comparable comparable2 = comparable;
                        Integer n = it.getScore();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                    }
                };
                return CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator), (int)this.$numItems);
            }
            {
                this.this$0 = leaderboard2;
                this.$numItems = n;
                super(0);
            }
        });
    }

    @NotNull
    public final IOTask<Void> postNewScoreTask(@NotNull ScoreData data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return IOTaskKt.voidTaskOf("Put New Score", (Function0)new Function0<Unit>(this, data){
            final /* synthetic */ Leaderboard this$0;
            final /* synthetic */ ScoreData $data;

            public final void invoke() {
                HttpPut putRequest = new HttpPut("" + Leaderboard.access$baseUrl(this.this$0) + "newscore?gameName=" + Leaderboard.access$gameName(this.this$0) + "&name=" + this.$data.getName() + "&score=" + this.$data.getScore());
                putRequest.addHeader("accept", "application/json");
                CloseableHttpResponse response = Leaderboard.access$getHttpClient$p(this.this$0).execute((HttpUriRequest)putRequest);
                if (response.getStatusLine().getStatusCode() != Leaderboard.access$getSUCCESS_CODE$p(this.this$0)) {
                    throw (Throwable)new RuntimeException("HTTP error code: " + response.getStatusLine().getStatusCode());
                }
            }
            {
                this.this$0 = leaderboard2;
                this.$data = scoreData;
                super(0);
            }
        });
    }

    private final String baseUrl() {
        return FXGL.Companion.getString("url.leaderboard");
    }

    private final String gameName() {
        return StringsKt.replace$default((String)FXGL.Companion.getSettings().getTitle(), (char)' ', (char)'_', (boolean)false, (int)4, null);
    }

    public Leaderboard() {
        CollectionType collectionType = this.objectMapper.getTypeFactory().constructCollectionType(List.class, ScoreData.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)collectionType, (String)"objectMapper.typeFactory\u2026a, ScoreData::class.java)");
        this.listScoreClass = (JavaType)collectionType;
    }

    @NotNull
    public static final /* synthetic */ String access$baseUrl(Leaderboard $this) {
        return $this.baseUrl();
    }

    @NotNull
    public static final /* synthetic */ String access$gameName(Leaderboard $this) {
        return $this.gameName();
    }

    public static final /* synthetic */ CloseableHttpClient access$getHttpClient$p(Leaderboard $this) {
        return $this.httpClient;
    }

    public static final /* synthetic */ int access$getSUCCESS_CODE$p(Leaderboard $this) {
        return $this.SUCCESS_CODE;
    }

    @NotNull
    public static final /* synthetic */ ObjectMapper access$getObjectMapper$p(Leaderboard $this) {
        return $this.objectMapper;
    }

    @NotNull
    public static final /* synthetic */ JavaType access$getListScoreClass$p(Leaderboard $this) {
        return $this.listScoreClass;
    }
}

