/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.gameplay.notification;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.gameplay.notification.Notification;
import com.almasb.fxgl.gameplay.notification.NotificationEvent;
import com.almasb.fxgl.gameplay.notification.NotificationService;
import com.almasb.fxgl.gameplay.notification.NotificationServiceProvider;
import com.almasb.fxgl.gameplay.notification.NotificationView;
import com.almasb.fxgl.scene.GameScene;
import com.almasb.fxgl.time.Timer;
import com.almasb.fxgl.ui.Position;
import java.util.ArrayDeque;
import java.util.Collection;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.util.Duration;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J\u0010\u0010\u001b\u001a\n \u0005*\u0004\u0018\u00010\u001c0\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001cH\u0016J\b\u0010 \u001a\u00020\u0018H\u0002J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u001cH\u0016J\u0010\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u001eH\u0016J\u0010\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\u001cH\u0016J\b\u0010*\u001a\u00020\u0018H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0007\u001a\n \u0005*\u0004\u0018\u00010\b0\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR#\u0010\r\u001a\n \u0005*\u0004\u0018\u00010\u000e0\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\f\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/almasb/fxgl/gameplay/notification/NotificationServiceProvider;", "Lcom/almasb/fxgl/gameplay/notification/NotificationService;", "()V", "ANIMATION_DURATION", "Ljavafx/util/Duration;", "kotlin.jvm.PlatformType", "NOTIFICATION_DURATION", "gameScene", "Lcom/almasb/fxgl/scene/GameScene;", "getGameScene", "()Lcom/almasb/fxgl/scene/GameScene;", "gameScene$delegate", "Lkotlin/Lazy;", "notificationView", "Lcom/almasb/fxgl/gameplay/notification/NotificationView;", "getNotificationView", "()Lcom/almasb/fxgl/gameplay/notification/NotificationView;", "notificationView$delegate", "queue", "Ljava/util/ArrayDeque;", "Lcom/almasb/fxgl/gameplay/notification/Notification;", "showing", "", "checkLastPop", "", "fireAndScheduleNextNotification", "notification", "getBackgroundColor", "Ljavafx/scene/paint/Color;", "getPosition", "Lcom/almasb/fxgl/ui/Position;", "getTextColor", "nextNotification", "pushNotification", "text", "", "setBackgroundColor", "backgroundColor", "setPosition", "position", "setTextColor", "textColor", "showFirstNotification", "fxgl"})
public final class NotificationServiceProvider
implements NotificationService {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Duration ANIMATION_DURATION = Duration.seconds((double)1.0);
    private final Duration NOTIFICATION_DURATION = Duration.seconds((double)3.0);
    private final Lazy gameScene$delegate = LazyKt.lazy((Function0)gameScene.2.INSTANCE);
    private final Lazy notificationView$delegate = LazyKt.lazy((Function0)notificationView.2.INSTANCE);
    private final ArrayDeque<Notification> queue = new ArrayDeque();
    private boolean showing;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(NotificationServiceProvider.class), "gameScene", "getGameScene()Lcom/almasb/fxgl/scene/GameScene;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(NotificationServiceProvider.class), "notificationView", "getNotificationView()Lcom/almasb/fxgl/gameplay/notification/NotificationView;"))};
    }

    private final GameScene getGameScene() {
        Lazy lazy = this.gameScene$delegate;
        NotificationServiceProvider notificationServiceProvider = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (GameScene)lazy.getValue();
    }

    private final NotificationView getNotificationView() {
        Lazy lazy = this.notificationView$delegate;
        NotificationServiceProvider notificationServiceProvider = this;
        KProperty kProperty = $$delegatedProperties[1];
        return (NotificationView)((Object)lazy.getValue());
    }

    @Override
    @NotNull
    public Position getPosition() {
        return this.getNotificationView().getPosition();
    }

    @Override
    public void setPosition(@NotNull Position position2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)position2), (String)"position");
        this.getNotificationView().setPosition(position2);
    }

    @Override
    public Color getBackgroundColor() {
        return this.getNotificationView().getBackgroundColor();
    }

    @Override
    public void setBackgroundColor(@NotNull Color backgroundColor) {
        Intrinsics.checkParameterIsNotNull((Object)backgroundColor, (String)"backgroundColor");
        this.getNotificationView().setBackgroundColor(backgroundColor);
    }

    @Override
    @NotNull
    public Color getTextColor() {
        Color color = this.getNotificationView().getTextColor();
        Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"notificationView.textColor");
        return color;
    }

    @Override
    public void setTextColor(@NotNull Color textColor) {
        Intrinsics.checkParameterIsNotNull((Object)textColor, (String)"textColor");
        this.getNotificationView().setTextColor(textColor);
    }

    @Override
    public void pushNotification(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Notification notification = new Notification(text);
        if (this.showing) {
            this.queue.add(notification);
        } else {
            this.showFirstNotification();
            this.queue.add(notification);
        }
    }

    private final void nextNotification() {
        Collection collection = this.queue;
        if (!collection.isEmpty()) {
            Notification n = this.queue.poll();
            NotificationView notificationView2 = this.getNotificationView();
            Notification notification = n;
            Intrinsics.checkExpressionValueIsNotNull((Object)notification, (String)"n");
            notificationView2.push(notification);
            this.fireAndScheduleNextNotification(n);
        } else {
            this.getNotificationView().playOutAnimation();
            Timer timer2 = FXGL.Companion.getMasterTimer();
            Runnable runnable = new Runnable(this){
                final /* synthetic */ NotificationServiceProvider this$0;

                public final void run() {
                    NotificationServiceProvider.access$checkLastPop(this.this$0);
                }
                {
                    this.this$0 = notificationServiceProvider;
                }
            };
            Duration duration = this.ANIMATION_DURATION;
            Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"ANIMATION_DURATION");
            timer2.runOnceAfter(runnable, duration);
        }
    }

    private final void checkLastPop() {
        if (this.queue.isEmpty()) {
            this.getGameScene().removeUINode((Node)this.getNotificationView());
            this.showing = false;
        } else {
            this.getNotificationView().playInAnimation();
            Timer timer2 = FXGL.Companion.getMasterTimer();
            Runnable runnable = new Runnable(this){
                final /* synthetic */ NotificationServiceProvider this$0;

                public final void run() {
                    NotificationServiceProvider.access$nextNotification(this.this$0);
                }
                {
                    this.this$0 = notificationServiceProvider;
                }
            };
            Duration duration = this.ANIMATION_DURATION;
            Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"ANIMATION_DURATION");
            timer2.runOnceAfter(runnable, duration);
        }
    }

    private final void showFirstNotification() {
        this.showing = true;
        this.getGameScene().addUINode((Node)this.getNotificationView());
        this.getNotificationView().playInAnimation();
        Timer timer2 = FXGL.Companion.getMasterTimer();
        Runnable runnable = new Runnable(this){
            final /* synthetic */ NotificationServiceProvider this$0;

            public final void run() {
                NotificationServiceProvider.access$nextNotification(this.this$0);
            }
            {
                this.this$0 = notificationServiceProvider;
            }
        };
        Duration duration = this.ANIMATION_DURATION;
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"ANIMATION_DURATION");
        timer2.runOnceAfter(runnable, duration);
    }

    private final void fireAndScheduleNextNotification(Notification notification) {
        FXGL.Companion.getEventBus().fireEvent(new NotificationEvent(notification));
        Timer timer2 = FXGL.Companion.getMasterTimer();
        Runnable runnable = new Runnable(this){
            final /* synthetic */ NotificationServiceProvider this$0;

            public final void run() {
                NotificationServiceProvider.access$nextNotification(this.this$0);
            }
            {
                this.this$0 = notificationServiceProvider;
            }
        };
        Duration duration = this.NOTIFICATION_DURATION;
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"NOTIFICATION_DURATION");
        timer2.runOnceAfter(runnable, duration);
    }

    public static final /* synthetic */ void access$checkLastPop(NotificationServiceProvider $this) {
        $this.checkLastPop();
    }

    public static final /* synthetic */ void access$nextNotification(NotificationServiceProvider $this) {
        $this.nextNotification();
    }
}

