/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.parser;

import com.almasb.fxgl.core.logging.Logger;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.util.Pair;

public final class KVFile {
    private static final Logger log = Logger.get("FXGL.KVFile");
    private List<Pair<String, String>> entries = new ArrayList<Pair<String, String>>();
    private Predicate<String[]> validEntry = kv -> {
        boolean valid = true;
        if (((String[])kv).length != 2) {
            log.warning("Syntax error: " + Arrays.toString(kv));
            valid = false;
        }
        return valid;
    };

    public KVFile(List<String> fileLines) {
        this.entries = fileLines.stream().map(s -> s.split("=", 2)).filter(this.validEntry).map(kv -> new Pair((Object)kv[0].trim(), (Object)kv[1].trim())).collect(Collectors.toList());
    }

    private KVFile() {
    }

    private void setKV(Object instance, String key, String value) throws Exception {
        Field field = instance.getClass().getDeclaredField(key);
        field.setAccessible(true);
        switch (field.getType().getSimpleName()) {
            case "int": {
                field.setInt(instance, Integer.parseInt(value));
                break;
            }
            case "short": {
                field.setShort(instance, Short.parseShort(value));
                break;
            }
            case "long": {
                field.setLong(instance, Long.parseLong(value));
                break;
            }
            case "byte": {
                field.setByte(instance, Byte.parseByte(value));
                break;
            }
            case "double": {
                field.setDouble(instance, Double.parseDouble(value));
                break;
            }
            case "float": {
                field.setFloat(instance, Float.parseFloat(value));
                break;
            }
            case "boolean": {
                field.setBoolean(instance, Boolean.parseBoolean(value));
                break;
            }
            case "char": {
                field.setChar(instance, value.length() > 0 ? value.charAt(0) : (char)' ');
                break;
            }
            case "String": {
                field.set(instance, value);
                break;
            }
            default: {
                log.warning("Unknown field type: " + field.getType().getSimpleName());
                log.warning("Only primitive data types and String are supported!");
            }
        }
    }

    public static KVFile from(Object data) {
        try {
            KVFile file = new KVFile();
            for (Field f : data.getClass().getDeclaredFields()) {
                f.setAccessible(true);
                file.entries.add((Pair<String, String>)new Pair((Object)f.getName(), (Object)f.get(data).toString()));
            }
            return file;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot create KVFile from: " + data + " Error: " + e);
        }
    }

    public <T> T to(Class<T> type) {
        try {
            T instance = type.newInstance();
            for (Pair<String, String> kv : this.entries) {
                this.setKV(instance, (String)kv.getKey(), (String)kv.getValue());
            }
            return instance;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot parse KVFile to: " + type + " Error: " + e);
        }
    }

    public String toString() {
        return "KVFile [entries=" + this.entries.toString() + "]";
    }
}

