/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics.box2d.dynamics;

import com.almasb.fxgl.physics.box2d.common.JBoxUtils;
import java.util.List;

public class Profile {
    private static final int LONG_AVG_NUMS = 20;
    private static final float LONG_FRACTION = 0.05f;
    private static final int SHORT_AVG_NUMS = 5;
    private static final float SHORT_FRACTION = 0.2f;
    public final ProfileEntry step = new ProfileEntry();
    public final ProfileEntry stepInit = new ProfileEntry();
    public final ProfileEntry collide = new ProfileEntry();
    public final ProfileEntry solveParticleSystem = new ProfileEntry();
    public final ProfileEntry solve = new ProfileEntry();
    public final ProfileEntry solveInit = new ProfileEntry();
    public final ProfileEntry solveVelocity = new ProfileEntry();
    public final ProfileEntry solvePosition = new ProfileEntry();
    public final ProfileEntry broadphase = new ProfileEntry();
    public final ProfileEntry solveTOI = new ProfileEntry();

    public void toDebugStrings(List<String> strings) {
        strings.add("Profile:");
        strings.add(" step: " + this.step);
        strings.add("  init: " + this.stepInit);
        strings.add("  collide: " + this.collide);
        strings.add("  particles: " + this.solveParticleSystem);
        strings.add("  solve: " + this.solve);
        strings.add("   solveInit: " + this.solveInit);
        strings.add("   solveVelocity: " + this.solveVelocity);
        strings.add("   solvePosition: " + this.solvePosition);
        strings.add("   broadphase: " + this.broadphase);
        strings.add("  solveTOI: " + this.solveTOI);
    }

    public static class ProfileEntry {
        float longAvg;
        float shortAvg;
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        float accum;

        public void record(float value) {
            this.longAvg = this.longAvg * 0.95f + value * 0.05f;
            this.shortAvg = this.shortAvg * 0.8f + value * 0.2f;
            this.min = JBoxUtils.min(value, this.min);
            this.max = JBoxUtils.max(value, this.max);
        }

        public void startAccum() {
            this.accum = 0.0f;
        }

        public void accum(float value) {
            this.accum += value;
        }

        public void endAccum() {
            this.record(this.accum);
        }

        public String toString() {
            return String.format("%.2f (%.2f) [%.2f,%.2f]", Float.valueOf(this.shortAvg), Float.valueOf(this.longAvg), Float.valueOf(this.min), Float.valueOf(this.max));
        }
    }
}

