/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.settings;

import com.almasb.fxgl.app.ApplicationMode;
import com.almasb.fxgl.app.ExceptionHandler;
import com.almasb.fxgl.app.FXGLExceptionHandler;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.gameplay.notification.NotificationView;
import com.almasb.fxgl.gameplay.notification.XboxNotificationView;
import com.almasb.fxgl.scene.SceneFactory;
import com.almasb.fxgl.settings.MenuItem;
import com.almasb.fxgl.ui.DialogFactory;
import com.almasb.fxgl.ui.FXGLDialogFactory;
import com.almasb.fxgl.ui.FXGLUIFactory;
import com.almasb.fxgl.ui.UIFactory;
import com.almasb.fxgl.util.Credits;
import java.util.Collections;
import java.util.EnumSet;
import javafx.scene.input.KeyCode;
import javafx.stage.StageStyle;

public class ReadOnlyGameSettings {
    protected String title = "Untitled";
    protected String version = "0.0";
    protected int width = 800;
    protected int height = 600;
    protected boolean fullScreen = false;
    protected boolean introEnabled = false;
    protected boolean menuEnabled = false;
    protected boolean profilingEnabled = false;
    protected boolean closeConfirmation = false;
    protected boolean singleStep = false;
    protected ApplicationMode appMode = ApplicationMode.DEVELOPER;
    protected KeyCode menuKey = KeyCode.ESCAPE;
    protected Credits credits = new Credits(Collections.emptyList());
    protected EnumSet<MenuItem> enabledMenuItems = EnumSet.noneOf(MenuItem.class);
    protected StageStyle stageStyle = StageStyle.DECORATED;
    protected SceneFactory sceneFactory = new SceneFactory();
    protected DialogFactory dialogFactory = new FXGLDialogFactory();
    protected UIFactory uiFactory = new FXGLUIFactory();
    protected Class<? extends NotificationView> notificationViewClass = XboxNotificationView.class;
    protected ExceptionHandler exceptionHandler = new FXGLExceptionHandler();
    private ExceptionHandler exceptionHandlerWrapper = new ExceptionHandler(){
        private Logger log = Logger.get("ExceptionHandler");

        @Override
        public void handle(Throwable e) {
            this.log.warning("Caught Exception: " + e);
            this.log.warning(Logger.errorTraceAsString(e));
            ReadOnlyGameSettings.this.exceptionHandler.handle(e);
        }
    };

    ReadOnlyGameSettings() {
    }

    ReadOnlyGameSettings(ReadOnlyGameSettings copy) {
        this.title = copy.title;
        this.version = copy.version;
        this.width = copy.width;
        this.height = copy.height;
        this.fullScreen = copy.fullScreen;
        this.introEnabled = copy.introEnabled;
        this.menuEnabled = copy.menuEnabled;
        this.profilingEnabled = copy.profilingEnabled;
        this.closeConfirmation = copy.closeConfirmation;
        this.appMode = copy.appMode;
        this.menuKey = copy.menuKey;
        this.credits = new Credits(copy.credits);
        this.enabledMenuItems = copy.enabledMenuItems;
        this.singleStep = copy.singleStep;
        this.stageStyle = copy.stageStyle;
        this.sceneFactory = copy.sceneFactory;
        this.dialogFactory = copy.dialogFactory;
        this.uiFactory = copy.uiFactory;
        this.notificationViewClass = copy.notificationViewClass;
        this.exceptionHandler = copy.exceptionHandler;
        this.exceptionHandlerWrapper = copy.exceptionHandlerWrapper;
    }

    public final String getTitle() {
        return this.title;
    }

    public final String getVersion() {
        return this.version;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final boolean isFullScreen() {
        return this.fullScreen;
    }

    public final boolean isIntroEnabled() {
        return this.introEnabled;
    }

    public final boolean isMenuEnabled() {
        return this.menuEnabled;
    }

    public final boolean isProfilingEnabled() {
        return this.profilingEnabled;
    }

    public boolean isSingleStep() {
        return this.singleStep;
    }

    public final boolean isCloseConfirmation() {
        return this.closeConfirmation;
    }

    public final ApplicationMode getApplicationMode() {
        return this.appMode;
    }

    public final KeyCode getMenuKey() {
        return this.menuKey;
    }

    public final Credits getCredits() {
        return this.credits;
    }

    public final EnumSet<MenuItem> getEnabledMenuItems() {
        return this.enabledMenuItems;
    }

    public final StageStyle getStageStyle() {
        return this.stageStyle;
    }

    public final SceneFactory getSceneFactory() {
        return this.sceneFactory;
    }

    public final DialogFactory getDialogFactory() {
        return this.dialogFactory;
    }

    public final UIFactory getUIFactory() {
        return this.uiFactory;
    }

    public final Class<? extends NotificationView> getNotificationViewFactory() {
        return this.notificationViewClass;
    }

    public final ExceptionHandler getExceptionHandler() {
        return this.exceptionHandlerWrapper;
    }

    public String toString() {
        return "Title: " + this.title + '\n' + "Version: " + this.version + '\n' + "Width: " + this.width + '\n' + "Height: " + this.height + '\n' + "Fullscreen: " + this.fullScreen + '\n' + "Intro: " + this.introEnabled + '\n' + "Menus: " + this.menuEnabled + '\n' + "Profiling: " + this.profilingEnabled + '\n' + "Single step:" + this.singleStep + '\n' + "App Mode: " + (Object)((Object)this.appMode) + '\n' + "Menu Key: " + this.menuKey + '\n' + "Stage Style: " + this.stageStyle + '\n' + "Scene Factory: " + this.sceneFactory.getClass() + '\n' + "Dialog Factory: " + this.dialogFactory.getClass() + '\n' + "UI Factory: " + this.uiFactory.getClass() + '\n' + "Notification Service: " + this.notificationViewClass + '\n' + "Exception Handler: " + this.exceptionHandler.getClass();
    }
}

