/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.texture;

import com.almasb.fxgl.app.FXGL;
import java.util.ArrayList;
import java.util.Collection;
import javafx.scene.image.Image;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B?\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fB=\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R$\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u001bj\b\u0012\u0004\u0012\u00020\u0005`\u001cX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lcom/almasb/fxgl/texture/AnimationChannel;", "", "assetName", "", "framesPerRow", "", "frameWidth", "frameHeight", "channelDuration", "Ljavafx/util/Duration;", "startFrame", "endFrame", "(Ljava/lang/String;IIILjavafx/util/Duration;II)V", "image", "Ljavafx/scene/image/Image;", "(Ljavafx/scene/image/Image;IIILjavafx/util/Duration;II)V", "frameDuration", "", "getFrameDuration$fxgl", "()D", "getFrameHeight", "()I", "getFrameWidth", "getFramesPerRow", "getImage", "()Ljavafx/scene/image/Image;", "sequence", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getSequence$fxgl", "()Ljava/util/ArrayList;", "fxgl"})
public final class AnimationChannel {
    @NotNull
    private final ArrayList<Integer> sequence;
    private final double frameDuration;
    @NotNull
    private final Image image;
    private final int framesPerRow;
    private final int frameWidth;
    private final int frameHeight;

    @NotNull
    public final ArrayList<Integer> getSequence$fxgl() {
        return this.sequence;
    }

    public final double getFrameDuration$fxgl() {
        return this.frameDuration;
    }

    @NotNull
    public final Image getImage() {
        return this.image;
    }

    public final int getFramesPerRow() {
        return this.framesPerRow;
    }

    public final int getFrameWidth() {
        return this.frameWidth;
    }

    public final int getFrameHeight() {
        return this.frameHeight;
    }

    public AnimationChannel(@NotNull Image image, int framesPerRow, int frameWidth, int frameHeight, @NotNull Duration channelDuration, int startFrame, int endFrame) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        Intrinsics.checkParameterIsNotNull((Object)channelDuration, (String)"channelDuration");
        this.image = image;
        this.framesPerRow = framesPerRow;
        this.frameWidth = frameWidth;
        this.frameHeight = frameHeight;
        AnimationChannel animationChannel = this;
        ArrayList arrayList = new ArrayList();
        animationChannel.sequence = arrayList;
        Collection collection = this.sequence;
        int n = startFrame;
        Iterable iterable = (Iterable)new IntRange(n, endFrame);
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        this.frameDuration = channelDuration.toSeconds() / (double)this.sequence.size();
    }

    public AnimationChannel(@NotNull String assetName, int framesPerRow, int frameWidth, int frameHeight, @NotNull Duration channelDuration, int startFrame, int endFrame) {
        Intrinsics.checkParameterIsNotNull((Object)assetName, (String)"assetName");
        Intrinsics.checkParameterIsNotNull((Object)channelDuration, (String)"channelDuration");
        Image image = FXGL.Companion.getAssetLoader().loadTexture(assetName).getImage();
        Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"FXGL.getAssetLoader().loadTexture(assetName).image");
        this(image, framesPerRow, frameWidth, frameHeight, channelDuration, startFrame, endFrame);
    }
}

