/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.time;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.io.serialization.Bundle;
import com.almasb.fxgl.time.LocalTimer;
import java.time.LocalDateTime;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/almasb/fxgl/time/OfflineTimer;", "Lcom/almasb/fxgl/time/LocalTimer;", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "capture", "", "elapsed", "", "duration", "Ljavafx/util/Duration;", "fxgl"})
public final class OfflineTimer
implements LocalTimer {
    @NotNull
    private final String name;

    @Override
    public void capture() {
        Bundle bundle = FXGL.Companion.getSystemBundle();
        String string = "offline.timer." + this.name;
        LocalDateTime localDateTime = LocalDateTime.now();
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"LocalDateTime.now()");
        bundle.put(string, localDateTime);
    }

    @Override
    public boolean elapsed(@NotNull Duration duration) {
        Intrinsics.checkParameterIsNotNull((Object)duration, (String)"duration");
        LocalDateTime dateTime = (LocalDateTime)FXGL.Companion.getSystemBundle().get("offline.timer." + this.name);
        if (dateTime == null) {
            this.capture();
            return true;
        }
        return LocalDateTime.now().minusSeconds((long)duration.toSeconds()).isAfter(dateTime);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public OfflineTimer(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.name = name;
    }
}

