/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.ui;

import com.almasb.fxgl.animation.AnimatedPoint2D;
import com.almasb.fxgl.animation.AnimatedValue;
import com.almasb.fxgl.animation.Animation;
import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.util.EmptyRunnable;
import javafx.beans.binding.StringExpression;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ListView;
import javafx.scene.control.Spinner;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.util.Duration;

public interface UIFactory {
    public Font newFont(double var1);

    default public Text newText(String message2) {
        return this.newText(message2, Color.WHITE, 18.0);
    }

    default public Text newText(String message2, double fontSize) {
        return this.newText(message2, Color.WHITE, fontSize);
    }

    default public Text newText(String message2, Color textColor, double fontSize) {
        Text text = new Text(message2);
        text.setFill((Paint)textColor);
        text.setFont(this.newFont(fontSize));
        return text;
    }

    default public Text newText(StringExpression textBinding) {
        Text text = this.newText((String)textBinding.get());
        text.textProperty().bind((ObservableValue)textBinding);
        return text;
    }

    default public void centerTextX(Text text, double minX, double maxX) {
        text.setTranslateX((minX + maxX) / 2.0 - text.getLayoutBounds().getWidth() / 2.0);
    }

    default public void centerTextY(Text text, double minY, double maxY) {
        text.setTranslateY((minY + maxY) / 2.0 - text.getLayoutBounds().getHeight() / 2.0);
    }

    default public void centerText(Text text) {
        this.centerText(text, FXGL.getAppWidth() / 2, FXGL.getAppHeight() / 2);
    }

    default public void centerText(Text text, double x, double y) {
        text.setTranslateX(x - text.getLayoutBounds().getWidth() / 2.0);
        text.setTranslateY(y - text.getLayoutBounds().getHeight() / 2.0);
    }

    default public void centerTextBind(Text text) {
        this.centerTextBind(text, FXGL.getAppWidth() / 2, FXGL.getAppHeight() / 2);
    }

    default public void centerTextBind(Text text, double x, double y) {
        text.layoutBoundsProperty().addListener((o, old, bounds) -> {
            text.setTranslateX(x - bounds.getWidth() / 2.0);
            text.setTranslateY(y - bounds.getHeight() / 2.0);
        });
    }

    public Button newButton(String var1);

    public <T> ChoiceBox<T> newChoiceBox(ObservableList<T> var1);

    public <T> ChoiceBox<T> newChoiceBox();

    public CheckBox newCheckBox();

    public <T> Spinner<T> newSpinner(ObservableList<T> var1);

    public <T> ListView<T> newListView(ObservableList<T> var1);

    public <T> ListView<T> newListView();

    default public Animation<?> translate(Node node, Point2D to, Duration duration) {
        return this.translate(node, new Point2D(node.getTranslateX(), node.getTranslateY()), to, Duration.ZERO, duration);
    }

    default public Animation<?> translate(Node node, Point2D from, Point2D to, Duration duration) {
        return this.translate(node, from, to, Duration.ZERO, duration);
    }

    default public Animation<?> translate(Node node, Point2D from, Point2D to, Duration delay, Duration duration) {
        return this.translate(node, from, to, delay, duration, EmptyRunnable.INSTANCE);
    }

    default public Animation<?> translate(final Node node, Point2D from, Point2D to, Duration delay, Duration duration, Runnable onFinishedAction) {
        Animation<Point2D> anim = new Animation<Point2D>(delay, duration, 1, (AnimatedValue)new AnimatedPoint2D(from, to)){

            @Override
            public void onProgress(Point2D value) {
                node.setTranslateX(value.getX());
                node.setTranslateY(value.getY());
            }
        };
        anim.setOnFinished(onFinishedAction);
        return anim;
    }

    default public Animation<?> fadeIn(Node node, Duration duration) {
        return this.fadeIn(node, duration, EmptyRunnable.INSTANCE);
    }

    default public Animation<?> fadeIn(Node node, Duration duration, Runnable onFinishedAction) {
        return this.fadeIn(node, Duration.ZERO, duration, onFinishedAction);
    }

    default public Animation<?> fadeIn(Node node, Duration delay, Duration duration) {
        return this.fadeIn(node, delay, duration, EmptyRunnable.INSTANCE);
    }

    default public Animation<?> fadeIn(final Node node, Duration delay, Duration duration, Runnable onFinishedAction) {
        Animation<Double> anim = new Animation<Double>(delay, duration, 1, new AnimatedValue<Double>(0.0, 1.0)){

            @Override
            public void onProgress(Double value) {
                node.setOpacity(value.doubleValue());
            }
        };
        anim.setOnFinished(onFinishedAction);
        return anim;
    }

    default public Animation<?> fadeOut(Node node, Duration duration) {
        return this.fadeOut(node, duration, EmptyRunnable.INSTANCE);
    }

    default public Animation<?> fadeOut(Node node, Duration duration, Runnable onFinishedAction) {
        return this.fadeOut(node, Duration.ZERO, duration, onFinishedAction);
    }

    default public Animation<?> fadeOut(Node node, Duration delay, Duration duration) {
        return this.fadeOut(node, delay, duration, EmptyRunnable.INSTANCE);
    }

    default public Animation<?> fadeOut(Node node, Duration delay, Duration duration, Runnable onFinishedAction) {
        Animation<?> anim = this.fadeIn(node, delay, duration, onFinishedAction);
        anim.setReverse(true);
        return anim;
    }

    default public Animation<?> fadeInOut(Node node, Duration duration) {
        return this.fadeInOut(node, duration, EmptyRunnable.INSTANCE);
    }

    default public Animation<?> fadeInOut(Node node, Duration duration, Runnable onFinishedAction) {
        return this.fadeInOut(node, Duration.ZERO, duration, onFinishedAction);
    }

    default public Animation<?> fadeInOut(Node node, Duration delay, Duration duration) {
        return this.fadeInOut(node, delay, duration, EmptyRunnable.INSTANCE);
    }

    default public Animation<?> fadeInOut(Node node, Duration delay, Duration duration, Runnable onFinishedAction) {
        Animation<?> anim = this.fadeIn(node, delay, duration, onFinishedAction);
        anim.setCycleCount(2);
        anim.setAutoReverse(true);
        return anim;
    }

    default public Animation<?> fadeOutIn(Node node, Duration duration) {
        return this.fadeOutIn(node, duration, EmptyRunnable.INSTANCE);
    }

    default public Animation<?> fadeOutIn(Node node, Duration duration, Runnable onFinishedAction) {
        return this.fadeOutIn(node, Duration.ZERO, duration, onFinishedAction);
    }

    default public Animation<?> fadeOutIn(Node node, Duration delay, Duration duration) {
        return this.fadeOutIn(node, delay, duration, EmptyRunnable.INSTANCE);
    }

    default public Animation<?> fadeOutIn(Node node, Duration delay, Duration duration, Runnable onFinishedAction) {
        Animation<?> anim = this.fadeInOut(node, delay, duration, onFinishedAction);
        anim.setReverse(true);
        return anim;
    }

    default public Animation<?> scale(Node node, Point2D to, Duration duration) {
        return this.scale(node, new Point2D(node.getScaleX(), node.getScaleY()), to, Duration.ZERO, duration);
    }

    default public Animation<?> scale(Node node, Point2D from, Point2D to, Duration duration) {
        return this.scale(node, from, to, Duration.ZERO, duration);
    }

    default public Animation<?> scale(Node node, Point2D from, Point2D to, Duration delay, Duration duration) {
        return this.scale(node, from, to, delay, duration, EmptyRunnable.INSTANCE);
    }

    default public Animation<?> scale(final Node node, Point2D from, Point2D to, Duration delay, Duration duration, Runnable onFinishedAction) {
        Animation<Point2D> anim = new Animation<Point2D>(delay, duration, 1, (AnimatedValue)new AnimatedPoint2D(from, to)){

            @Override
            public void onProgress(Point2D value) {
                node.setScaleX(value.getX());
                node.setScaleY(value.getY());
            }
        };
        anim.setOnFinished(onFinishedAction);
        return anim;
    }

    default public Animation<?> rotate(Node node, double to, Duration duration) {
        return this.rotate(node, node.getRotate(), to, Duration.ZERO, duration);
    }

    default public Animation<?> rotate(Node node, double from, double to, Duration duration) {
        return this.rotate(node, from, to, Duration.ZERO, duration);
    }

    default public Animation<?> rotate(Node node, double from, double to, Duration delay, Duration duration) {
        return this.rotate(node, from, to, delay, duration, EmptyRunnable.INSTANCE);
    }

    default public Animation<?> rotate(final Node node, double from, double to, Duration delay, Duration duration, Runnable onFinishedAction) {
        Animation<Double> anim = new Animation<Double>(delay, duration, 1, new AnimatedValue<Double>(from, to)){

            @Override
            public void onProgress(Double value) {
                node.setRotate(value.doubleValue());
            }
        };
        anim.setOnFinished(onFinishedAction);
        return anim;
    }
}

