/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.ai;

import com.almasb.fxgl.ai.AIBubble;
import com.almasb.fxgl.ai.btree.BehaviorTree;
import com.almasb.fxgl.ai.btree.Task;
import com.almasb.fxgl.app.ApplicationMode;
import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.entity.Control;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.component.ViewComponent;
import com.almasb.fxgl.settings.ReadOnlyGameSettings;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.Node;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0015\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J\u0018\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0007R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/almasb/fxgl/ai/AIControl;", "Lcom/almasb/fxgl/entity/Control;", "behaviorTree", "Lcom/almasb/fxgl/ai/btree/BehaviorTree;", "Lcom/almasb/fxgl/entity/Entity;", "(Lcom/almasb/fxgl/ai/btree/BehaviorTree;)V", "treeName", "", "(Ljava/lang/String;)V", "()V", "bubble", "Lcom/almasb/fxgl/ai/AIBubble;", "getBubble", "()Lcom/almasb/fxgl/ai/AIBubble;", "onAdded", "", "entity", "onUpdate", "tpf", "", "setBubbleMessage", "message", "Companion", "fxgl"})
public final class AIControl
extends Control {
    private BehaviorTree<Entity> behaviorTree;
    @NotNull
    private final AIBubble bubble;
    private static final HashMap<String, BehaviorTree<Entity>> parsedTreesCache;
    public static final Companion Companion;

    @NotNull
    public final AIBubble getBubble() {
        return this.bubble;
    }

    public final void setBubbleMessage(@NotNull String message2) {
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        this.bubble.setMessage(message2);
    }

    @Override
    public void onAdded(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        BehaviorTree<Entity> behaviorTree = this.behaviorTree;
        if (behaviorTree == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"behaviorTree");
        }
        behaviorTree.setEntity(entity);
        ReadOnlyGameSettings readOnlyGameSettings = FXGL.Companion.getSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)readOnlyGameSettings, (String)"FXGL.getSettings()");
        if (Intrinsics.areEqual((Object)((Object)readOnlyGameSettings.getApplicationMode()), (Object)((Object)ApplicationMode.RELEASE)) ^ true) {
            ViewComponent viewComponent = entity.getViewComponent();
            Intrinsics.checkExpressionValueIsNotNull((Object)viewComponent, (String)"entity.viewComponent");
            viewComponent.getView().addNode((Node)this.bubble);
        }
    }

    @Override
    public void onUpdate(@NotNull Entity entity, double tpf) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        BehaviorTree<Entity> behaviorTree = this.behaviorTree;
        if (behaviorTree == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"behaviorTree");
        }
        behaviorTree.step();
    }

    private AIControl() {
        this.bubble = new AIBubble();
    }

    public AIControl(@NotNull BehaviorTree<Entity> behaviorTree) {
        Intrinsics.checkParameterIsNotNull(behaviorTree, (String)"behaviorTree");
        this();
        this.behaviorTree = behaviorTree;
    }

    public AIControl(@NotNull String treeName) {
        Intrinsics.checkParameterIsNotNull((Object)treeName, (String)"treeName");
        this();
        BehaviorTree tree = (BehaviorTree)AIControl.Companion.getParsedTreesCache().get(treeName);
        if (tree == null) {
            tree = FXGL.Companion.getAssetLoader().loadBehaviorTree(treeName);
            Map map2 = AIControl.Companion.getParsedTreesCache();
            BehaviorTree behaviorTree = tree;
            map2.put(treeName, behaviorTree);
        }
        Task task2 = tree.cloneTask();
        if (task2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.almasb.fxgl.ai.btree.BehaviorTree<com.almasb.fxgl.entity.Entity>");
        }
        this.behaviorTree = (BehaviorTree)task2;
    }

    static {
        Companion = new Companion(null);
        parsedTreesCache = new HashMap();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R&\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/almasb/fxgl/ai/AIControl$Companion;", "", "()V", "parsedTreesCache", "Ljava/util/HashMap;", "", "Lcom/almasb/fxgl/ai/btree/BehaviorTree;", "Lcom/almasb/fxgl/entity/Entity;", "getParsedTreesCache", "()Ljava/util/HashMap;", "fxgl"})
    public static final class Companion {
        private final HashMap<String, BehaviorTree<Entity>> getParsedTreesCache() {
            return parsedTreesCache;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

