/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.ai.btree.branch;

import com.almasb.fxgl.ai.btree.BranchTask;
import com.almasb.fxgl.ai.btree.Task;
import com.almasb.fxgl.core.collection.Array;

public class DynamicGuardSelector<E>
extends BranchTask<E> {
    protected Task<E> runningChild;

    public DynamicGuardSelector() {
    }

    public DynamicGuardSelector(Task<E> ... tasks) {
        super(new Array<Task<E>>(tasks));
    }

    public DynamicGuardSelector(Array<Task<E>> tasks) {
        super(tasks);
    }

    @Override
    public void childRunning(Task<E> task2, Task<E> reporter) {
        this.runningChild = task2;
        this.running();
    }

    @Override
    public void childSuccess(Task<E> task2) {
        this.runningChild = null;
        this.success();
    }

    @Override
    public void childFail(Task<E> task2) {
        this.runningChild = null;
        this.fail();
    }

    @Override
    public void run() {
        Task childToRun = null;
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            Task child = (Task)this.children.get(i);
            if (!child.checkGuard(this)) continue;
            childToRun = child;
            break;
        }
        if (this.runningChild != null && this.runningChild != childToRun) {
            this.runningChild.cancel();
            this.runningChild = null;
        }
        if (childToRun == null) {
            this.fail();
        } else {
            if (this.runningChild == null) {
                this.runningChild = childToRun;
                this.runningChild.setControl(this);
                this.runningChild.start();
            }
            this.runningChild.run();
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.runningChild = null;
    }

    @Override
    protected Task<E> copyTo(Task<E> task2) {
        DynamicGuardSelector branch = (DynamicGuardSelector)task2;
        branch.runningChild = null;
        return super.copyTo(task2);
    }
}

