/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.AppStateMachine;
import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.app.MainWindow;
import com.almasb.fxgl.app.State;
import com.almasb.fxgl.asset.FXGLAssets;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.input.Input;
import com.almasb.fxgl.scene.FXGLScene;
import com.almasb.fxgl.scene.Viewport;
import com.almasb.fxgl.settings.ReadOnlyGameSettings;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010(\u001a\u00020\u000bH\u0002J\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020\tJ\u0006\u0010,\u001a\u00020*J\b\u0010-\u001a\u00020*H\u0002J\u0010\u0010.\u001a\u00020*2\u0006\u0010/\u001a\u00020\tH\u0002J\u0006\u00100\u001a\u000201J\u000e\u00102\u001a\u00020*2\u0006\u0010/\u001a\u00020\tJ\b\u00103\u001a\u00020*H\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\t0!j\b\u0012\u0004\u0012\u00020\t`\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/almasb/fxgl/app/MainWindow;", "", "stage", "Ljavafx/stage/Stage;", "settings", "Lcom/almasb/fxgl/settings/ReadOnlyGameSettings;", "(Ljavafx/stage/Stage;Lcom/almasb/fxgl/settings/ReadOnlyGameSettings;)V", "currentScene", "Ljavafx/beans/property/ReadOnlyObjectWrapper;", "Lcom/almasb/fxgl/scene/FXGLScene;", "fxScene", "Ljavafx/scene/Scene;", "genericHandler", "Ljavafx/event/EventHandler;", "Ljavafx/event/Event;", "keyHandler", "Ljavafx/scene/input/KeyEvent;", "log", "Lcom/almasb/fxgl/core/logging/Logger;", "mouseHandler", "Ljavafx/scene/input/MouseEvent;", "onShown", "Ljava/lang/Runnable;", "getOnShown", "()Ljava/lang/Runnable;", "setOnShown", "(Ljava/lang/Runnable;)V", "scaleRatioX", "Ljavafx/beans/property/DoubleProperty;", "scaleRatioY", "scaledHeight", "scaledWidth", "scenes", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getStage", "()Ljavafx/stage/Stage;", "windowBorderHeight", "", "windowBorderWidth", "createScene", "fixAspectRatio", "", "getCurrentScene", "initAndShow", "initStage", "registerScene", "scene", "saveScreenshot", "", "setScene", "show", "fxgl"})
public final class MainWindow {
    private final Logger log;
    private final Scene fxScene;
    private final ReadOnlyObjectWrapper<FXGLScene> currentScene;
    private final DoubleProperty scaledWidth;
    private final DoubleProperty scaledHeight;
    private final DoubleProperty scaleRatioX;
    private final DoubleProperty scaleRatioY;
    private final EventHandler<KeyEvent> keyHandler;
    private final EventHandler<MouseEvent> mouseHandler;
    private final EventHandler<Event> genericHandler;
    @Nullable
    private Runnable onShown;
    private double windowBorderWidth;
    private double windowBorderHeight;
    private final ArrayList<FXGLScene> scenes;
    @NotNull
    private final Stage stage;
    private final ReadOnlyGameSettings settings;

    @Nullable
    public final Runnable getOnShown() {
        return this.onShown;
    }

    public final void setOnShown(@Nullable Runnable runnable) {
        this.onShown = runnable;
    }

    /*
     * WARNING - void declaration
     */
    private final Scene createScene() {
        Rectangle2D bounds;
        Rectangle2D rectangle2D;
        this.log.debug("Creating a JavaFX scene");
        double newW = this.settings.getWidth();
        double newH = this.settings.getHeight();
        if (this.settings.isFullScreenAllowed()) {
            Screen screen = Screen.getPrimary();
            Intrinsics.checkExpressionValueIsNotNull((Object)screen, (String)"Screen.getPrimary()");
            rectangle2D = screen.getBounds();
        } else {
            Screen screen = Screen.getPrimary();
            Intrinsics.checkExpressionValueIsNotNull((Object)screen, (String)"Screen.getPrimary()");
            rectangle2D = screen.getVisualBounds();
        }
        Rectangle2D rectangle2D2 = bounds = rectangle2D;
        Intrinsics.checkExpressionValueIsNotNull((Object)rectangle2D2, (String)"bounds");
        if (newW > rectangle2D2.getWidth() || newH > bounds.getHeight()) {
            this.log.debug("Target size > screen size");
            double extraMargin = 25.0;
            double ratio = newW / newH;
            int n = (int)bounds.getWidth();
            int n2 = 1;
            if (n >= n2) {
                while (true) {
                    void newWidth;
                    if ((double)newWidth / ratio <= bounds.getHeight()) {
                        newW = (double)newWidth - extraMargin;
                        newH = (double)newWidth / ratio;
                        break;
                    }
                    if (newWidth == n2) break;
                    --newWidth;
                }
            }
        }
        newW = (int)newW;
        newH = (int)newH;
        Scene scene = new Scene((Parent)new Pane(), newW, newH);
        this.scaledWidth.set(newW);
        this.scaledHeight.set(newH);
        this.scaleRatioX.set(this.scaledWidth.getValue() / (double)this.settings.getWidth());
        this.scaleRatioY.set(this.scaledHeight.getValue() / (double)this.settings.getHeight());
        this.log.debug("Target settings size: " + (double)this.settings.getWidth() + " x " + (double)this.settings.getHeight());
        this.log.debug("Scaled scene size:    " + newW + " x " + newH);
        this.log.debug("Scaled ratio: (" + this.scaleRatioX.getValue() + ", " + this.scaleRatioY.getValue() + ')');
        return scene;
    }

    public final void initAndShow() {
        this.initStage();
        this.show();
    }

    private final void initStage() {
        Stage stage;
        Stage $receiver = stage = this.stage;
        $receiver.setScene(this.fxScene);
        $receiver.setTitle("" + this.settings.getTitle() + ' ' + this.settings.getVersion());
        $receiver.setResizable(this.settings.isManualResizeEnabled());
        $receiver.initStyle(this.settings.getStageStyle());
        $receiver.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(this){
            final /* synthetic */ MainWindow this$0;
            {
                this.this$0 = mainWindow;
            }

            public final void handle(WindowEvent e) {
                e.consume();
                if (MainWindow.access$getSettings$p(this.this$0).isCloseConfirmation()) {
                    if (FXGL.Companion.getApp().getStateMachine().canShowCloseDialog()) {
                        FXGL.Companion.getDisplay().showConfirmationBox(FXGL.Companion.getLocalizedString("dialog.exitGame"), initStage.1.1.INSTANCE);
                    }
                } else {
                    FXGL.Companion.getApp().exit();
                }
            }
        });
        $receiver.setOnShown((EventHandler)new EventHandler<WindowEvent>(this){
            final /* synthetic */ MainWindow this$0;
            {
                this.this$0 = mainWindow;
            }

            public final void handle(WindowEvent it) {
                block0: {
                    Runnable runnable = this.this$0.getOnShown();
                    if (runnable == null) break block0;
                    runnable.run();
                }
            }
        });
        $receiver.getIcons().add((Object)FXGLAssets.UI_ICON);
        if (this.settings.isFullScreenAllowed()) {
            $receiver.setFullScreenExitHint("");
            $receiver.setFullScreenExitKeyCombination(KeyCombination.NO_MATCH);
        }
        FXGL.Companion.getMenuSettings().fullScreenProperty().addListener((ChangeListener)new ChangeListener<Boolean>($receiver){
            final /* synthetic */ Stage receiver$0;

            public final void changed(ObservableValue<? extends Boolean> $noName_0, Boolean $noName_1, Boolean fullscreenNow) {
                Boolean bl = fullscreenNow;
                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"fullscreenNow");
                this.receiver$0.setFullScreen(bl.booleanValue());
            }
            {
                this.receiver$0 = stage;
            }
        });
        $receiver.sizeToScene();
        $receiver.centerOnScreen();
    }

    private final void show() {
        this.log.debug("Opening main window");
        this.stage.show();
        double d = this.stage.getWidth();
        Double d2 = this.scaledWidth.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)d2, (String)"scaledWidth.value");
        this.windowBorderWidth = d - d2;
        double d3 = this.stage.getHeight();
        Double d4 = this.scaledHeight.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)d4, (String)"scaledHeight.value");
        this.windowBorderHeight = d3 - d4;
        this.scaledWidth.bind((ObservableValue)this.stage.widthProperty().subtract((ObservableNumberValue)Bindings.when((ObservableBooleanValue)((ObservableBooleanValue)this.stage.fullScreenProperty())).then(0).otherwise(this.windowBorderWidth)));
        this.scaledHeight.bind((ObservableValue)this.stage.heightProperty().subtract((ObservableNumberValue)Bindings.when((ObservableBooleanValue)((ObservableBooleanValue)this.stage.fullScreenProperty())).then(0).otherwise(this.windowBorderHeight)));
        this.scaleRatioX.bind((ObservableValue)this.scaledWidth.divide(this.settings.getWidth()));
        this.scaleRatioY.bind((ObservableValue)this.scaledHeight.divide(this.settings.getHeight()));
        this.log.debug("Window border size: (" + this.windowBorderWidth + ", " + this.windowBorderHeight + ')');
        this.log.debug("Scaled size: " + this.scaledWidth.getValue() + " x " + this.scaledHeight.getValue());
        this.log.debug("Scaled ratio: (" + this.scaleRatioX.getValue() + ", " + this.scaleRatioY.getValue() + ')');
        StringBuilder stringBuilder = new StringBuilder().append("Scene size: ");
        Scene scene = this.stage.getScene();
        Intrinsics.checkExpressionValueIsNotNull((Object)scene, (String)"stage.scene");
        StringBuilder stringBuilder2 = stringBuilder.append(scene.getWidth()).append(" x ");
        Scene scene2 = this.stage.getScene();
        Intrinsics.checkExpressionValueIsNotNull((Object)scene2, (String)"stage.scene");
        this.log.debug(stringBuilder2.append(scene2.getHeight()).toString());
        this.log.debug("Stage size: " + this.stage.getWidth() + " x " + this.stage.getHeight());
    }

    public final void fixAspectRatio() {
        this.log.debug("Fixing aspect ratio");
        double ratio = (double)this.settings.getWidth() / (double)this.settings.getHeight();
        this.stage.setHeight(this.scaledWidth.getValue() / ratio + this.windowBorderHeight);
        this.log.debug("Scaled size: " + this.scaledWidth.getValue() + " x " + this.scaledHeight.getValue());
        this.log.debug("Scaled ratio: (" + this.scaleRatioX.getValue() + ", " + this.scaleRatioY.getValue() + ')');
        StringBuilder stringBuilder = new StringBuilder().append("Scene size: ");
        Scene scene = this.stage.getScene();
        Intrinsics.checkExpressionValueIsNotNull((Object)scene, (String)"stage.scene");
        StringBuilder stringBuilder2 = stringBuilder.append(scene.getWidth()).append(" x ");
        Scene scene2 = this.stage.getScene();
        Intrinsics.checkExpressionValueIsNotNull((Object)scene2, (String)"stage.scene");
        this.log.debug(stringBuilder2.append(scene2.getHeight()).toString());
        this.log.debug("Stage size: " + this.stage.getWidth() + " x " + this.stage.getHeight());
    }

    public final void setScene(@NotNull FXGLScene scene) {
        FXGLScene fXGLScene;
        Intrinsics.checkParameterIsNotNull((Object)scene, (String)"scene");
        if (!this.scenes.contains(scene)) {
            this.registerScene(scene);
        }
        if ((fXGLScene = (FXGLScene)this.currentScene.getValue()) != null && (fXGLScene = fXGLScene.activeProperty()) != null) {
            fXGLScene.set(false);
        }
        this.currentScene.set((Object)scene);
        scene.activeProperty().set(true);
        this.fxScene.setRoot((Parent)scene.getRoot());
    }

    private final void registerScene(FXGLScene scene) {
        scene.bindSize(this.scaledWidth, this.scaledHeight, this.scaleRatioX, this.scaleRatioY);
        scene.appendCSS(FXGLAssets.UI_CSS);
        this.scenes.add(scene);
    }

    @NotNull
    public final FXGLScene getCurrentScene() {
        Object object = this.currentScene.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"currentScene.value");
        return (FXGLScene)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean saveScreenshot() {
        WritableImage fxImage = this.fxScene.snapshot(null);
        String fileName = "./" + this.settings.getTitle() + this.settings.getVersion() + LocalDateTime.now();
        fileName = StringsKt.replace$default((String)fileName, (String)":", (String)"_", (boolean)false, (int)4, null);
        BufferedImage img = SwingFXUtils.fromFXImage((Image)((Image)fxImage), null);
        try {
            Closeable closeable = Files.newOutputStream(Paths.get(fileName + ".png", new String[0]), new OpenOption[0]);
            Throwable throwable = null;
            try {
                OutputStream it = (OutputStream)closeable;
                boolean bl = ImageIO.write((RenderedImage)img, "png", it);
                return bl;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            this.log.warning("saveScreenshot() failed: " + e);
            return false;
        }
    }

    @NotNull
    public final Stage getStage() {
        return this.stage;
    }

    public MainWindow(@NotNull Stage stage, @NotNull ReadOnlyGameSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)stage, (String)"stage");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        this.stage = stage;
        this.settings = settings;
        this.log = Logger.Companion.get(this.getClass());
        this.currentScene = new ReadOnlyObjectWrapper();
        this.scaledWidth = (DoubleProperty)new SimpleDoubleProperty();
        this.scaledHeight = (DoubleProperty)new SimpleDoubleProperty();
        this.scaleRatioX = (DoubleProperty)new SimpleDoubleProperty();
        this.scaleRatioY = (DoubleProperty)new SimpleDoubleProperty();
        this.keyHandler = keyHandler.1.INSTANCE;
        this.mouseHandler = (EventHandler)new EventHandler<MouseEvent>(this){
            final /* synthetic */ MainWindow this$0;

            public final void handle(MouseEvent e) {
                block0: {
                    FXGLScene fXGLScene;
                    FXGLScene fXGLScene2 = (FXGLScene)MainWindow.access$getCurrentScene$p(this.this$0).getValue();
                    if (fXGLScene2 == null) break block0;
                    FXGLScene it = fXGLScene = fXGLScene2;
                    AppStateMachine appStateMachine = FXGL.Companion.getApp().getStateMachine();
                    Intrinsics.checkExpressionValueIsNotNull((Object)appStateMachine, (String)"FXGL.getApp().stateMachine");
                    State state = appStateMachine.getCurrentState();
                    Intrinsics.checkExpressionValueIsNotNull((Object)state, (String)"FXGL.getApp().stateMachine.currentState");
                    Input input = state.getInput();
                    MouseEvent mouseEvent = e;
                    Intrinsics.checkExpressionValueIsNotNull((Object)mouseEvent, (String)"e");
                    Viewport viewport = it.getViewport();
                    Intrinsics.checkExpressionValueIsNotNull((Object)viewport, (String)"it.viewport");
                    Double d = MainWindow.access$getScaleRatioX$p(this.this$0).getValue();
                    Intrinsics.checkExpressionValueIsNotNull((Object)d, (String)"scaleRatioX.value");
                    double d2 = d;
                    Double d3 = MainWindow.access$getScaleRatioY$p(this.this$0).getValue();
                    Intrinsics.checkExpressionValueIsNotNull((Object)d3, (String)"scaleRatioY.value");
                    input.onMouseEvent(mouseEvent, viewport, d2, d3);
                }
            }
            {
                this.this$0 = mainWindow;
            }
        };
        this.genericHandler = genericHandler.1.INSTANCE;
        this.fxScene = this.createScene();
        this.fxScene.addEventHandler(KeyEvent.ANY, this.keyHandler);
        this.fxScene.addEventHandler(MouseEvent.ANY, this.mouseHandler);
        this.fxScene.addEventHandler(EventType.ROOT, this.genericHandler);
        MainWindow mainWindow = this;
        ArrayList arrayList = new ArrayList();
        mainWindow.scenes = arrayList;
    }

    @NotNull
    public static final /* synthetic */ ReadOnlyGameSettings access$getSettings$p(MainWindow $this) {
        return $this.settings;
    }

    @NotNull
    public static final /* synthetic */ ReadOnlyObjectWrapper access$getCurrentScene$p(MainWindow $this) {
        return $this.currentScene;
    }

    @NotNull
    public static final /* synthetic */ DoubleProperty access$getScaleRatioX$p(MainWindow $this) {
        return $this.scaleRatioX;
    }

    @NotNull
    public static final /* synthetic */ DoubleProperty access$getScaleRatioY$p(MainWindow $this) {
        return $this.scaleRatioY;
    }
}

