/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.asset;

import com.almasb.fxgl.ai.btree.BehaviorTree;
import com.almasb.fxgl.ai.btree.utils.BehaviorTreeParser;
import com.almasb.fxgl.asset.AssetLoader;
import com.almasb.fxgl.audio.Music;
import com.almasb.fxgl.audio.Sound;
import com.almasb.fxgl.core.collection.ObjectMap;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.parser.KVFile;
import com.almasb.fxgl.scene.CSS;
import com.almasb.fxgl.texture.Texture;
import com.almasb.fxgl.ui.FontFactory;
import com.almasb.fxgl.ui.UI;
import com.almasb.fxgl.ui.UIController;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.image.Image;
import javafx.scene.media.AudioClip;
import javafx.scene.media.Media;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u001fJ\u0012\u0010!\u001a\u0004\u0018\u00010\u00012\u0006\u0010\"\u001a\u00020\u0004H\u0002J\u000e\u0010#\u001a\u00020$2\u0006\u0010\"\u001a\u00020\u0004J\u0010\u0010%\u001a\u00020&2\u0006\u0010\"\u001a\u00020\u0004H\u0002J\u000e\u0010'\u001a\u00020(2\u0006\u0010\"\u001a\u00020\u0004J\u001a\u0010)\u001a\b\u0012\u0004\u0012\u0002H+0*\"\u0004\b\u0000\u0010+2\u0006\u0010\"\u001a\u00020\u0004J\u000e\u0010,\u001a\u00020-2\u0006\u0010\"\u001a\u00020\u0004J\u000e\u0010.\u001a\u00020(2\u0006\u0010\"\u001a\u00020\u0004J\u001b\u0010/\u001a\u0002H+\"\u0004\b\u0000\u0010+2\u0006\u0010\"\u001a\u00020\u0004H\u0003\u00a2\u0006\u0002\u00100J\u001c\u00101\u001a\u000602j\u0002`32\u0006\u00104\u001a\u00020\u00042\u0006\u00105\u001a\u000206H\u0002J\u0014\u00107\u001a\b\u0012\u0004\u0012\u00020\u0004082\u0006\u00109\u001a\u00020\u0004J\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020\u0004082\u0006\u0010;\u001a\u00020\u0004H\u0002J\u000e\u0010<\u001a\u00020=2\u0006\u0010\"\u001a\u00020\u0004J\u000e\u0010>\u001a\u00020(2\u0006\u0010\"\u001a\u00020\u0004J\u0014\u0010?\u001a\b\u0012\u0004\u0012\u00020\u0004082\u0006\u0010\"\u001a\u00020\u0004J+\u0010?\u001a\u0002H+\"\b\b\u0000\u0010+*\u00020\u00012\u0006\u0010\"\u001a\u00020\u00042\f\u0010@\u001a\b\u0012\u0004\u0012\u0002H+0A\u00a2\u0006\u0002\u0010BJ\u000e\u0010C\u001a\u00020D2\u0006\u0010\"\u001a\u00020\u0004J\u000e\u0010E\u001a\u00020F2\u0006\u0010\"\u001a\u00020\u0004J\u000e\u0010G\u001a\u00020H2\u0006\u0010\"\u001a\u00020\u0004J\u000e\u0010I\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004J\u000e\u0010J\u001a\u00020K2\u0006\u0010\"\u001a\u00020\u0004J\u0016\u0010L\u001a\b\u0012\u0004\u0012\u00020\u0004082\u0006\u0010\"\u001a\u00020\u0004H\u0007J\u000e\u0010M\u001a\u00020N2\u0006\u0010\"\u001a\u00020\u0004J\u0016\u0010M\u001a\u00020N2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010O\u001a\u00020PJ\u001e\u0010M\u001a\u00020N2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020RJ\u0016\u0010T\u001a\u00020U2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010V\u001a\u00020WJ\u0016\u0010X\u001a\b\u0012\u0004\u0012\u00020\u0004082\u0006\u0010\"\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"Lcom/almasb/fxgl/asset/AssetLoader;", "", "()V", "AI_DIR", "", "ASSETS_DIR", "BINARY_DIR", "CSS_DIR", "CURSORS_DIR", "FONTS_DIR", "ICON_DIR", "JSON_DIR", "KV_DIR", "MUSIC_DIR", "PROPERTIES_DIR", "SCRIPTS_DIR", "SOUNDS_DIR", "TEXTURES_DIR", "TEXT_DIR", "UI_DIR", "cachedAssets", "Lcom/almasb/fxgl/core/collection/ObjectMap;", "jsonMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getJsonMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "jsonMapper$delegate", "Lkotlin/Lazy;", "log", "Lcom/almasb/fxgl/core/logging/Logger;", "cache", "", "clearCache", "getAssetFromCache", "name", "getStream", "Ljava/io/InputStream;", "getURL", "Ljava/net/URL;", "loadAppIcon", "Ljavafx/scene/image/Image;", "loadBehaviorTree", "Lcom/almasb/fxgl/ai/btree/BehaviorTree;", "T", "loadCSS", "Lcom/almasb/fxgl/scene/CSS;", "loadCursorImage", "loadDataInternal", "(Ljava/lang/String;)Ljava/lang/Object;", "loadFailed", "Ljava/lang/IllegalArgumentException;", "Lkotlin/IllegalArgumentException;", "assetName", "error", "", "loadFileNames", "", "directory", "loadFileNamesJar", "folderName", "loadFont", "Lcom/almasb/fxgl/ui/FontFactory;", "loadImage", "loadJSON", "type", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "loadKV", "Lcom/almasb/fxgl/parser/KVFile;", "loadMusic", "Lcom/almasb/fxgl/audio/Music;", "loadResourceBundle", "Ljava/util/ResourceBundle;", "loadScript", "loadSound", "Lcom/almasb/fxgl/audio/Sound;", "loadText", "loadTexture", "Lcom/almasb/fxgl/texture/Texture;", "transparency", "Ljavafx/scene/paint/Color;", "width", "", "height", "loadUI", "Lcom/almasb/fxgl/ui/UI;", "controller", "Lcom/almasb/fxgl/ui/UIController;", "readAllLines", "fxgl"})
public final class AssetLoader {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final String ASSETS_DIR = "/assets/";
    private final String TEXTURES_DIR = this.ASSETS_DIR + "textures/";
    private final String SOUNDS_DIR = this.ASSETS_DIR + "sounds/";
    private final String MUSIC_DIR = this.ASSETS_DIR + "music/";
    private final String TEXT_DIR = this.ASSETS_DIR + "text/";
    private final String KV_DIR = this.ASSETS_DIR + "kv/";
    private final String JSON_DIR = this.ASSETS_DIR + "json/";
    private final String BINARY_DIR = this.ASSETS_DIR + "data/";
    private final String SCRIPTS_DIR = this.ASSETS_DIR + "scripts/";
    private final String PROPERTIES_DIR = this.ASSETS_DIR + "properties/";
    private final String AI_DIR = this.ASSETS_DIR + "ai/";
    private final String UI_DIR = this.ASSETS_DIR + "ui/";
    private final String CSS_DIR = this.UI_DIR + "css/";
    private final String FONTS_DIR = this.UI_DIR + "fonts/";
    private final String ICON_DIR = this.UI_DIR + "icons/";
    private final String CURSORS_DIR = this.UI_DIR + "cursors/";
    private final Logger log = Logger.Companion.get(this.getClass());
    private final ObjectMap<String, Object> cachedAssets = new ObjectMap();
    private final Lazy jsonMapper$delegate = LazyKt.lazy((Function0)jsonMapper.2.INSTANCE);

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(AssetLoader.class), "jsonMapper", "getJsonMapper()Lcom/fasterxml/jackson/databind/ObjectMapper;"))};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Image loadImage(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Object asset = this.getAssetFromCache(this.TEXTURES_DIR + name);
        if (asset != null) {
            Object t = Image.class.cast(asset);
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"Image::class.java.cast(asset)");
            return (Image)t;
        }
        try {
            Closeable closeable = this.getStream(this.TEXTURES_DIR + name);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                Image image = new Image(it);
                this.cachedAssets.put(this.TEXTURES_DIR + name, image);
                Image image2 = image;
                return image2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            throw (Throwable)this.loadFailed(name, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Texture loadTexture(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Object asset = this.getAssetFromCache(this.TEXTURES_DIR + name);
        if (asset != null) {
            Object t = Image.class.cast(asset);
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"Image::class.java.cast(asset)");
            return new Texture((Image)t);
        }
        try {
            Closeable closeable = this.getStream(this.TEXTURES_DIR + name);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                Texture texture = new Texture(new Image(it));
                this.cachedAssets.put(this.TEXTURES_DIR + name, texture.getImage());
                Texture texture2 = texture;
                return texture2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            throw (Throwable)this.loadFailed(name, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Texture loadTexture(@NotNull String name, double width, double height) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        String cacheKey = this.TEXTURES_DIR + name + "@" + width + "x" + height;
        Object asset = this.getAssetFromCache(cacheKey);
        if (asset != null) {
            Object t = Image.class.cast(asset);
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"Image::class.java.cast(asset)");
            return new Texture((Image)t);
        }
        try {
            Closeable closeable = this.getStream(this.TEXTURES_DIR + name);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                Texture texture = new Texture(new Image(it, width, height, false, true));
                this.cachedAssets.put(cacheKey, texture.getImage());
                Texture texture2 = texture;
                return texture2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            throw (Throwable)this.loadFailed(name, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Texture loadTexture(@NotNull String name, @NotNull Color transparency) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)transparency, (String)"transparency");
        String cacheKey = this.TEXTURES_DIR + name + "T" + transparency;
        Object asset = this.getAssetFromCache(cacheKey);
        if (asset != null) {
            Object t = Image.class.cast(asset);
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"Image::class.java.cast(asset)");
            return new Texture((Image)t);
        }
        try {
            Closeable closeable = this.getStream(this.TEXTURES_DIR + name);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                Texture texture = new Texture(new Image(it));
                Texture newTexture = texture.transparentColor(transparency);
                texture.dispose();
                this.cachedAssets.put(cacheKey, newTexture.getImage());
                Texture texture2 = newTexture;
                return texture2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            throw (Throwable)this.loadFailed(name, e);
        }
    }

    @NotNull
    public final Sound loadSound(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Object asset = this.getAssetFromCache(this.SOUNDS_DIR + name);
        if (asset != null) {
            Object t = Sound.class.cast(asset);
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"Sound::class.java.cast(asset)");
            return (Sound)t;
        }
        try {
            Sound sound = new Sound(new AudioClip(this.getURL(this.SOUNDS_DIR + name).toExternalForm()));
            this.cachedAssets.put(this.SOUNDS_DIR + name, sound);
            return sound;
        }
        catch (Exception e) {
            throw (Throwable)this.loadFailed(name, e);
        }
    }

    @NotNull
    public final Music loadMusic(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Object asset = this.getAssetFromCache(this.MUSIC_DIR + name);
        if (asset != null) {
            Object t = Music.class.cast(asset);
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"Music::class.java.cast(asset)");
            return (Music)t;
        }
        try {
            Music music = new Music(new Media(this.getURL(this.MUSIC_DIR + name).toExternalForm()));
            this.cachedAssets.put(this.MUSIC_DIR + name, music);
            return music;
        }
        catch (Exception e) {
            throw (Throwable)this.loadFailed(name, e);
        }
    }

    @NotNull
    public final List<String> loadText(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Object asset = this.getAssetFromCache(this.TEXT_DIR + name);
        if (asset != null) {
            return (List)asset;
        }
        List<String> text = this.readAllLines(this.TEXT_DIR + name);
        this.cachedAssets.put(this.TEXT_DIR + name, text);
        return text;
    }

    @NotNull
    public final KVFile loadKV(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return new KVFile(this.readAllLines(this.KV_DIR + name));
    }

    @NotNull
    public final List<String> loadJSON(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return this.readAllLines(this.JSON_DIR + name);
    }

    private final ObjectMapper getJsonMapper() {
        Lazy lazy = this.jsonMapper$delegate;
        AssetLoader assetLoader = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (ObjectMapper)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final <T> T loadJSON(@NotNull String name, @NotNull Class<T> type) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        Closeable closeable = this.getStream(this.JSON_DIR + name);
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            Object object = this.getJsonMapper().readValue(it, type);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"jsonMapper.readValue(it, type)");
            Object object2 = object;
            return (T)object2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public final String loadScript(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return CollectionsKt.joinToString$default((Iterable)this.readAllLines(this.SCRIPTS_DIR + name), (CharSequence)"\n", (CharSequence)"", (CharSequence)"\n", (int)0, null, null, (int)56, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ResourceBundle loadResourceBundle(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Object asset = this.getAssetFromCache(this.PROPERTIES_DIR + name);
        if (asset != null) {
            return (ResourceBundle)asset;
        }
        try {
            Closeable closeable = this.getStream(this.PROPERTIES_DIR + name);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                PropertyResourceBundle bundle = new PropertyResourceBundle(new InputStreamReader(it, StandardCharsets.UTF_8));
                this.cachedAssets.put(this.PROPERTIES_DIR + name, bundle);
                ResourceBundle resourceBundle = bundle;
                return resourceBundle;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            throw (Throwable)this.loadFailed(name, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Image loadCursorImage(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        try {
            Closeable closeable = this.getStream(this.CURSORS_DIR + name);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                Image image = new Image(it);
                return image;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            throw (Throwable)this.loadFailed(name, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final UI loadUI(@NotNull String name, @NotNull UIController controller) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)controller, (String)"controller");
        try {
            Closeable closeable = this.getStream(this.UI_DIR + name);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                FXMLLoader loader = new FXMLLoader();
                loader.setController((Object)controller);
                Parent root = (Parent)loader.load(it);
                controller.init();
                Parent parent = root;
                Intrinsics.checkExpressionValueIsNotNull((Object)parent, (String)"root");
                UI uI = new UI(parent, controller);
                return uI;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            throw (Throwable)this.loadFailed(name, e);
        }
    }

    @NotNull
    public final CSS loadCSS(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        try {
            String string = this.getURL(this.CSS_DIR + name).toExternalForm();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getURL(CSS_DIR + name).toExternalForm()");
            return new CSS(string);
        }
        catch (Exception e) {
            throw (Throwable)this.loadFailed(name, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final FontFactory loadFont(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Object asset = this.getAssetFromCache(this.FONTS_DIR + name);
        if (asset != null) {
            Object t = FontFactory.class.cast(asset);
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"FontFactory::class.java.cast(asset)");
            return (FontFactory)t;
        }
        try {
            Closeable closeable = this.getStream(this.FONTS_DIR + name);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                Font font = Font.loadFont((InputStream)it, (double)12.0);
                if (font == null) {
                    font = Font.font((double)12.0);
                }
                Font font2 = font;
                if (font2 == null) {
                    Intrinsics.throwNpe();
                }
                FontFactory fontFactory = new FontFactory(font2);
                this.cachedAssets.put(this.FONTS_DIR + name, fontFactory);
                FontFactory fontFactory2 = fontFactory;
                return fontFactory2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            throw (Throwable)this.loadFailed(name, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Image loadAppIcon(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        try {
            Closeable closeable = this.getStream(this.ICON_DIR + name);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                Image image = new Image(it);
                return image;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            throw (Throwable)this.loadFailed(name, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final <T> BehaviorTree<T> loadBehaviorTree(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        try {
            Closeable closeable = this.getStream(this.AI_DIR + name);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                BehaviorTree<Object> behaviorTree = new BehaviorTreeParser<Object>().parse(it, null);
                Intrinsics.checkExpressionValueIsNotNull(behaviorTree, (String)"BehaviorTreeParser<T>().parse(it, null)");
                BehaviorTree<Object> behaviorTree2 = behaviorTree;
                return behaviorTree2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            throw (Throwable)this.loadFailed(name, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T loadDataInternal(String name) {
        try {
            Closeable closeable = new ObjectInputStream(this.getStream(this.BINARY_DIR + name));
            Throwable throwable = null;
            try {
                ObjectInputStream it = (ObjectInputStream)closeable;
                Object object = it.readObject();
                return (T)object;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            throw (Throwable)this.loadFailed(name, e);
        }
    }

    private final URL getURL(String name) {
        this.log.debug("Loading from disk: " + name);
        URL uRL = this.getClass().getResource(name);
        if (uRL == null) {
            throw (Throwable)new IllegalArgumentException("Asset \"" + name + "\" was not found!");
        }
        return uRL;
    }

    @NotNull
    public final InputStream getStream(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        try {
            InputStream inputStream = this.getURL(name).openStream();
            if (inputStream == null) {
                throw (Throwable)new IOException("Input stream to \"" + name + "\" is null!");
            }
            return inputStream;
        }
        catch (IOException e) {
            throw (Throwable)new IllegalArgumentException("Failed to obtain input stream to URL: " + e);
        }
    }

    private final Object getAssetFromCache(String name) {
        Object asset = this.cachedAssets.get(name);
        if (asset != null) {
            this.log.debug("Loading from cache: " + name);
            return asset;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<String> readAllLines(String name) {
        try {
            Closeable closeable = new BufferedReader(new InputStreamReader(this.getStream(name)));
            Throwable throwable = null;
            try {
                BufferedReader it = (BufferedReader)closeable;
                ArrayList<String> result = new ArrayList<String>();
                while (it.readLine() != null) {
                    String line;
                    result.add(line);
                }
                List list = result;
                return list;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            throw (Throwable)this.loadFailed(name, e);
        }
    }

    public final void cache() {
        String it;
        this.log.debug("Caching assets");
        Iterable $receiver$iv = this.loadFileNames(this.TEXTURES_DIR);
        for (Object element$iv : $receiver$iv) {
            it = (String)element$iv;
            this.loadTexture(it);
        }
        $receiver$iv = this.loadFileNames(this.SOUNDS_DIR);
        for (Object element$iv : $receiver$iv) {
            it = (String)element$iv;
            this.loadSound(it);
        }
        $receiver$iv = this.loadFileNames(this.MUSIC_DIR);
        for (Object element$iv : $receiver$iv) {
            it = (String)element$iv;
            this.loadMusic(it);
        }
        $receiver$iv = this.loadFileNames(this.TEXT_DIR);
        for (Object element$iv : $receiver$iv) {
            it = (String)element$iv;
            this.loadText(it);
        }
        $receiver$iv = this.loadFileNames(this.FONTS_DIR);
        for (Object element$iv : $receiver$iv) {
            it = (String)element$iv;
            this.loadFont(it);
        }
        $receiver$iv = this.loadFileNames(this.BINARY_DIR);
        for (Object element$iv : $receiver$iv) {
            it = (String)element$iv;
            this.loadDataInternal(it);
        }
        this.log.debug("Caching complete. Size: " + this.cachedAssets.size());
    }

    public final void clearCache() {
        this.log.debug("Clearing assets cache");
        this.cachedAssets.clear();
    }

    @NotNull
    public final List<String> loadFileNames(@NotNull String directory) {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        if (!StringsKt.startsWith$default((String)directory, (String)this.ASSETS_DIR, (boolean)false, (int)2, null)) {
            throw (Throwable)new IllegalArgumentException("Directory must start with: " + this.ASSETS_DIR + " Provided: " + directory);
        }
        try {
            URL url = this.getClass().getResource(directory);
            if (url != null) {
                String string = url.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.toString()");
                if (StringsKt.startsWith$default((String)string, (String)"jar", (boolean)false, (int)2, null)) {
                    String string2 = directory;
                    int n = 1;
                    AssetLoader assetLoader = this;
                    String string3 = string2.substring(n);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                    String string4 = string3;
                    return assetLoader.loadFileNamesJar(string4);
                }
                Path dir = Paths.get(url.toURI());
                if (Files.exists(dir, new LinkOption[0])) {
                    List<String> list = Files.walk(dir, new FileVisitOption[0]).filter(loadFileNames.1.INSTANCE).map(new Function<T, R>(dir){
                        final /* synthetic */ Path $dir;

                        @NotNull
                        public final String apply(Path it) {
                            return StringsKt.replace$default((String)((Object)this.$dir.relativize(it)).toString(), (String)"\\", (String)"/", (boolean)false, (int)4, null);
                        }
                        {
                            this.$dir = path;
                        }
                    }).collect(Collectors.toList());
                    Intrinsics.checkExpressionValueIsNotNull(list, (String)"Files.walk(dir)\n        \u2026lectors.toList<String>())");
                    return list;
                }
            }
            String string = directory;
            int n = 1;
            AssetLoader assetLoader = this;
            String string5 = string.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            String string6 = string5;
            return assetLoader.loadFileNamesJar(string6);
        }
        catch (Exception e) {
            throw (Throwable)this.loadFailed(directory, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<String> loadFileNamesJar(String folderName) {
        ArrayList<String> fileNames = new ArrayList<String>();
        ProtectionDomain protectionDomain = AssetLoader.class.getProtectionDomain();
        Intrinsics.checkExpressionValueIsNotNull((Object)protectionDomain, (String)"AssetLoader::class.java.protectionDomain");
        CodeSource src = protectionDomain.getCodeSource();
        if (src != null) {
            URL jar = src.getLocation();
            try {
                Closeable closeable = jar.openStream();
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    Closeable closeable2 = new ZipInputStream(it);
                    Throwable throwable2 = null;
                    try {
                        ZipInputStream zip = (ZipInputStream)closeable2;
                        while (zip.getNextEntry() != null) {
                            String string;
                            ZipEntry ze;
                            String entryName;
                            String string2 = entryName = ze.getName();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"entryName");
                            if (!StringsKt.startsWith$default((String)string2, (String)folderName, (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)entryName, (String)"/", (boolean)false, (int)2, null)) continue;
                            String string3 = entryName;
                            int n = StringsKt.indexOf$default((CharSequence)entryName, (String)folderName, (int)0, (boolean)false, (int)6, null) + folderName.length();
                            ArrayList<String> arrayList = fileNames;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string3.substring(n), (String)"(this as java.lang.String).substring(startIndex)");
                            arrayList.add(string);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                this.log.warning("Failed to load file names from jar - " + e);
            }
        } else {
            this.log.warning("Failed to load file names from jar - No code source");
        }
        return fileNames;
    }

    private final IllegalArgumentException loadFailed(String assetName, Throwable error) {
        this.log.fatal("Loading failed for asset: " + assetName + ". Cause: " + error.getMessage());
        return new IllegalArgumentException("Failed to load asset: " + assetName + ". Cause: " + error.getMessage());
    }
}

