/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity;

import com.almasb.fxgl.core.collection.Array;
import com.almasb.fxgl.core.collection.ObjectMap;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.core.reflect.ReflectionUtils;
import com.almasb.fxgl.entity.Component;
import com.almasb.fxgl.entity.Control;
import com.almasb.fxgl.entity.EntityCopier;
import com.almasb.fxgl.entity.EntitySerializer;
import com.almasb.fxgl.entity.GameWorld;
import com.almasb.fxgl.entity.Module;
import com.almasb.fxgl.entity.ModuleListener;
import com.almasb.fxgl.entity.RenderLayer;
import com.almasb.fxgl.entity.component.BoundingBoxComponent;
import com.almasb.fxgl.entity.component.CoreComponent;
import com.almasb.fxgl.entity.component.PositionComponent;
import com.almasb.fxgl.entity.component.Required;
import com.almasb.fxgl.entity.component.RotationComponent;
import com.almasb.fxgl.entity.component.TypeComponent;
import com.almasb.fxgl.entity.component.ViewComponent;
import com.almasb.fxgl.entity.view.EntityView;
import com.almasb.fxgl.io.serialization.Bundle;
import com.almasb.fxgl.parser.JavaScriptParser;
import com.almasb.fxgl.physics.HitBox;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;

public class Entity {
    private static final Logger log = Logger.get(Entity.class);
    private ObjectMap<String, Object> properties = new ObjectMap();
    private ObjectMap<String, JavaScriptParser> scripts = new ObjectMap();
    private ObjectMap<Class<? extends Control>, Control> controls = new ObjectMap();
    private ObjectMap<Class<? extends Component>, Component> components = new ObjectMap();
    private List<ModuleListener> moduleListeners = new ArrayList<ModuleListener>();
    private GameWorld world = null;
    private ReadOnlyBooleanWrapper active = new ReadOnlyBooleanWrapper(false);
    private boolean controlsEnabled = true;
    private Runnable onActive = null;
    private Runnable onNotActive = null;
    private boolean updating = false;
    private TypeComponent type = new TypeComponent();
    private PositionComponent position = new PositionComponent();
    private RotationComponent rotation = new RotationComponent();
    private BoundingBoxComponent bbox = new BoundingBoxComponent(new HitBox[0]);
    private ViewComponent view = new ViewComponent();
    private static final Object NULL = new Object();

    public Entity() {
        this.addComponent(this.type);
        this.addComponent(this.position);
        this.addComponent(this.rotation);
        this.addComponent(this.bbox);
        this.addComponent(this.view);
    }

    public GameWorld getWorld() {
        return this.world;
    }

    void init(GameWorld world) {
        this.world = world;
        if (this.onActive != null) {
            this.onActive.run();
        }
        this.active.set(true);
    }

    void clean() {
        this.removeAllControls();
        this.removeAllComponents();
        this.properties.clear();
        this.moduleListeners.clear();
        this.world = null;
        this.onActive = null;
        this.onNotActive = null;
        this.controlsEnabled = true;
        this.updating = false;
        this.active.set(false);
    }

    public final void removeFromWorld() {
        if (this.world != null) {
            this.world.removeEntity(this);
        }
    }

    public final TypeComponent getTypeComponent() {
        return this.type;
    }

    public final PositionComponent getPositionComponent() {
        return this.position;
    }

    public final RotationComponent getRotationComponent() {
        return this.rotation;
    }

    public final BoundingBoxComponent getBoundingBoxComponent() {
        return this.bbox;
    }

    public final ViewComponent getViewComponent() {
        return this.view;
    }

    public final Serializable getType() {
        return (Serializable)this.type.getValue();
    }

    public final void setType(Serializable type) {
        this.type.setValue(type);
    }

    public final boolean isType(Object type) {
        return this.type.isType(type);
    }

    public final ObjectProperty<Serializable> typeProperty() {
        return this.type.valueProperty();
    }

    public final Point2D getPosition() {
        return this.position.getValue();
    }

    public final void setPosition(Point2D position2) {
        this.position.setValue(position2);
    }

    public final void setPosition(double x, double y) {
        this.position.setValue(x, y);
    }

    public final double getX() {
        return this.position.getX();
    }

    public final double getY() {
        return this.position.getY();
    }

    public final void setX(double x) {
        this.position.setX(x);
    }

    public final void setY(double y) {
        this.position.setY(y);
    }

    public final DoubleProperty xProperty() {
        return this.position.xProperty();
    }

    public final DoubleProperty yProperty() {
        return this.position.yProperty();
    }

    public final void translate(Point2D vector) {
        this.position.translate(vector);
    }

    public final void translate(Vec2 vector) {
        this.position.translate(vector.x, vector.y);
    }

    public final void translate(double dx, double dy) {
        this.position.translate(dx, dy);
    }

    public final void translateX(double dx) {
        this.position.translateX(dx);
    }

    public final void translateY(double dy) {
        this.position.translateY(dy);
    }

    public final void translateTowards(Point2D point, double distance) {
        this.position.translateTowards(point, distance);
    }

    public final double distance(Entity other) {
        return this.position.distance(other.position);
    }

    public final double getRotation() {
        return this.rotation.getValue();
    }

    public final void setRotation(double angle) {
        this.rotation.setValue(angle);
    }

    public final DoubleProperty angleProperty() {
        return this.rotation.angleProperty();
    }

    public final void rotateBy(double angle) {
        this.rotation.rotateBy(angle);
    }

    public final void rotateToVector(Point2D vector) {
        this.rotation.rotateToVector(vector);
    }

    public final double getWidth() {
        return this.bbox.getWidth();
    }

    public final double getHeight() {
        return this.bbox.getHeight();
    }

    public final ReadOnlyDoubleProperty widthProperty() {
        return this.bbox.widthProperty();
    }

    public final ReadOnlyDoubleProperty heightProperty() {
        return this.bbox.heightProperty();
    }

    public final double getRightX() {
        return this.bbox.getMaxXWorld();
    }

    public final double getBottomY() {
        return this.bbox.getMaxYWorld();
    }

    public final Point2D getCenter() {
        return this.bbox.getCenterWorld();
    }

    public final boolean isColliding(Entity other) {
        return this.bbox.isCollidingWith(other.bbox);
    }

    public final boolean isWithin(Rectangle2D bounds) {
        return this.bbox.isWithin(bounds);
    }

    public final EntityView getView() {
        return this.view.getView();
    }

    public final void setView(Node view) {
        this.view.setView(view);
    }

    public final void setViewFromTexture(String textureName) {
        this.view.setTexture(textureName);
    }

    public final void setViewFromTextureWithBBox(String textureName) {
        this.view.setTexture(textureName, true);
    }

    public final void setViewWithBBox(Node view) {
        this.view.setView(view, true);
    }

    public final RenderLayer getRenderLayer() {
        return this.view.getRenderLayer();
    }

    public final void setRenderLayer(RenderLayer layer) {
        this.view.setRenderLayer(layer);
    }

    public final void setScaleX(double scaleX) {
        this.view.getView().setScaleX(scaleX);
    }

    public final void setScaleY(double scaleY) {
        this.view.getView().setScaleY(scaleY);
    }

    public final ReadOnlyBooleanProperty activeProperty() {
        return this.active.getReadOnlyProperty();
    }

    public final boolean isActive() {
        return this.active.get();
    }

    public final void setOnActive(Runnable action2) {
        this.onActive = action2;
    }

    public final void setOnNotActive(Runnable action2) {
        this.onNotActive = action2;
    }

    void markForRemoval() {
        if (this.onNotActive != null) {
            this.onNotActive.run();
        }
        this.active.set(false);
    }

    public final void setControlsEnabled(boolean b) {
        this.controlsEnabled = b;
    }

    void update(double tpf) {
        this.updating = true;
        if (this.controlsEnabled) {
            for (Control c : this.controls.values()) {
                if (c.isPaused()) continue;
                c.onUpdate(this, tpf);
            }
        }
        this.updating = false;
    }

    public ObjectMap<String, Object> getProperties() {
        return this.properties;
    }

    public final void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public final <T> T getProperty(String key) {
        Object value = this.properties.get(key, NULL);
        if (value == NULL) {
            log.warning("Access property with missing key: " + key);
            return null;
        }
        return (T)value;
    }

    public final <T> Optional<T> getPropertyOptional(String key) {
        Object value = this.properties.get(key, null);
        return Optional.ofNullable(value);
    }

    public final boolean hasControl(Class<? extends Control> type) {
        return this.controls.containsKey(type);
    }

    public final <T extends Control> Optional<T> getControlOptional(Class<T> type) {
        return Optional.ofNullable(this.getControl(type));
    }

    public final <T extends Control> T getControl(Class<T> type) {
        return (T)((Control)type.cast(this.controls.get(type)));
    }

    public final Array<Control> getControls() {
        return this.controls.values().toArray();
    }

    public final void addControl(Control control) {
        this.checkNotUpdating("Add control");
        this.addModule(control);
        this.controls.put(control.getClass(), control);
    }

    public final boolean removeControl(Class<? extends Control> type) {
        this.checkNotUpdating("Remove control");
        if (!this.hasControl(type)) {
            return false;
        }
        this.removeModule(this.getControl(type));
        this.controls.remove(type);
        return true;
    }

    private void removeAllControls() {
        for (Control control : this.controls.values()) {
            this.removeModule(control);
        }
        this.controls.clear();
    }

    public final boolean hasComponent(Class<? extends Component> type) {
        return this.components.containsKey(type);
    }

    public final <T extends Component> Optional<T> getComponentOptional(Class<T> type) {
        return Optional.ofNullable(this.getComponent(type));
    }

    public final <T extends Component> T getComponent(Class<T> type) {
        return (T)((Component)type.cast(this.components.get(type)));
    }

    public final Array<Component> getComponents() {
        return this.components.values().toArray();
    }

    public final void addComponent(Component component) {
        this.addModule(component);
        this.components.put(component.getClass(), component);
    }

    public final boolean removeComponent(Class<? extends Component> type) {
        if (this.isCoreComponent(type)) {
            throw new IllegalArgumentException("Removing a core component: " + type + " is not allowed");
        }
        if (!this.hasComponent(type)) {
            return false;
        }
        this.checkNotRequiredByAny(type);
        this.removeModule(this.getComponent(type));
        this.components.remove(type);
        return true;
    }

    private boolean isCoreComponent(Class<? extends Component> type) {
        return type.getDeclaredAnnotation(CoreComponent.class) != null;
    }

    private void removeAllComponents() {
        for (Component comp : this.components.values()) {
            this.removeModule(comp);
        }
        this.components.clear();
    }

    public void addModuleListener(ModuleListener listener2) {
        this.moduleListeners.add(listener2);
    }

    public void removeModuleListener(ModuleListener listener2) {
        this.moduleListeners.remove(listener2);
    }

    private void addModule(Module module) {
        this.checkRequirementsMet(module.getClass());
        module.setEntity(this);
        if (module instanceof Control) {
            this.injectFields((Control)module);
        } else if (module instanceof Component) {
            this.injectFields((Component)module);
        }
        module.onAdded(this);
        this.notifyModuleAdded(module);
    }

    private void injectFields(Component component) {
        ReflectionUtils.findFieldsByTypeRecursive(component, Component.class).forEach(field -> {
            Object comp = this.getComponent(field.getType());
            if (comp != null) {
                ReflectionUtils.inject(field, component, comp);
            }
        });
    }

    private void injectFields(Control control) {
        ReflectionUtils.findFieldsByTypeRecursive(control, Component.class).forEach(field -> {
            Object comp = this.getComponent(field.getType());
            if (comp != null) {
                ReflectionUtils.inject(field, control, comp);
            }
        });
        ReflectionUtils.findFieldsByTypeRecursive(control, Control.class).forEach(field -> {
            Object ctrl = this.getControl(field.getType());
            if (ctrl != null) {
                ReflectionUtils.inject(field, control, ctrl);
            }
        });
        String controlName = control.getClass().getSimpleName();
        if (controlName.endsWith("Control") && controlName.length() > 8) {
            String fieldName = controlName.substring(1, controlName.length() - 7);
            fieldName = Character.toLowerCase(controlName.charAt(0)) + fieldName;
            ReflectionUtils.getDeclaredField(fieldName, control).ifPresent(field -> {
                if (Entity.class.isAssignableFrom(field.getType())) {
                    ReflectionUtils.inject(field, control, this);
                }
            });
        }
    }

    private void removeModule(Module module) {
        this.notifyModuleRemoved(module);
        module.onRemoved(this);
        module.setEntity(null);
    }

    private <T extends Module> void notifyModuleAdded(T module) {
        if (module instanceof Component) {
            Component c = (Component)module;
            for (int i = 0; i < this.moduleListeners.size(); ++i) {
                this.moduleListeners.get(i).onAdded(c);
            }
        } else {
            Control c = (Control)module;
            for (int i = 0; i < this.moduleListeners.size(); ++i) {
                this.moduleListeners.get(i).onAdded(c);
            }
        }
    }

    private <T extends Module> void notifyModuleRemoved(T module) {
        if (module instanceof Component) {
            Component c = (Component)module;
            for (int i = 0; i < this.moduleListeners.size(); ++i) {
                this.moduleListeners.get(i).onRemoved(c);
            }
        } else {
            Control c = (Control)module;
            for (int i = 0; i < this.moduleListeners.size(); ++i) {
                this.moduleListeners.get(i).onRemoved(c);
            }
        }
    }

    private void checkNotUpdating(String action2) {
        if (this.updating) {
            throw new IllegalStateException("Cannot " + action2 + " during updating");
        }
    }

    private void checkNotAnonymous(Class<?> type) {
        if (type.isAnonymousClass() || type.getCanonicalName() == null) {
            throw new IllegalArgumentException("Anonymous types are not allowed: " + type.getName());
        }
    }

    private void checkNotDuplicate(Class<?> type) {
        if (Component.class.isAssignableFrom(type) && this.hasComponent(type) || Control.class.isAssignableFrom(type) && this.hasControl(type)) {
            throw new IllegalArgumentException("Entity already has type: " + type.getCanonicalName());
        }
    }

    private void checkRequirementsMet(Class<?> type) {
        Required[] required;
        this.checkNotAnonymous(type);
        this.checkNotDuplicate(type);
        for (Required r : required = (Required[])type.getAnnotationsByType(Required.class)) {
            if (this.hasComponent(r.value())) continue;
            throw new IllegalStateException("Required component: [" + r.value().getSimpleName() + "] for: " + type.getSimpleName() + " is missing");
        }
    }

    private void checkNotRequiredByAny(Class<? extends Component> type) {
        for (Class clazz : this.components.keys()) {
            this.checkNotRequiredBy(clazz, type);
        }
        for (Class clazz : this.controls.keys()) {
            this.checkNotRequiredBy(clazz, type);
        }
    }

    private void checkNotRequiredBy(Class<?> requiringType, Class<? extends Component> type) {
        for (Required required : (Required[])requiringType.getAnnotationsByType(Required.class)) {
            if (!required.value().equals(type)) continue;
            throw new IllegalArgumentException("Required component: [" + required.value().getSimpleName() + "] by: " + requiringType.getSimpleName());
        }
    }

    public final Optional<JavaScriptParser> getScriptHandler(String scriptType) {
        if (this.scripts.containsKey(scriptType)) {
            return Optional.of(this.scripts.get(scriptType));
        }
        return this.getPropertyOptional(scriptType).flatMap(scriptFile -> {
            JavaScriptParser scriptParser = new JavaScriptParser((String)scriptFile);
            this.scripts.put(scriptType, scriptParser);
            return Optional.of(scriptParser);
        });
    }

    public Entity copy() {
        return EntityCopier.INSTANCE.copy(this);
    }

    public void save(Bundle bundle) {
        EntitySerializer.INSTANCE.save(this, bundle);
    }

    public void load(Bundle bundle) {
        EntitySerializer.INSTANCE.load(this, bundle);
    }

    public String toString() {
        return "Entity(" + String.join((CharSequence)"\n", "components=" + this.components, "controls=" + this.controls) + ")";
    }
}

