/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.core.collection.Array;
import com.almasb.fxgl.core.collection.ObjectMap;
import com.almasb.fxgl.core.collection.UnorderedArray;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.reflect.ReflectionUtils;
import com.almasb.fxgl.entity.Component;
import com.almasb.fxgl.entity.Entities;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.EntityFactory;
import com.almasb.fxgl.entity.EntityGroup;
import com.almasb.fxgl.entity.EntitySpawner;
import com.almasb.fxgl.entity.EntityWorldListener;
import com.almasb.fxgl.entity.GameWorldQuery;
import com.almasb.fxgl.entity.RenderLayer;
import com.almasb.fxgl.entity.SpawnData;
import com.almasb.fxgl.entity.Spawns;
import com.almasb.fxgl.entity.component.BoundingBoxComponent;
import com.almasb.fxgl.entity.component.IDComponent;
import com.almasb.fxgl.entity.component.IrremovableComponent;
import com.almasb.fxgl.entity.component.TimeComponent;
import com.almasb.fxgl.gameplay.Level;
import com.almasb.fxgl.parser.tiled.TiledMap;
import com.almasb.fxgl.parser.tiled.TiledObject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;

public final class GameWorld {
    private static Logger log = Logger.get("FXGL.GameWorld");
    private Array<Entity> updateList;
    private Array<Entity> waitingList;
    private List<Entity> entities;
    private GameWorldQuery query;
    private Array<EntityWorldListener> worldListeners = new Array();
    private ObjectProperty<Entity> selectedEntity = new SimpleObjectProperty();
    private EntityFactory entityFactory = null;
    private ObjectMap<String, EntitySpawner> entitySpawners = new ObjectMap();

    public GameWorld() {
        this(32);
    }

    public GameWorld(int initialCapacity) {
        this.updateList = new Array(initialCapacity);
        this.waitingList = new UnorderedArray<Entity>(initialCapacity);
        this.entities = new ArrayList<Entity>(initialCapacity);
        this.query = new GameWorldQuery(this.entities);
        log.debug("Game world initialized");
    }

    public void addEntity(Entity entity) {
        if (entity.isActive()) {
            throw new IllegalArgumentException("Entity is already attached to world");
        }
        this.waitingList.add(entity);
        this.entities.add(entity);
        this.add(entity);
    }

    public void addEntities(Entity ... entitiesToAdd) {
        for (Entity e : entitiesToAdd) {
            this.addEntity(e);
        }
    }

    public void removeEntity(Entity entity) {
        if (!entity.isActive()) {
            log.warning("Attempted to remove entity which is not active");
            return;
        }
        if (!this.canRemove(entity)) {
            return;
        }
        if (entity.getWorld() != this) {
            throw new IllegalArgumentException("Attempted to remove entity not attached to this world");
        }
        this.entities.remove(entity);
        entity.markForRemoval();
        this.notifyEntityRemoved(entity);
    }

    public void removeEntities(Entity ... entitiesToRemove) {
        for (Entity e : entitiesToRemove) {
            this.removeEntity(e);
        }
    }

    private void update(double tpf) {
        this.updateList.addAll(this.waitingList);
        this.waitingList.clear();
        Iterator<Entity> it = this.updateList.iterator();
        while (it.hasNext()) {
            Entity e = it.next();
            if (!e.isActive()) {
                e.clean();
                it.remove();
                continue;
            }
            TimeComponent time = e.getComponent(TimeComponent.class);
            double tpfRatio = time == null ? 1.0 : time.getValue();
            e.update(tpf * tpfRatio);
        }
    }

    public void clear() {
        Entity e;
        log.debug("Clearing game world");
        this.waitingList.clear();
        Iterator<Entity> it = this.updateList.iterator();
        while (it.hasNext()) {
            e = it.next();
            if (!e.isActive()) {
                e.clean();
            }
            it.remove();
        }
        it = this.entities.iterator();
        while (it.hasNext()) {
            e = it.next();
            e.markForRemoval();
            this.notifyEntityRemoved(e);
            e.clean();
            it.remove();
        }
    }

    private void add(Entity entity) {
        entity.init(this);
        this.notifyEntityAdded(entity);
    }

    private boolean canRemove(Entity entity) {
        return !entity.hasComponent(IrremovableComponent.class);
    }

    public void addWorldListener(EntityWorldListener listener2) {
        this.worldListeners.add(listener2);
    }

    public void removeWorldListener(EntityWorldListener listener2) {
        this.worldListeners.removeValueByIdentity(listener2);
    }

    private void notifyEntityAdded(Entity e) {
        for (int i = 0; i < this.worldListeners.size(); ++i) {
            this.worldListeners.get(i).onEntityAdded(e);
        }
    }

    private void notifyEntityRemoved(Entity e) {
        for (int i = 0; i < this.worldListeners.size(); ++i) {
            this.worldListeners.get(i).onEntityRemoved(e);
        }
    }

    public List<Entity> getEntities() {
        return this.entities;
    }

    public List<Entity> getEntitiesCopy() {
        return new ArrayList<Entity>(this.entities);
    }

    public void onUpdate(double tpf) {
        this.update(tpf);
    }

    public Optional<Entity> getSelectedEntity() {
        return Optional.ofNullable(this.selectedEntity.get());
    }

    public ObjectProperty<Entity> selectedEntityProperty() {
        return this.selectedEntity;
    }

    public void setLevel(Level level) {
        this.clearLevel();
        log.debug("Setting level: " + level);
        level.getEntities().forEach(this::addEntity);
    }

    public void setLevelFromMap(String mapFileName) {
        this.setLevelFromMap(FXGL.getAssetLoader().loadJSON(mapFileName, TiledMap.class));
    }

    public void setLevelFromMap(TiledMap map2) {
        this.clearLevel();
        log.debug("Setting level from map");
        map2.getLayers().stream().filter(l -> l.getType().equals("tilelayer")).forEach(l -> Entities.builder().viewFromTiles(map2, l.getName(), RenderLayer.BACKGROUND).buildAndAttach(this));
        map2.getLayers().stream().filter(l -> l.getType().equals("objectgroup")).flatMap(l -> l.getObjects().stream()).forEach(obj -> this.spawn(obj.getType(), new SpawnData((TiledObject)obj)));
    }

    private void clearLevel() {
        Entity e;
        log.debug("Clearing removable entities");
        this.waitingList.clear();
        Iterator<Entity> it = this.updateList.iterator();
        while (it.hasNext()) {
            e = it.next();
            if (!this.canRemove(e)) continue;
            if (!e.isActive()) {
                e.clean();
            }
            it.remove();
        }
        it = this.entities.iterator();
        while (it.hasNext()) {
            e = it.next();
            if (!this.canRemove(e)) continue;
            e.markForRemoval();
            this.notifyEntityRemoved(e);
            e.clean();
            it.remove();
        }
    }

    public <T extends EntityFactory> T getEntityFactory() {
        return (T)this.entityFactory;
    }

    public void setEntityFactory(EntityFactory entityFactory) {
        this.entityFactory = entityFactory;
        this.entitySpawners.clear();
        ReflectionUtils.findMethodsMapToFunctions(entityFactory, Spawns.class, EntitySpawner.class).forEach((annotation, entitySpawner) -> this.entitySpawners.put(annotation.value(), (EntitySpawner)entitySpawner));
    }

    public Entity spawn(String entityName) {
        return this.spawn(entityName, 0.0, 0.0);
    }

    public Entity spawn(String entityName, Point2D position2) {
        return this.spawn(entityName, position2.getX(), position2.getY());
    }

    public Entity spawn(String entityName, double x, double y) {
        return this.spawn(entityName, new SpawnData(x, y));
    }

    public Entity spawn(String entityName, SpawnData data) {
        if (this.entityFactory == null) {
            throw new IllegalStateException("EntityFactory was not set!");
        }
        EntitySpawner spawner = this.entitySpawners.get(entityName);
        if (spawner == null) {
            throw new IllegalArgumentException("EntityFactory does not have a method annotated @Spawns(" + entityName + ")");
        }
        Entity entity = spawner.spawn(data);
        this.addEntity(entity);
        return entity;
    }

    public <T extends Entity> EntityGroup<T> getGroup(Enum<?> ... types) {
        return new EntityGroup<Entity>(this, this.getEntitiesByType(types), types);
    }

    public Optional<Entity> getSingleton(Enum<?> type) {
        return this.getSingleton((Entity e) -> e.isType(type));
    }

    public Optional<Entity> getSingleton(Predicate<Entity> predicate) {
        for (int i = 0; i < this.entities.size(); ++i) {
            Entity e = this.entities.get(i);
            if (!predicate.test(e)) continue;
            return Optional.of(e);
        }
        return Optional.empty();
    }

    public Optional<Entity> getRandom(Enum<?> type) {
        return FXGLMath.random(this.getEntitiesByType(type));
    }

    public Optional<Entity> getRandom(Predicate<Entity> predicate) {
        return FXGLMath.random(this.getEntitiesFiltered(predicate));
    }

    public List<Entity> getEntitiesByComponent(Class<? extends Component> type) {
        return this.entities.stream().filter(e -> e.hasComponent(type)).collect(Collectors.toList());
    }

    public List<Entity> getEntitiesFiltered(Predicate<Entity> predicate) {
        return this.query.getEntitiesFiltered(predicate);
    }

    public void getEntitiesFiltered(Array<Entity> result, Predicate<Entity> predicate) {
        for (int i = 0; i < this.entities.size(); ++i) {
            Entity e = this.entities.get(i);
            if (!predicate.test(e)) continue;
            result.add(e);
        }
    }

    public List<Entity> getEntitiesByType(Enum<?> ... types) {
        return this.query.getEntitiesByType(types);
    }

    public void getEntitiesByType(Array<Entity> result, Enum<?> ... types) {
        if (types.length == 0) {
            for (int i = 0; i < this.entities.size(); ++i) {
                Entity e = this.entities.get(i);
                result.add(e);
            }
            return;
        }
        for (int i = 0; i < this.entities.size(); ++i) {
            Entity e = this.entities.get(i);
            if (!this.isOfType(e, types)) continue;
            result.add(e);
        }
    }

    private boolean isOfType(Entity e, Enum<?> ... types) {
        for (Enum<?> type : types) {
            if (!e.isType(type)) continue;
            return true;
        }
        return false;
    }

    public List<Entity> getEntitiesInRange(Rectangle2D selection) {
        return this.query.getEntitiesInRange(selection);
    }

    public void getEntitiesInRange(Array<Entity> result, double minX, double minY, double maxX, double maxY) {
        for (int i = 0; i < this.entities.size(); ++i) {
            Entity e = this.entities.get(i);
            if (!e.getBoundingBoxComponent().isWithin(minX, minY, maxX, maxY)) continue;
            result.add(e);
        }
    }

    public List<Entity> getCollidingEntities(Entity entity) {
        return this.query.getCollidingEntities(entity);
    }

    public void getCollidingEntities(Array<Entity> result, Entity entity) {
        BoundingBoxComponent entityBBox = entity.getBoundingBoxComponent();
        for (int i = 0; i < this.entities.size(); ++i) {
            Entity e = this.entities.get(i);
            if (!e.getBoundingBoxComponent().isCollidingWith(entityBBox) || e == entity) continue;
            result.add(e);
        }
    }

    public List<Entity> getEntitiesByLayer(RenderLayer layer) {
        return this.query.getEntitiesByLayer(layer);
    }

    public void getEntitiesByLayer(Array<Entity> result, RenderLayer layer) {
        for (int i = 0; i < this.entities.size(); ++i) {
            Entity e = this.entities.get(i);
            if (e.getRenderLayer().index() != layer.index()) continue;
            result.add(e);
        }
    }

    public List<Entity> getEntitiesAt(Point2D position2) {
        return this.query.getEntitiesAt(position2);
    }

    public void getEntitiesAt(Array<Entity> result, Point2D position2) {
        for (int i = 0; i < this.entities.size(); ++i) {
            Entity e = this.entities.get(i);
            if (!e.getPosition().equals((Object)position2)) continue;
            result.add(e);
        }
    }

    public Optional<Entity> getClosestEntity(Entity entity, Predicate<Entity> filter) {
        UnorderedArray<Entity> array = new UnorderedArray<Entity>(64);
        for (Entity e2 : this.entities) {
            if (!filter.test(e2) || e2 == entity) continue;
            array.add(e2);
        }
        if (array.size() == 0) {
            return Optional.empty();
        }
        array.sort(Comparator.comparingDouble(e -> e.distance(entity)));
        return Optional.of(array.get(0));
    }

    public Optional<Entity> getEntityByID(String name, int id) {
        for (Entity e : this.getEntitiesByComponent(IDComponent.class)) {
            IDComponent idComponent = e.getComponent(IDComponent.class);
            if (!idComponent.getName().equals(name) || idComponent.getID() != id) continue;
            return Optional.of(e);
        }
        return Optional.empty();
    }
}

