/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.animation;

import com.almasb.fxgl.animation.AnimatedColor;
import com.almasb.fxgl.animation.AnimatedValue;
import com.almasb.fxgl.animation.Animation;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.animation.AnimationBuilder;
import com.almasb.fxgl.entity.component.ColorComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.animation.Interpolator;
import javafx.scene.paint.Color;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nJ\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\nJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/almasb/fxgl/entity/animation/ColorAnimationBuilder;", "", "animationBuilder", "Lcom/almasb/fxgl/entity/animation/AnimationBuilder;", "(Lcom/almasb/fxgl/entity/animation/AnimationBuilder;)V", "endColor", "Ljavafx/scene/paint/Color;", "kotlin.jvm.PlatformType", "startColor", "build", "Lcom/almasb/fxgl/animation/Animation;", "buildAndPlay", "fromColor", "toColor", "fxgl"})
public final class ColorAnimationBuilder {
    private Color startColor;
    private Color endColor;
    private final AnimationBuilder animationBuilder;

    @NotNull
    public final ColorAnimationBuilder fromColor(@NotNull Color startColor) {
        Intrinsics.checkParameterIsNotNull((Object)startColor, (String)"startColor");
        this.startColor = startColor;
        return this;
    }

    @NotNull
    public final ColorAnimationBuilder toColor(@NotNull Color endColor) {
        Intrinsics.checkParameterIsNotNull((Object)endColor, (String)"endColor");
        this.endColor = endColor;
        return this;
    }

    @NotNull
    public final Animation<?> build() {
        Color color = this.startColor;
        Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"startColor");
        Color color2 = this.endColor;
        Intrinsics.checkExpressionValueIsNotNull((Object)color2, (String)"endColor");
        Interpolator interpolator = this.animationBuilder.getInterpolator();
        Intrinsics.checkExpressionValueIsNotNull((Object)interpolator, (String)"animationBuilder.interpolator");
        return new Animation<Color>(this, this.animationBuilder, (AnimatedValue)new AnimatedColor(color, color2, interpolator)){
            final /* synthetic */ ColorAnimationBuilder this$0;

            /*
             * WARNING - void declaration
             */
            public void onProgress(@NotNull Color value) {
                void $receiver$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                List<Entity> list = ColorAnimationBuilder.access$getAnimationBuilder$p(this.this$0).getEntities();
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"animationBuilder.entities");
                Iterable $receiver$iv = list;
                Iterable iterable = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it;
                    Entity entity = (Entity)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    ColorComponent colorComponent = it.getComponent(ColorComponent.class);
                    collection.add(colorComponent);
                }
                $receiver$iv = (List)destination$iv$iv;
                for (E element$iv : $receiver$iv) {
                    ColorComponent it;
                    ColorComponent colorComponent = it = (ColorComponent)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)colorComponent, (String)"it");
                    colorComponent.setValue(value);
                }
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2);
            }
        };
    }

    @NotNull
    public final Animation<?> buildAndPlay() {
        Animation<?> anim = this.build();
        anim.startInPlayState();
        return anim;
    }

    public ColorAnimationBuilder(@NotNull AnimationBuilder animationBuilder) {
        Intrinsics.checkParameterIsNotNull((Object)animationBuilder, (String)"animationBuilder");
        this.animationBuilder = animationBuilder;
        this.startColor = Color.TRANSPARENT;
        this.endColor = Color.TRANSPARENT;
    }

    @NotNull
    public static final /* synthetic */ AnimationBuilder access$getAnimationBuilder$p(ColorAnimationBuilder $this) {
        return $this.animationBuilder;
    }
}

