/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.animation;

import com.almasb.fxgl.animation.AnimatedPoint2D;
import com.almasb.fxgl.animation.AnimatedValue;
import com.almasb.fxgl.animation.Animation;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.animation.AnimationBuilder;
import java.util.List;
import javafx.animation.Interpolator;
import javafx.geometry.Point2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tJ\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\tJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/almasb/fxgl/entity/animation/ScaleAnimationBuilder;", "", "animationBuilder", "Lcom/almasb/fxgl/entity/animation/AnimationBuilder;", "(Lcom/almasb/fxgl/entity/animation/AnimationBuilder;)V", "endScale", "Ljavafx/geometry/Point2D;", "startScale", "build", "Lcom/almasb/fxgl/animation/Animation;", "buildAndPlay", "from", "start", "to", "end", "fxgl"})
public final class ScaleAnimationBuilder {
    private Point2D startScale;
    private Point2D endScale;
    private final AnimationBuilder animationBuilder;

    @NotNull
    public final ScaleAnimationBuilder from(@NotNull Point2D start2) {
        Intrinsics.checkParameterIsNotNull((Object)start2, (String)"start");
        this.startScale = start2;
        return this;
    }

    @NotNull
    public final ScaleAnimationBuilder to(@NotNull Point2D end) {
        Intrinsics.checkParameterIsNotNull((Object)end, (String)"end");
        this.endScale = end;
        return this;
    }

    @NotNull
    public final Animation<?> build() {
        Interpolator interpolator = this.animationBuilder.getInterpolator();
        Intrinsics.checkExpressionValueIsNotNull((Object)interpolator, (String)"animationBuilder.interpolator");
        return new Animation<Point2D>(this, this.animationBuilder, (AnimatedValue)new AnimatedPoint2D(this.startScale, this.endScale, interpolator)){
            final /* synthetic */ ScaleAnimationBuilder this$0;

            public void onProgress(@NotNull Point2D value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                List<Entity> list = ScaleAnimationBuilder.access$getAnimationBuilder$p(this.this$0).getEntities();
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"animationBuilder.entities");
                Iterable $receiver$iv = list;
                for (T element$iv : $receiver$iv) {
                    Entity it = (Entity)element$iv;
                    it.setScaleX(value.getX());
                    it.setScaleY(value.getY());
                }
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2);
            }
        };
    }

    @NotNull
    public final Animation<?> buildAndPlay() {
        Animation<?> anim = this.build();
        anim.startInPlayState();
        return anim;
    }

    public ScaleAnimationBuilder(@NotNull AnimationBuilder animationBuilder) {
        Intrinsics.checkParameterIsNotNull((Object)animationBuilder, (String)"animationBuilder");
        this.animationBuilder = animationBuilder;
        this.startScale = new Point2D(1.0, 1.0);
        this.endScale = new Point2D(1.0, 1.0);
    }

    @NotNull
    public static final /* synthetic */ AnimationBuilder access$getAnimationBuilder$p(ScaleAnimationBuilder $this) {
        return $this.animationBuilder;
    }
}

