/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.component;

import com.almasb.fxgl.entity.CopyableComponent;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.component.BooleanComponent;
import com.almasb.fxgl.entity.component.Required;
import com.almasb.fxgl.entity.component.ViewComponent;
import com.almasb.fxgl.entity.view.EntityView;

@Required(value=ViewComponent.class)
public class SelectableComponent
extends BooleanComponent
implements CopyableComponent<SelectableComponent> {
    public SelectableComponent(boolean value) {
        super(value);
    }

    @Override
    public void onAdded(Entity entity) {
        ViewComponent view = this.getEntity().getComponent(ViewComponent.class);
        this.valueProperty().addListener((o, wasSelectable, isSelectable) -> {
            if (isSelectable.booleanValue()) {
                this.attachSelectListener(view.getView());
            } else {
                this.removeSelectListener(view.getView());
            }
        });
        if (this.getValue()) {
            this.attachSelectListener(view.getView());
        }
    }

    @Override
    public void onRemoved(Entity entity) {
        ViewComponent view = this.getEntity().getComponent(ViewComponent.class);
        this.removeSelectListener(view.getView());
    }

    private void attachSelectListener(EntityView view) {
        view.setOnMousePressed(e -> this.getEntity().getWorld().selectedEntityProperty().set((Object)this.getEntity()));
    }

    private void removeSelectListener(EntityView view) {
        view.setOnMousePressed(null);
        this.getEntity().getWorld().getSelectedEntity().ifPresent(e -> {
            if (e == this.getEntity()) {
                this.getEntity().getWorld().selectedEntityProperty().set(null);
            }
        });
    }

    @Override
    public SelectableComponent copy() {
        return new SelectableComponent(this.getValue());
    }
}

