/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.component;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.entity.Component;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.RenderLayer;
import com.almasb.fxgl.entity.component.BoundingBoxComponent;
import com.almasb.fxgl.entity.component.CoreComponent;
import com.almasb.fxgl.entity.component.PositionComponent;
import com.almasb.fxgl.entity.component.RotationComponent;
import com.almasb.fxgl.entity.view.EntityView;
import com.almasb.fxgl.physics.BoundingShape;
import com.almasb.fxgl.physics.HitBox;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;

@CoreComponent
public class ViewComponent
extends Component {
    private static Color showBBoxColor = Color.RED;
    private final EntityView view = new EntityView();
    private PositionComponent position;
    private RotationComponent rotation;
    private Group debugBBox = new Group();
    private ListChangeListener<? super HitBox> hitboxListener = c -> {
        this.debugBBox.getChildren().clear();
        c.getList().forEach(this::addDebugView);
    };

    public static void setShowBBoxColor(Color showBBoxColor) {
        ViewComponent.showBBoxColor = showBBoxColor;
    }

    private boolean showBBox() {
        return FXGL.getBoolean("dev.showbbox");
    }

    public final void turnOnDebugBBox(boolean on) {
        if (!on) {
            this.removeDebugBBox();
            return;
        }
        this.addDebugBBox();
    }

    public ViewComponent() {
    }

    public ViewComponent(Node graphics) {
        this.view.addNode(graphics);
    }

    public ViewComponent(RenderLayer renderLayer) {
        this.view.setRenderLayer(renderLayer);
    }

    public ViewComponent(Node graphics, RenderLayer renderLayer) {
        this.view.addNode(graphics);
        this.view.setRenderLayer(renderLayer);
    }

    public RenderLayer getRenderLayer() {
        return this.view.getRenderLayer();
    }

    public ObjectProperty<RenderLayer> renderLayerProperty() {
        return this.view.renderLayerProperty();
    }

    public void setRenderLayer(RenderLayer renderLayer) {
        this.view.setRenderLayer(renderLayer);
    }

    public EntityView getView() {
        return this.view;
    }

    public void setView(Node view) {
        this.setView(view, false);
    }

    public void setView(Node view, boolean generateBoundingBox) {
        EntityView entityView = view instanceof EntityView ? (EntityView)view : new EntityView(view);
        this.view.getNodes().setAll(entityView.getNodes());
        this.setRenderLayer(entityView.getRenderLayer());
        if (this.showBBox()) {
            this.view.addNode((Node)this.debugBBox);
        }
        if (generateBoundingBox) {
            this.generateBBox();
        }
    }

    public void setTexture(String textureName) {
        this.setTexture(textureName, false);
    }

    public void setTexture(String textureName, boolean generateBoundingBox) {
        EntityView view = new EntityView((Node)FXGL.getAssetLoader().loadTexture(textureName));
        this.setView((Node)view, generateBoundingBox);
    }

    @Override
    public void onAdded(Entity entity) {
        this.bindView();
        if (this.showBBox()) {
            this.turnOnDebugBBox(true);
        }
    }

    @Override
    public void onRemoved(Entity entity) {
        this.view.dispose();
    }

    private void bindView() {
        this.getView().translateXProperty().bind((ObservableValue)this.position.xProperty());
        this.getView().translateYProperty().bind((ObservableValue)this.position.yProperty());
        this.getView().rotateProperty().bind((ObservableValue)this.rotation.valueProperty());
    }

    private void generateBBox() {
        this.getEntity().getBoundingBoxComponent().clearHitBoxes();
        this.getEntity().getBoundingBoxComponent().addHitBox(new HitBox("__VIEW__", BoundingShape.box(this.getView().getLayoutBounds().getWidth(), this.getView().getLayoutBounds().getHeight())));
    }

    private void addDebugBBox() {
        BoundingBoxComponent bbox = this.getEntity().getBoundingBoxComponent();
        bbox.hitBoxesProperty().addListener(this.hitboxListener);
        bbox.hitBoxesProperty().forEach(this::addDebugView);
        this.getView().addNode((Node)this.debugBBox);
    }

    private void addDebugView(HitBox hitBox) {
        Circle view = null;
        if (hitBox.getShape().isCircle()) {
            double radius = hitBox.getWidth() / 2.0;
            view = new Circle(radius, radius, radius, null);
        } else if (hitBox.getShape().isRectangle()) {
            view = new Rectangle(hitBox.getWidth(), hitBox.getHeight(), null);
        }
        if (view != null) {
            view.setStroke((Paint)showBBoxColor);
            view.setTranslateX(hitBox.getMinX());
            view.setTranslateY(hitBox.getMinY());
            this.debugBBox.getChildren().add((Object)view);
        }
    }

    private void removeDebugBBox() {
        BoundingBoxComponent bbox = this.getEntity().getBoundingBoxComponent();
        bbox.hitBoxesProperty().removeListener(this.hitboxListener);
        this.debugBBox.getChildren().clear();
        this.getView().removeNode((Node)this.debugBBox);
    }

    public String toString() {
        return "View(" + this.getRenderLayer().name() + ")";
    }
}

