/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.view;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.entity.RenderLayer;
import com.almasb.fxgl.entity.view.EntityView;
import com.almasb.fxgl.entity.view.ParallaxTexture;
import com.almasb.fxgl.scene.GameScene;
import com.almasb.fxgl.scene.Viewport;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B)\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/almasb/fxgl/entity/view/ParallaxBackgroundView;", "Lcom/almasb/fxgl/entity/view/EntityView;", "textures", "", "Lcom/almasb/fxgl/entity/view/ParallaxTexture;", "orientation", "Ljavafx/geometry/Orientation;", "renderLayer", "Lcom/almasb/fxgl/entity/RenderLayer;", "(Ljava/util/List;Ljavafx/geometry/Orientation;Lcom/almasb/fxgl/entity/RenderLayer;)V", "canvas", "Ljavafx/scene/canvas/Canvas;", "g", "Ljavafx/scene/canvas/GraphicsContext;", "getOrientation", "()Ljavafx/geometry/Orientation;", "redraw", "", "redrawX", "redrawY", "fxgl"})
public final class ParallaxBackgroundView
extends EntityView {
    private final Canvas canvas;
    private final GraphicsContext g;
    private final List<ParallaxTexture> textures;
    @NotNull
    private final Orientation orientation;

    private final void redraw() {
        this.g.clearRect(0.0, 0.0, this.canvas.getWidth(), this.canvas.getHeight());
        if (Intrinsics.areEqual((Object)this.orientation, (Object)Orientation.HORIZONTAL)) {
            this.redrawX();
        } else {
            this.redrawY();
        }
    }

    private final void redrawX() {
        Iterable $receiver$iv = this.textures;
        for (Object element$iv : $receiver$iv) {
            boolean overflowX;
            ParallaxTexture it = (ParallaxTexture)element$iv;
            double w = this.canvas.getWidth();
            double h = this.canvas.getHeight();
            double d = it.getSx$fxgl() + w;
            Image image = it.getImage();
            Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"it.image");
            boolean bl = overflowX = d > image.getWidth();
            if (overflowX) {
                Image image2 = it.getImage();
                Intrinsics.checkExpressionValueIsNotNull((Object)image2, (String)"it.image");
                w = image2.getWidth() - it.getSx$fxgl();
            }
            this.g.drawImage(it.getImage(), it.getSx$fxgl(), it.getSy$fxgl(), w, h, 0.0, 0.0, w, h);
            if (!overflowX) continue;
            this.g.drawImage(it.getImage(), 0.0, 0.0, this.canvas.getWidth() - w, h, w, 0.0, this.canvas.getWidth() - w, h);
        }
    }

    private final void redrawY() {
        Iterable $receiver$iv = this.textures;
        for (Object element$iv : $receiver$iv) {
            boolean overflowY;
            ParallaxTexture it = (ParallaxTexture)element$iv;
            double w = this.canvas.getWidth();
            double h = this.canvas.getHeight();
            double d = it.getSy$fxgl() + h;
            Image image = it.getImage();
            Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"it.image");
            boolean bl = overflowY = d > image.getHeight();
            if (overflowY) {
                Image image2 = it.getImage();
                Intrinsics.checkExpressionValueIsNotNull((Object)image2, (String)"it.image");
                h = image2.getHeight() - it.getSy$fxgl();
            }
            this.g.drawImage(it.getImage(), it.getSx$fxgl(), it.getSy$fxgl(), w, h, 0.0, 0.0, w, h);
            if (!overflowY) continue;
            this.g.drawImage(it.getImage(), 0.0, 0.0, w, this.canvas.getHeight() - h, 0.0, h, w, this.canvas.getHeight() - h);
        }
    }

    @NotNull
    public final Orientation getOrientation() {
        return this.orientation;
    }

    @JvmOverloads
    public ParallaxBackgroundView(@NotNull List<ParallaxTexture> textures, @NotNull Orientation orientation, @NotNull RenderLayer renderLayer) {
        Intrinsics.checkParameterIsNotNull(textures, (String)"textures");
        Intrinsics.checkParameterIsNotNull((Object)orientation, (String)"orientation");
        Intrinsics.checkParameterIsNotNull((Object)renderLayer, (String)"renderLayer");
        super(renderLayer);
        this.textures = textures;
        this.orientation = orientation;
        GameScene gameScene2 = FXGL.Companion.getApp().getGameScene();
        Intrinsics.checkExpressionValueIsNotNull((Object)gameScene2, (String)"FXGL.getApp().gameScene");
        Viewport viewport = gameScene2.getViewport();
        this.canvas = new Canvas(viewport.getWidth(), viewport.getHeight());
        GraphicsContext graphicsContext = this.canvas.getGraphicsContext2D();
        Intrinsics.checkExpressionValueIsNotNull((Object)graphicsContext, (String)"canvas.graphicsContext2D");
        this.g = graphicsContext;
        if (Intrinsics.areEqual((Object)this.orientation, (Object)Orientation.HORIZONTAL)) {
            this.translateXProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public final void changed(ObservableValue<? extends Number> $noName_0, Number $noName_1, Number x) {
                    if (x.intValue() < 0) {
                        throw (Throwable)new IllegalStateException("Background x cannot be < 0");
                    }
                    Iterable $receiver$iv = textures;
                    for (Object element$iv : $receiver$iv) {
                        ParallaxTexture it = (ParallaxTexture)element$iv;
                        double d = x.doubleValue() * it.getSpeed();
                        Image image = it.getTexture().getImage();
                        Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"it.texture.image");
                        it.setSx$fxgl(d % image.getWidth());
                    }
                    this.redraw();
                }
            });
            this.translateXProperty().bind((ObservableValue)viewport.xProperty());
        } else {
            this.translateYProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public final void changed(ObservableValue<? extends Number> $noName_0, Number $noName_1, Number y) {
                    if (y.intValue() < 0) {
                        throw (Throwable)new IllegalStateException("Background y cannot be < 0");
                    }
                    Iterable $receiver$iv = textures;
                    for (Object element$iv : $receiver$iv) {
                        ParallaxTexture it = (ParallaxTexture)element$iv;
                        double d = y.doubleValue() * it.getSpeed();
                        Image image = it.getTexture().getImage();
                        Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"it.texture.image");
                        it.setSy$fxgl(d % image.getHeight());
                    }
                    this.redraw();
                }
            });
            this.translateYProperty().bind((ObservableValue)viewport.yProperty());
        }
        this.addNode((Node)this.canvas);
        this.redraw();
    }

    @JvmOverloads
    public /* synthetic */ ParallaxBackgroundView(List list, Orientation orientation, RenderLayer renderLayer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            orientation = Orientation.HORIZONTAL;
        }
        if ((n & 4) != 0) {
            RenderLayer renderLayer2 = RenderLayer.BACKGROUND;
            Intrinsics.checkExpressionValueIsNotNull((Object)renderLayer2, (String)"RenderLayer.BACKGROUND");
            renderLayer = renderLayer2;
        }
        this(list, orientation, renderLayer);
    }

    @JvmOverloads
    public ParallaxBackgroundView(@NotNull List<ParallaxTexture> textures, @NotNull Orientation orientation) {
        this(textures, orientation, null, 4, null);
    }

    @JvmOverloads
    public ParallaxBackgroundView(@NotNull List<ParallaxTexture> textures) {
        this(textures, null, null, 6, null);
    }
}

