/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.entity.Control;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.component.Required;
import com.almasb.fxgl.physics.PhysicsComponent;
import com.almasb.fxgl.physics.PhysicsWorld;
import com.almasb.fxgl.physics.box2d.dynamics.Body;
import javafx.geometry.Point2D;

@Required(value=PhysicsComponent.class)
public class PhysicsControl
extends Control {
    private Body body;
    private PhysicsWorld physicsWorld;
    private double appHeight;

    PhysicsControl(double appHeight) {
        this.appHeight = appHeight;
        this.physicsWorld = FXGL.getApp().getPhysicsWorld();
    }

    @Override
    public void onAdded(Entity entity) {
        this.body = entity.getComponent(PhysicsComponent.class).body;
    }

    @Override
    public void onUpdate(Entity entity, double tpf) {
        double minXWorld = this.toPixels(this.body.getPosition().x - this.toMeters(entity.getWidth() / 2.0));
        double minYWorld = this.toPixels(this.toMeters(this.appHeight) - this.body.getPosition().y - this.toMeters(entity.getHeight() / 2.0));
        entity.setX(Math.round(minXWorld - entity.getBoundingBoxComponent().getMinXLocal()));
        entity.setY(Math.round(minYWorld - entity.getBoundingBoxComponent().getMinYLocal()));
        entity.setRotation(-Math.toDegrees(this.body.getAngle()));
    }

    public void reposition(Point2D point) {
        double w = this.getEntity().getWidth();
        double h = this.getEntity().getHeight();
        this.body.setTransform(new Vec2(this.toMeters(point.getX() + w / 2.0), this.toMeters(this.appHeight - (point.getY() + h / 2.0))), this.body.getAngle());
    }

    private float toMeters(double pixels) {
        return this.physicsWorld.toMeters(pixels);
    }

    private float toPixels(double meters) {
        return this.physicsWorld.toPixels(meters);
    }
}

