/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.scene;

import com.almasb.fxgl.asset.FXGLAssets;
import com.almasb.fxgl.core.collection.Array;
import com.almasb.fxgl.core.collection.UnorderedArray;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.effect.ParticleControl;
import com.almasb.fxgl.entity.Control;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.EntityWorldListener;
import com.almasb.fxgl.entity.ModuleListener;
import com.almasb.fxgl.entity.RenderLayer;
import com.almasb.fxgl.entity.component.DrawableComponent;
import com.almasb.fxgl.entity.component.ViewComponent;
import com.almasb.fxgl.entity.view.EntityView;
import com.almasb.fxgl.physics.PhysicsParticleControl;
import com.almasb.fxgl.scene.FXGLScene;
import com.almasb.fxgl.scene.Viewport;
import com.almasb.fxgl.ui.UI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.effect.BlendMode;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;

public final class GameScene
extends FXGLScene
implements EntityWorldListener,
ModuleListener {
    private static final Logger log = Logger.get("FXGL.GameScene");
    private Group gameRoot = new Group();
    private Canvas particlesCanvas = new Canvas();
    private GraphicsContext particlesGC = this.particlesCanvas.getGraphicsContext2D();
    private Array<ParticleControl> particles = new UnorderedArray<ParticleControl>(16);
    private Array<Entity> drawables = new UnorderedArray<Entity>(128);
    private Group uiRoot = new Group();
    private Text profilerText = new Text();
    private boolean wasDirty = false;

    public Text getProfilerText() {
        return this.profilerText;
    }

    protected GameScene(int width, int height) {
        this.getContentRoot().getChildren().addAll((Object[])new Node[]{this.gameRoot, this.particlesCanvas, this.uiRoot});
        this.initProfilerText(0.0, height - 120);
        this.initParticlesCanvas(width, height);
        this.initViewport(width, height);
        log.debug("Game scene initialized: " + width + "x" + height);
    }

    private void initProfilerText(double x, double y) {
        this.profilerText.setFont(FXGLAssets.UI_MONO_FONT.newFont(20.0));
        this.profilerText.setFill((Paint)Color.RED);
        this.profilerText.setTranslateX(x);
        this.profilerText.setTranslateY(y);
        this.uiRoot.getChildren().add((Object)this.profilerText);
    }

    private void initParticlesCanvas(double w, double h) {
        this.particlesCanvas.setWidth(w);
        this.particlesCanvas.setHeight(h);
        this.particlesCanvas.setMouseTransparent(true);
    }

    private void initViewport(double w, double h) {
        Viewport viewport = this.getViewport();
        this.gameRoot.layoutXProperty().bind((ObservableValue)viewport.xProperty().negate());
        this.gameRoot.layoutYProperty().bind((ObservableValue)viewport.yProperty().negate());
        Scale scale = new Scale();
        scale.pivotXProperty().bind((ObservableValue)viewport.xProperty());
        scale.pivotYProperty().bind((ObservableValue)viewport.yProperty());
        scale.xProperty().bind((ObservableValue)viewport.zoomProperty());
        scale.yProperty().bind((ObservableValue)viewport.zoomProperty());
        this.gameRoot.getTransforms().add((Object)scale);
        Rotate rotate = new Rotate(0.0, Rotate.Z_AXIS);
        rotate.pivotXProperty().bind((ObservableValue)viewport.xProperty().add(w / 2.0));
        rotate.pivotYProperty().bind((ObservableValue)viewport.yProperty().add(h / 2.0));
        rotate.angleProperty().bind((ObservableValue)viewport.angleProperty().negate());
        this.gameRoot.getTransforms().add((Object)rotate);
    }

    public ObservableList<Node> getUINodes() {
        return this.uiRoot.getChildrenUnmodifiable();
    }

    public void addUINode(Node node) {
        this.uiRoot.getChildren().add((Object)node);
    }

    public void addUINodes(Node ... nodes) {
        for (Node node : nodes) {
            this.addUINode(node);
        }
    }

    public boolean removeUINode(Node n) {
        return this.uiRoot.getChildren().remove((Object)n);
    }

    public void removeUINodes(Node ... nodes) {
        for (Node node : nodes) {
            this.removeUINode(node);
        }
    }

    public void addUI(UI ui) {
        this.addUINode((Node)ui.getRoot());
    }

    public void removeUI(UI ui) {
        this.removeUINode((Node)ui.getRoot());
    }

    public void addGameView(EntityView view) {
        this.getRenderGroup(view.getRenderLayer()).getChildren().add((Object)view);
    }

    public void removeGameView(EntityView view) {
        this.getRenderGroup(view.getRenderLayer()).getChildren().remove((Object)view);
    }

    public void clearGameViews() {
        this.gameRoot.getChildren().clear();
    }

    public void clearUINodes() {
        this.uiRoot.getChildren().clear();
    }

    public void setUIMouseTransparent(boolean b) {
        this.uiRoot.setMouseTransparent(b);
    }

    public GraphicsContext getGraphicsContext() {
        return this.particlesGC;
    }

    private Group getRenderGroup(RenderLayer layer) {
        Integer renderLayer = layer.index();
        Group group = this.gameRoot.getChildren().stream().filter(n -> ((Integer)n.getUserData()).intValue() == renderLayer.intValue()).findAny().map(n -> (Group)n).orElse(new Group());
        if (group.getUserData() == null) {
            log.debug("Creating render group for layer: " + layer.asString());
            group.setUserData((Object)renderLayer);
            this.gameRoot.getChildren().add((Object)group);
        }
        ArrayList<Node> tmpGroups = new ArrayList<Node>((Collection<Node>)this.gameRoot.getChildren());
        tmpGroups.sort(Comparator.comparingInt(g -> (Integer)g.getUserData()));
        this.gameRoot.getChildren().setAll(tmpGroups);
        return group;
    }

    public void onUpdate(double tpf) {
        boolean dirty;
        this.getViewport().onUpdate(tpf);
        boolean bl = dirty = this.drawables.isNotEmpty() || this.particles.isNotEmpty();
        if (dirty || this.wasDirty) {
            this.particlesGC.setGlobalAlpha(1.0);
            this.particlesGC.setGlobalBlendMode(BlendMode.SRC_OVER);
            this.particlesGC.clearRect(0.0, 0.0, this.getWidth(), this.getHeight());
            this.wasDirty = false;
        }
        for (Entity e : this.drawables) {
            DrawableComponent drawable = e.getComponent(DrawableComponent.class);
            if (drawable == null) continue;
            drawable.draw(this.particlesGC);
        }
        for (ParticleControl particle : this.particles) {
            particle.renderParticles(this.particlesGC, this.getViewport().getOrigin());
        }
        this.wasDirty = dirty;
    }

    public void clear() {
        log.debug("Clearing game scene");
        this.getViewport().unbind();
        this.drawables.clear();
        this.particles.clear();
        this.gameRoot.getChildren().clear();
        this.uiRoot.getChildren().clear();
        this.uiRoot.getChildren().add((Object)this.profilerText);
    }

    @Override
    public void onEntityAdded(Entity entity) {
        this.initView(entity.getViewComponent());
        entity.getComponentOptional(DrawableComponent.class).ifPresent(c -> this.drawables.add(entity));
        entity.addModuleListener(this);
        entity.getControlOptional(ParticleControl.class).ifPresent(this.particles::add);
        entity.getControlOptional(PhysicsParticleControl.class).ifPresent(this.particles::add);
    }

    @Override
    public void onEntityRemoved(Entity entity) {
        this.destroyView(entity.getViewComponent());
        entity.getComponentOptional(DrawableComponent.class).ifPresent(c -> this.drawables.removeValueByIdentity(entity));
        entity.removeModuleListener(this);
        entity.getControlOptional(ParticleControl.class).ifPresent(p -> this.particles.removeValueByIdentity((ParticleControl)p));
        entity.getControlOptional(PhysicsParticleControl.class).ifPresent(p -> this.particles.removeValueByIdentity((ParticleControl)p));
    }

    private void initView(ViewComponent viewComponent) {
        EntityView view = viewComponent.getView();
        this.addGameView(view);
        viewComponent.renderLayerProperty().addListener((o, oldLayer, newLayer) -> {
            this.getRenderGroup((RenderLayer)oldLayer).getChildren().remove((Object)view);
            this.getRenderGroup((RenderLayer)newLayer).getChildren().add((Object)view);
        });
    }

    private void destroyView(ViewComponent viewComponent) {
        EntityView view = viewComponent.getView();
        this.removeGameView(view);
    }

    @Override
    public void onAdded(Control control) {
        if (control instanceof PhysicsParticleControl) {
            PhysicsParticleControl particleControl = (PhysicsParticleControl)control;
            this.particles.add(particleControl);
        }
    }

    @Override
    public void onRemoved(Control control) {
        if (control instanceof PhysicsParticleControl) {
            this.particles.removeValueByIdentity((PhysicsParticleControl)control);
        }
    }
}

